#
# TABLE STRUCTURE FOR: alumni_events
#

DROP TABLE IF EXISTS `alumni_events`;

CREATE TABLE `alumni_events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `session_id` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `section` varchar(255) NOT NULL,
  `from_date` datetime NOT NULL,
  `to_date` datetime NOT NULL,
  `note` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `is_active` int NOT NULL,
  `event_notification_message` text NOT NULL,
  `show_onwebsite` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `alumni_events_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `alumni_events_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: alumni_students
#

DROP TABLE IF EXISTS `alumni_students`;

CREATE TABLE `alumni_students` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_id` int NOT NULL,
  `current_email` varchar(255) NOT NULL,
  `current_phone` varchar(255) NOT NULL,
  `occupation` text NOT NULL,
  `address` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `alumni_students_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: attendence_type
#

DROP TABLE IF EXISTS `attendence_type`;

CREATE TABLE `attendence_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `key_value` varchar(50) NOT NULL,
  `long_lang_name` varchar(250) DEFAULT NULL,
  `long_name_style` varchar(250) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `for_qr_attendance` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (1, 'Present', '<b class=\"text text-success\">P</b>', 'present', 'label label-success', 'yes', 1, '2023-12-13 09:53:10', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (2, 'Late With Excuse', '<b class=\"text text-warning\">E</b>', 'late_with_excuse', 'label label-warning text-dark', 'no', 0, '2023-12-13 09:51:03', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (3, 'Late', '<b class=\"text text-warning\">L</b>', 'late', 'label label-warning text-dark', 'yes', 1, '2023-12-13 09:51:09', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (4, 'Absent', '<b class=\"text text-danger\">A</b>', 'absent', 'label label-danger', 'yes', 0, '2023-12-15 08:18:05', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (5, 'Holiday', 'H', 'holiday', 'label label-info', 'yes', 0, '2023-12-14 14:57:13', '0000-00-00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `created_at`, `updated_at`) VALUES (6, 'Half Day', '<b class=\"text text-warning\">F</b>', 'half_day', 'label label-warning text-dark', 'yes', 1, '2023-12-15 08:18:37', '0000-00-00');


#
# TABLE STRUCTURE FOR: book_issues
#

DROP TABLE IF EXISTS `book_issues`;

CREATE TABLE `book_issues` (
  `id` int NOT NULL AUTO_INCREMENT,
  `book_id` int NOT NULL,
  `member_id` int DEFAULT NULL,
  `duereturn_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `is_returned` int DEFAULT '0',
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `book_id` (`book_id`),
  KEY `member_id` (`member_id`),
  CONSTRAINT `book_issues_ibfk_1` FOREIGN KEY (`book_id`) REFERENCES `books` (`id`) ON DELETE CASCADE,
  CONSTRAINT `book_issues_ibfk_2` FOREIGN KEY (`member_id`) REFERENCES `libarary_members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: books
#

DROP TABLE IF EXISTS `books`;

CREATE TABLE `books` (
  `id` int NOT NULL AUTO_INCREMENT,
  `book_title` varchar(100) NOT NULL,
  `book_no` varchar(50) NOT NULL,
  `isbn_no` varchar(100) NOT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `rack_no` varchar(100) NOT NULL,
  `publish` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `qty` int DEFAULT NULL,
  `perunitcost` float(10,2) DEFAULT NULL,
  `postdate` date DEFAULT NULL,
  `description` text,
  `available` varchar(10) DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2021-01-19 10:10:29');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-01-19 10:10:31');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'admission', 0, '2021-01-19 06:48:11');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (4, 'complain', 0, '2021-01-19 06:48:13');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (5, 'contact_us', 0, '2021-01-19 06:48:15');


#
# TABLE STRUCTURE FOR: categories
#

DROP TABLE IF EXISTS `categories`;

CREATE TABLE `categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category` varchar(100) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text NOT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) DEFAULT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = students',
  `status` tinyint(1) NOT NULL,
  `header_height` int NOT NULL,
  `content_height` int NOT NULL,
  `footer_height` int NOT NULL,
  `content_width` int NOT NULL,
  `enable_student_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_student_image`, `enable_image_height`, `created_at`, `updated_at`) VALUES (1, 'Sample Transfer Certificate', 'This is certify that <b>[name]</b> has born on [dob]  <br> and have following details [present_address] [guardian] [created_at] [admission_no] [roll_no] [class] [section] [gender] [admission_date] [category] [cast] [father_name] [mother_name] [religion] [email] [phone] .<br>We wish best of luck for future endeavors.', 'Reff. No.....1111111.........', 'To Whomever It May Concern', 'Date: _10__/_10__/__2019__', '.................................<br>admin', '.................................<br>principal', '.................................<br>admin', 'sampletc121.png', 2, 1, 360, 400, 480, 810, 1, 230, '2019-12-21 17:14:34', '0000-00-00');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `chat_user_one` int NOT NULL,
  `chat_user_two` int NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message` text,
  `chat_user_id` int NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int NOT NULL,
  `is_first` int DEFAULT '0',
  `is_read` int NOT NULL DEFAULT '0',
  `chat_connection_id` int NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `student_id` int DEFAULT NULL,
  `create_staff_id` int DEFAULT NULL,
  `create_student_id` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `student_id` (`student_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_student_id` (`create_student_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: class_section_times
#

DROP TABLE IF EXISTS `class_section_times`;

CREATE TABLE `class_section_times` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class_section_id` int DEFAULT NULL,
  `time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `class_section_id` (`class_section_id`),
  CONSTRAINT `class_section_times_ibfk_1` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: class_sections
#

DROP TABLE IF EXISTS `class_sections`;

CREATE TABLE `class_sections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class_id` int DEFAULT NULL,
  `section_id` int DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  CONSTRAINT `class_sections_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_sections_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 1, 'no', '2024-12-06 06:31:51', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 2, 2, 'no', '2024-12-06 06:33:25', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (3, 3, 1, 'no', '2024-12-06 06:33:56', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (4, 4, 2, 'no', '2024-12-06 06:34:09', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (5, 5, 1, 'no', '2024-12-06 06:34:51', NULL);


#
# TABLE STRUCTURE FOR: class_teacher
#

DROP TABLE IF EXISTS `class_teacher`;

CREATE TABLE `class_teacher` (
  `id` int NOT NULL AUTO_INCREMENT,
  `session_id` int NOT NULL,
  `class_id` int NOT NULL,
  `section_id` int NOT NULL,
  `staff_id` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  KEY `session_id` (`session_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `class_teacher_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_4` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: classes
#

DROP TABLE IF EXISTS `classes`;

CREATE TABLE `classes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Form 1A', 'no', '2024-12-06 06:33:42', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Form 1B', 'no', '2024-12-06 06:33:25', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Form 2A', 'no', '2024-12-06 06:33:56', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Form 2B', 'no', '2024-12-06 06:34:09', NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Form 3A', 'no', '2024-12-06 06:34:51', NULL);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(255) NOT NULL,
  `source` varchar(255) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: content_types
#

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text,
  `is_active` int DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int DEFAULT NULL,
  `cls_sec_id` int DEFAULT NULL,
  `file` varchar(250) DEFAULT NULL,
  `date` date NOT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `class_id` (`class_id`),
  KEY `cls_sec_id` (`cls_sec_id`),
  CONSTRAINT `contents_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_3` FOREIGN KEY (`cls_sec_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: currencies
#

DROP TABLE IF EXISTS `currencies`;

CREATE TABLE `currencies` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `symbol` varchar(10) DEFAULT NULL,
  `base_price` varchar(10) NOT NULL DEFAULT '1',
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb3;

INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (1, 'AED', 'AED', 'AEDf', '1', 0, '2022-12-30 08:19:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (2, 'AFN', 'AFN', '؋', '1', 0, '2022-12-30 08:19:19');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (3, 'ALL', 'ALL', 'ALL', '1', 0, '2022-12-30 08:19:22');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (4, 'AMD', 'AMD', 'AMD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (5, 'ANG', 'ANG', 'ANG', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (6, 'AOA', 'AOA', 'AOA', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (7, 'ARS', 'ARS', 'ARS', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (8, 'AUD', 'AUD', 'AUD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (9, 'AWG', 'AWG', 'AWG', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (10, 'AZN', 'AZN', 'AZN', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (11, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (12, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (13, 'BDT', 'BDT', 'BDT', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (14, 'BGN', 'BGN', 'BGN', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (15, 'BHD', 'BHD', 'BHD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (16, 'BIF', 'BIF', 'BIF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (17, 'BMD', 'BMD', 'BMD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (18, 'BND', 'BND', 'BND', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (19, 'BOB', 'BOB', 'BOB', '1', 0, '2022-12-30 08:19:29');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (20, 'BOV', 'BOV', 'BOV', '1', 0, '2022-12-30 08:19:38');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (21, 'BRL', 'BRL', 'BRL', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (22, 'BSD', 'BSD', 'BSD', '1', 0, '2022-12-30 08:19:40');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (23, 'BTN', 'BTN', 'BTN', '1', 0, '2022-12-30 08:19:42');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (24, 'BWP', 'BWP', 'BWP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (25, 'BYN', 'BYN', 'BYN', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (26, 'BYR', 'BYR', 'BYR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (27, 'BZD', 'BZD', 'BZD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (28, 'CAD', 'CAD', 'CAD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (29, 'CDF', 'CDF', 'CDF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (30, 'CHE', 'CHE', 'CHE', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (31, 'CHF', 'CHF', 'CHF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (32, 'CHW', 'CHW', 'CHW', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (33, 'CLF', 'CLF', 'CLF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (34, 'CLP', 'CLP', 'CLP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (35, 'CNY', 'CNY', 'CNY', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (36, 'COP', 'COP', 'COP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (37, 'COU', 'COU', 'COU', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (38, 'CRC', 'CRC', 'CRC', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (39, 'CUC', 'CUC', 'CUC', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (40, 'CUP', 'CUP', 'CUP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (41, 'CVE', 'CVE', 'CVE', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (42, 'CZK', 'CZK', 'CZK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (43, 'DJF', 'DJF', 'DJF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (44, 'DKK', 'DKK', 'DKK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (45, 'DOP', 'DOP', 'DOP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (46, 'DZD', 'DZD', 'DZD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (47, 'EGP', 'EGP', 'EGP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (48, 'ERN', 'ERN', 'ERN', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (49, 'ETB', 'ETB', 'ETB', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (50, 'EUR', 'EUR', '€', '1', 0, '2022-12-30 08:20:25');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (51, 'FJD', 'FJD', 'FJD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (52, 'FKP', 'FKP', 'FKP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (53, 'GBP', 'GBP', '£', '1', 0, '2022-12-30 08:20:29');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (54, 'GEL', 'GEL', 'GEL', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (55, 'GHS', 'GHS', 'GHS', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (56, 'GIP', 'GIP', 'GIP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (57, 'GMD', 'GMD', 'GMD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (58, 'GNF', 'GNF', 'GNF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (59, 'GTQ', 'GTQ', 'GTQ', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (60, 'GYD', 'GYD', 'GYD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (61, 'HKD', 'HKD', 'HKD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (62, 'HNL', 'HNL', 'HNL', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (63, 'HRK', 'HRK', 'HRK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (64, 'HTG', 'HTG', 'HTG', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (65, 'HUF', 'HUF', 'HUF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (66, 'IDR', 'IDR', 'IDR', '1', 0, '2022-12-30 08:20:34');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (67, 'ILS', 'ILS', 'ILS', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (68, 'INR', 'INR', '₹', '1', 0, '2022-12-30 08:20:37');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (69, 'IQD', 'IQD', 'IQD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (70, 'IRR', 'IRR', 'IRR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (71, 'ISK', 'ISK', 'ISK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (72, 'JMD', 'JMD', 'JMD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (73, 'JOD', 'JOD', 'JOD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (74, 'JPY', 'JPY', 'JPY', '1', 0, '2022-12-30 08:19:56');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (75, 'KES', 'KES', 'KES', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (76, 'KGS', 'KGS', 'KGS', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (77, 'KHR', 'KHR', 'KHR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (78, 'KMF', 'KMF', 'KMF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (79, 'KPW', 'KPW', 'KPW', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (80, 'KRW', 'KRW', 'KRW', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (81, 'KWD', 'KWD', 'KWD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (82, 'KYD', 'KYD', 'KYD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (83, 'KZT', 'KZT', 'KZT', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (84, 'LAK', 'LAK', 'LAK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (85, 'LBP', 'LBP', 'LBP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (86, 'LKR', 'LKR', 'LKR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (87, 'LRD', 'LRD', 'LRD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (88, 'LSL', 'LSL', 'LSL', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (89, 'LYD', 'LYD', 'LYD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (90, 'MAD', 'MAD', 'MAD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (91, 'MDL', 'MDL', 'MDL', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (92, 'MGA', 'MGA', 'MGA', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (93, 'MKD', 'MKD', 'MKD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (94, 'MMK', 'MMK', 'MMK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (95, 'MNT', 'MNT', 'MNT', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (96, 'MOP', 'MOP', 'MOP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (97, 'MRO', 'MRO', 'MRO', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (98, 'MUR', 'MUR', 'MUR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (99, 'MVR', 'MVR', 'MVR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (100, 'MWK', 'MWK', 'MWK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (101, 'MXN', 'MXN', 'MXN', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (102, 'MXV', 'MXV', 'MXV', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (103, 'MYR', 'MYR', 'MYR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (104, 'MZN', 'MZN', 'MZN', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (105, 'NAD', 'NAD', 'NAD', '1', 0, '2022-07-30 11:32:37');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (106, 'NGN', 'NGN', 'NGN', '1', 0, '2022-12-30 08:20:42');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (107, 'NIO', 'NIO', 'NIO', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (108, 'NOK', 'NOK', 'NOK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (109, 'NPR', 'NPR', 'NPR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (110, 'NZD', 'NZD', 'NZD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (111, 'OMR', 'OMR', 'OMR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (112, 'PAB', 'PAB', 'PAB', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (113, 'PEN', 'PEN', 'PEN', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (114, 'PGK', 'PGK', 'PGK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (115, 'PHP', 'PHP', 'PHP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (116, 'PKR', 'PKR', 'PKR', '1', 0, '2022-12-30 08:20:19');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (117, 'PLN', 'PLN', 'PLN', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (118, 'PYG', 'PYG', 'PYG', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (119, 'QAR', 'QAR', 'QAR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (120, 'RON', 'RON', 'RON', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (121, 'RSD', 'RSD', 'RSD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (122, 'RUB', 'RUB', 'RUB', '1', 0, '2022-12-30 08:20:16');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (123, 'RWF', 'RWF', 'RWF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (124, 'SAR', 'SAR', 'SAR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (125, 'SBD', 'SBD', 'SBD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (126, 'SCR', 'SCR', 'SCR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (127, 'SDG', 'SDG', 'SDG', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (128, 'SEK', 'SEK', 'SEK', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (129, 'SGD', 'SGD', 'SGD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (130, 'SHP', 'SHP', 'SHP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (131, 'SLL', 'SLL', 'SLL', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (132, 'SOS', 'SOS', 'SOS', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (133, 'SRD', 'SRD', 'SRD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (134, 'SSP', 'SSP', 'SSP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (135, 'STD', 'STD', 'STD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (136, 'SVC', 'SVC', 'SVC', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (137, 'SYP', 'SYP', 'SYP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (138, 'SZL', 'SZL', 'SZL', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (139, 'THB', 'THB', 'THB', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (140, 'TJS', 'TJS', 'TJS', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (141, 'TMT', 'TMT', 'TMT', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (142, 'TND', 'TND', 'TND', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (143, 'TOP', 'TOP', 'TOP', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (144, 'TRY', 'TRY', 'TRY', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (145, 'TTD', 'TTD', 'TTD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (146, 'TWD', 'TWD', 'TWD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (147, 'TZS', 'TZS', 'TZS', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (148, 'UAH', 'UAH', 'UAH', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (149, 'UGX', 'UGX', 'UGX', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (150, 'USD', 'USD', '$', '1', 1, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (151, 'USN', 'USN', 'USN', '1', 0, '2022-12-30 08:20:03');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (152, 'UYI', 'UYI', 'UYI', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (153, 'UYU', 'UYU', 'UYU', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (154, 'UZS', 'UZS', 'UZS', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (155, 'VEF', 'VEF', 'VEF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (156, 'VND', 'VND', 'VND', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (157, 'VUV', 'VUV', 'VUV', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (158, 'WST', 'WST', 'WST', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (159, 'XAF', 'XAF', 'XAF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (160, 'XAG', 'XAG', 'XAG', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (161, 'XAU', 'XAU', 'XAU', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (162, 'XBA', 'XBA', 'XBA', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (163, 'XBB', 'XBB', 'XBB', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (164, 'XBC', 'XBC', 'XBC', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (165, 'XBD', 'XBD', 'XBD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (166, 'XCD', 'XCD', 'XCD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (167, 'XDR', 'XDR', 'XDR', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (168, 'XOF', 'XOF', 'XOF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (169, 'XPD', 'XPD', 'XPD', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (170, 'XPF', 'XPF', 'XPF', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (171, 'XPT', 'XPT', 'XPT', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (172, 'XSU', 'XSU', 'XSU', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (173, 'XTS', 'XTS', 'XTS', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (174, 'XUA', 'XUA', 'XUA', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (175, 'XXX', 'XXX', 'XXX', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (176, 'YER', 'YER', 'YER', '1', 0, '2022-07-22 12:55:15');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (177, 'ZAR', 'ZAR', 'ZAR', '1', 0, '2022-12-30 08:20:07');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (178, 'ZMW', 'ZMW', 'ZMW', '1', 0, '2022-07-30 09:34:00');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`) VALUES (179, 'ZWL', 'ZWL', 'ZWL', '1', 0, '2022-07-22 12:55:15');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int NOT NULL AUTO_INCREMENT,
  `belong_table_id` int DEFAULT NULL,
  `custom_field_id` int DEFAULT NULL,
  `field_value` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `idx_belong_table_id` (`belong_table_id`),
  KEY `idx_field_value` (`field_value`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int DEFAULT NULL,
  `validation` int DEFAULT '0',
  `field_values` text,
  `show_table` varchar(100) DEFAULT NULL,
  `visible_on_table` int NOT NULL,
  `weight` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_belong_to` (`belong_to`),
  KEY `idx_type` (`type`),
  KEY `idx_visible_on_table` (`visible_on_table`),
  KEY `idx_weight` (`weight`),
  FULLTEXT KEY `idx_field_values` (`field_values`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: daily_assignment
#

DROP TABLE IF EXISTS `daily_assignment`;

CREATE TABLE `daily_assignment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `student_session_id` int NOT NULL,
  `subject_group_subject_id` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `attachment` varchar(255) DEFAULT NULL,
  `evaluated_by` int DEFAULT NULL,
  `date` date DEFAULT NULL,
  `evaluation_date` date DEFAULT NULL,
  `remark` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `evaluated_by` (`evaluated_by`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  CONSTRAINT `daily_assignment_ibfk_1` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_2` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_3` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'Administration', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (2, 'Transport', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (3, 'Management', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (4, 'Teaching', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (5, 'Kitchen', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (6, 'General Work', 'yes');


#
# TABLE STRUCTURE FOR: disable_reason
#

DROP TABLE IF EXISTS `disable_reason`;

CREATE TABLE `disable_reason` (
  `id` int NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: email_attachments
#

DROP TABLE IF EXISTS `email_attachments`;

CREATE TABLE `email_attachments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message_id` int NOT NULL,
  `directory` varchar(255) NOT NULL,
  `attachment` varchar(255) NOT NULL,
  `attachment_name` varchar(200) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `message_id` (`message_id`),
  CONSTRAINT `email_attachments_ibfk_1` FOREIGN KEY (`message_id`) REFERENCES `messages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `api_secret` varchar(255) DEFAULT NULL,
  `region` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `api_key`, `api_secret`, `region`, `is_active`, `created_at`) VALUES (1, 'sendmail', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, 'yes', '2020-02-28 15:46:03');


#
# TABLE STRUCTURE FOR: email_template
#

DROP TABLE IF EXISTS `email_template`;

CREATE TABLE `email_template` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: email_template_attachment
#

DROP TABLE IF EXISTS `email_template_attachment`;

CREATE TABLE `email_template_attachment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email_template_id` int NOT NULL,
  `attachment` varchar(100) NOT NULL,
  `attachment_name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` text NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` text NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` int DEFAULT NULL,
  `class_id` int DEFAULT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `assigned` (`assigned`),
  KEY `enquiry_ibfk_4` (`class_id`),
  CONSTRAINT `enquiry_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_3` FOREIGN KEY (`assigned`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_4` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int DEFAULT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_students
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_students`;

CREATE TABLE `exam_group_class_batch_exam_students` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_id` int NOT NULL,
  `student_id` int NOT NULL,
  `student_session_id` int NOT NULL,
  `roll_no` int DEFAULT NULL,
  `teacher_remark` text,
  `rank` int NOT NULL DEFAULT '0',
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_id` (`exam_group_class_batch_exam_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb3;

INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 118, 118, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (2, 1, 119, 119, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (3, 1, 117, 117, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (4, 1, 30, 30, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (5, 1, 31, 31, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (6, 1, 23, 23, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (7, 1, 47, 47, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (8, 1, 24, 24, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (9, 1, 21, 21, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (10, 1, 25, 25, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (11, 1, 26, 26, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (12, 1, 27, 27, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (13, 1, 28, 28, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (14, 1, 29, 29, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (15, 1, 22, 22, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (16, 1, 32, 32, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (17, 1, 33, 33, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (18, 1, 34, 34, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (19, 1, 37, 37, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (20, 1, 39, 39, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (21, 1, 41, 41, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (22, 1, 43, 43, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (23, 1, 45, 45, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (24, 1, 49, 49, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (25, 1, 50, 50, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (26, 1, 52, 52, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (27, 1, 53, 53, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (28, 1, 55, 55, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (29, 1, 57, 57, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (30, 1, 87, 87, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (31, 1, 112, 112, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (32, 1, 114, 114, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (33, 1, 113, 113, NULL, '', 0, 0, '2025-02-25 08:55:58', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (34, 2, 120, 120, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (35, 2, 88, 88, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (36, 2, 97, 97, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (37, 2, 99, 99, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (38, 2, 109, 109, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (39, 2, 92, 92, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (40, 2, 110, 110, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (41, 2, 94, 94, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (42, 2, 104, 104, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (43, 2, 105, 105, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (44, 2, 106, 106, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (45, 2, 108, 108, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (46, 2, 107, 107, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (47, 2, 95, 95, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (48, 2, 101, 101, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (49, 2, 96, 96, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (50, 2, 102, 102, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (51, 2, 100, 100, NULL, NULL, 0, 0, '2025-02-25 09:10:28', NULL);


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_subjects
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_subjects`;

CREATE TABLE `exam_group_class_batch_exam_subjects` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exams_id` int DEFAULT NULL,
  `subject_id` int NOT NULL,
  `date_from` date NOT NULL,
  `time_from` time NOT NULL,
  `duration` varchar(50) NOT NULL,
  `room_no` varchar(100) DEFAULT NULL,
  `max_marks` float(10,2) DEFAULT NULL,
  `min_marks` float(10,2) DEFAULT NULL,
  `credit_hours` float(10,2) DEFAULT '0.00',
  `date_to` datetime DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  KEY `subject_id` (`subject_id`),
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_2` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 1, '2025-02-26', '10:00:00', '2', '1', '100.00', '1.00', '2.00', NULL, 0, '2025-02-25 08:55:29', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (2, 1, 2, '2025-02-26', '09:00:30', '1', '1', '100.00', '1.00', '1.00', NULL, 0, '2025-02-25 09:08:16', NULL);
INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (3, 2, 1, '2025-02-26', '08:00:00', '1', '2', '100.00', '1.00', '1.00', NULL, 0, '2025-02-25 09:11:11', NULL);


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exams
#

DROP TABLE IF EXISTS `exam_group_class_batch_exams`;

CREATE TABLE `exam_group_class_batch_exams` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exam` varchar(250) DEFAULT NULL,
  `passing_percentage` float(10,2) DEFAULT NULL,
  `session_id` int NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `exam_group_id` int DEFAULT NULL,
  `use_exam_roll_no` int NOT NULL DEFAULT '1',
  `is_publish` int DEFAULT '0',
  `is_rank_generated` int NOT NULL DEFAULT '0',
  `description` text,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_ibfk_2` (`session_id`),
  CONSTRAINT `exam_group_class_batch_exams_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exams_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Form 1', NULL, 21, NULL, NULL, 1, 1, 0, 0, 'Mid Term Mathematics', 0, '2025-02-25 09:09:40', NULL);
INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Form 2', NULL, 21, NULL, NULL, 1, 1, 0, 0, 'Mid First Term', 0, '2025-02-25 09:12:05', NULL);


#
# TABLE STRUCTURE FOR: exam_group_exam_connections
#

DROP TABLE IF EXISTS `exam_group_exam_connections`;

CREATE TABLE `exam_group_exam_connections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exam_group_id` int DEFAULT NULL,
  `exam_group_class_batch_exams_id` int DEFAULT NULL,
  `exam_weightage` float(10,2) DEFAULT '0.00',
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  CONSTRAINT `exam_group_exam_connections_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_connections_ibfk_2` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: exam_group_exam_results
#

DROP TABLE IF EXISTS `exam_group_exam_results`;

CREATE TABLE `exam_group_exam_results` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_student_id` int NOT NULL,
  `exam_group_class_batch_exam_subject_id` int DEFAULT NULL,
  `exam_group_student_id` int DEFAULT NULL,
  `attendence` varchar(10) DEFAULT NULL,
  `get_marks` float(10,2) DEFAULT '0.00',
  `note` text,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_subject_id` (`exam_group_class_batch_exam_subject_id`),
  KEY `exam_group_student_id` (`exam_group_student_id`),
  KEY `exam_group_class_batch_exam_student_id` (`exam_group_class_batch_exam_student_id`),
  CONSTRAINT `exam_group_exam_results_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_subject_id`) REFERENCES `exam_group_class_batch_exam_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_2` FOREIGN KEY (`exam_group_student_id`) REFERENCES `exam_group_students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_3` FOREIGN KEY (`exam_group_class_batch_exam_student_id`) REFERENCES `exam_group_class_batch_exam_students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: exam_group_students
#

DROP TABLE IF EXISTS `exam_group_students`;

CREATE TABLE `exam_group_students` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exam_group_id` int DEFAULT NULL,
  `student_id` int DEFAULT NULL,
  `student_session_id` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_students_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: exam_groups
#

DROP TABLE IF EXISTS `exam_groups`;

CREATE TABLE `exam_groups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `exam_type` varchar(250) DEFAULT NULL,
  `description` text,
  `is_active` int DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Mid First Term', 'school_grade_system', 'Mid term', 0, '2025-02-25 08:49:58', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'First End of Term', 'school_grade_system', 'End Term', 0, '2025-02-25 08:50:24', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Mid Secod Term', 'school_grade_system', 'Mid Term', 0, '2025-02-25 08:50:47', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Second End Term', 'school_grade_system', 'End Term', 0, '2025-02-25 08:51:19', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Mid Third Term', 'school_grade_system', 'Mid Term', 0, '2025-02-25 08:51:44', NULL);
INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Third End Term', 'school_grade_system', 'End Term', 0, '2025-02-25 08:52:10', NULL);


#
# TABLE STRUCTURE FOR: exam_schedules
#

DROP TABLE IF EXISTS `exam_schedules`;

CREATE TABLE `exam_schedules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `session_id` int NOT NULL,
  `exam_id` int DEFAULT NULL,
  `teacher_subject_id` int DEFAULT NULL,
  `date_of_exam` date DEFAULT NULL,
  `start_to` varchar(50) DEFAULT NULL,
  `end_from` varchar(50) DEFAULT NULL,
  `room_no` varchar(50) DEFAULT NULL,
  `full_marks` int DEFAULT NULL,
  `passing_marks` int DEFAULT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `teacher_subject_id` (`teacher_subject_id`),
  KEY `session_id` (`session_id`),
  KEY `exam_id` (`exam_id`),
  CONSTRAINT `exam_schedules_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_schedules_ibfk_2` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: exams
#

DROP TABLE IF EXISTS `exams`;

CREATE TABLE `exams` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `sesion_id` int NOT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sesion_id` (`sesion_id`),
  CONSTRAINT `exams_ibfk_1` FOREIGN KEY (`sesion_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb3;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 'Fuel Nissan Caravan AFN (Modester)', '', 'yes', 'no', '2025-01-15 13:41:07', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 'Fuel Sprinter Benz', '', 'yes', 'no', '2024-12-05 18:44:24', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (3, 'Fuel Baby Quantum', '', 'yes', 'no', '2024-12-05 18:44:41', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (4, 'Fuel Managing Director', '', 'yes', 'no', '2024-12-05 18:45:02', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (5, 'Lunch', '', 'yes', 'no', '2024-12-05 18:46:43', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (6, 'Chairman Ecocash', '', 'yes', 'no', '2024-12-05 18:48:10', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (7, 'Salaries', '', 'yes', 'no', '2024-12-05 18:48:53', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (10, 'Stationery', '', 'yes', 'no', '2024-12-05 18:52:25', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (11, 'Detergents', '', 'yes', 'no', '2024-12-05 18:53:07', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (12, 'Construction', '', 'yes', 'no', '2024-12-09 16:05:34', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (16, 'Inspire Pre-school', 'Pre-school', 'yes', 'no', '2025-01-01 21:29:09', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (18, 'Admistrative Expense', 'All Admin Expenses', 'yes', 'no', '2025-01-05 17:40:06', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (19, 'Marketing', '', 'yes', 'no', '2025-01-03 14:37:56', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (20, 'Transport repairs', '', 'yes', 'no', '2025-01-03 14:50:34', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (24, 'Fuel Operations Manager', 'Elson', 'yes', 'no', '2025-01-03 15:58:21', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (25, 'Airtime and Data', '', 'yes', 'no', '2025-01-05 17:39:24', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (26, 'Rydaleridge', '', 'yes', 'no', '2025-01-04 11:43:42', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (30, 'Uniforms', '', 'yes', 'no', '2025-01-05 17:27:18', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (34, 'Fuel Nissan Caravan AGL Vale', '', 'yes', 'no', '2025-01-23 15:55:53', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (35, 'Fuel Civilian', '', 'yes', 'no', '2025-01-05 17:42:52', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (36, 'Rydaleridge ECD', '', 'yes', 'no', '2025-01-10 21:46:50', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (37, 'Salaries', '', 'yes', 'no', '2025-01-21 12:33:29', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (38, 'SPORTS (prim &  college)', '', 'yes', 'no', '2025-02-07 10:04:09', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (39, 'Farms', '', 'yes', 'no', '2025-02-10 12:33:18', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (40, 'White Sprinter ABN 2835', '', 'yes', 'no', '2025-02-18 09:02:41', NULL);
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (41, 'New Komby', '', 'yes', 'no', '2025-02-20 19:33:07', NULL);


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exp_head_id` int DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=468 DEFAULT CHARSET=utf8mb3;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 16, 'Gate deposit', '', '2025-01-01', '300.00', NULL, 'Balance $280 ', 'yes', 'no', '2025-01-01 21:30:45', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 12, 'Primary painting accessories', '308', '2025-01-02', '44.34', NULL, 'Halsteds', 'yes', 'no', '2025-01-02 12:16:36', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (3, 4, 'Isuzu fuel', '325', '2025-01-01', '40.00', NULL, 'Director fuel ', 'yes', 'no', '2025-01-03 14:32:53', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (4, 4, 'Jeep fuel', '324', '2025-01-01', '30.00', NULL, 'Director’s fuel', 'yes', 'no', '2025-01-03 14:34:06', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (5, 10, 'Invoice books', '326', '2025-01-01', '60.00', NULL, 'College invoice books ', 'yes', 'no', '2025-01-03 14:34:49', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (6, 30, 'Sportswear tshirts', '327', '2025-01-01', '60.00', NULL, 'Tshirts', 'yes', 'no', '2025-01-05 17:30:21', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (7, 18, 'Chitoro (lunch)', '328', '2025-01-01', '15.00', NULL, 'Lunch', 'yes', 'no', '2025-01-03 14:37:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (8, 19, 'December Marketing  fuel,caps and lunch', '329', '2025-01-01', '95.00', NULL, 'Fuel and lunch ', 'yes', 'no', '2025-01-04 11:45:55', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (9, 19, 'December Marketing fuel and lunch', '329', '2025-01-01', '60.00', NULL, 'Fuel and lunch ', 'yes', 'no', '2025-01-03 14:40:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (10, 19, 'December marketing fuel and lunch', '329', '2025-01-01', '70.00', NULL, 'Fuel and lunch ', 'yes', 'no', '2025-01-03 14:41:07', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (11, 16, 'Inspire labour painter', '330', '2025-01-01', '220.00', NULL, 'Labour painter', 'yes', 'no', '2025-01-03 14:41:53', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (12, 16, 'Labour electrian', '332', '2025-01-01', '200.00', NULL, 'Inspire labour Electrician ', 'yes', 'no', '2025-01-04 11:45:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (13, 26, 'Rydaleridge Dakar labour', '333', '2025-01-01', '90.00', NULL, 'Rydaleridge builder labour ', 'yes', 'no', '2025-01-04 11:44:36', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (14, 16, 'Inspire Builder Labour ( Nyandoro)', '334', '2025-01-01', '220.00', NULL, 'Inspire Nyandoro ', 'yes', 'no', '2025-01-03 14:45:46', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (15, 16, 'Inspire Cement', '335', '2025-01-01', '24.00', NULL, 'Cement Inspire ', 'yes', 'no', '2025-01-03 14:47:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (16, 12, 'Painter labour Primary block', '336', '2025-01-01', '100.00', NULL, 'Painter labour ', 'yes', 'no', '2025-01-03 14:48:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (17, 20, 'Baby quantum  2 tyres', '337', '2025-01-02', '150.00', NULL, '2 Tyres ', 'yes', 'no', '2025-01-03 14:51:45', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (18, 4, 'Fuel Isuzu', '338', '2025-01-01', '40.00', NULL, 'Director’s fuel ', 'yes', 'no', '2025-01-03 14:52:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (19, 16, 'Inspire doors and lock sets', '322', '2025-01-02', '173.00', NULL, 'Doors and lock sets ', 'yes', 'no', '2025-01-03 14:54:38', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (20, 16, 'Inspire sink and tap', '321', '2025-01-02', '115.00', NULL, 'Sink and top ', 'yes', 'no', '2025-01-03 14:55:31', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (21, 16, 'Uniforms deposit inspire', '320', '2025-01-01', '400.00', NULL, 'Uniforms ', 'yes', 'no', '2025-01-03 14:57:49', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (22, 10, 'Planas Stationery', '319', '2025-01-02', '200.00', NULL, 'Stationery ', 'yes', 'no', '2025-01-03 14:59:20', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (23, 12, 'Adhesives  Primary block', '318', '2025-01-02', '180.00', NULL, 'New block ', 'yes', 'no', '2025-01-03 15:00:37', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (24, 20, 'Small HiaceRepairs', '317', '2025-01-01', '170.00', NULL, 'Repairs ', 'yes', 'no', '2025-01-04 11:47:37', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (25, 20, 'Civilian repairs', '324', '2025-01-01', '100.00', NULL, 'Civilian repairs', 'yes', 'no', '2025-01-03 15:18:15', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (26, 12, 'Adhesives Primary', '316', '2025-01-01', '106.00', NULL, 'Adhesives ', 'yes', 'no', '2025-01-03 15:21:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (27, 12, 'Primary Adhesives', '315', '2025-01-01', '6.00', NULL, 'Southmews adhesives ', 'yes', 'no', '2025-01-03 15:26:07', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (28, 16, 'Cement Inspire', '315', '2025-01-01', '24.00', NULL, 'Cement ', 'yes', 'no', '2025-01-03 15:27:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (29, 12, 'Primary Adhesives', '314', '2025-01-01', '129.00', NULL, 'adhesives', 'yes', 'no', '2025-01-03 15:31:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (30, 12, 'Grout and adhesives Primary', '313', '2025-01-01', '144.00', NULL, 'adhesive', 'yes', 'no', '2025-01-03 15:32:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (31, 12, 'Primary tiles', '312', '2025-01-01', '180.00', NULL, 'Tiles ', 'yes', 'no', '2025-01-03 15:33:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (32, 10, 'Invoice books payment', '311', '2025-01-01', '60.00', NULL, 'Invoice books ', 'yes', 'no', '2025-01-03 15:35:08', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (33, 12, 'Plaster primer  Primary block', '310', '2025-01-03', '149.00', NULL, 'Paint ', 'yes', 'no', '2025-01-03 15:36:00', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (34, 12, 'Ceiling white Primary', '309', '2025-01-02', '163.00', NULL, 'Ceiling paint ', 'yes', 'no', '2025-01-03 15:36:46', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (36, 4, 'Fuel isuzu', '306', '2025-01-01', '30.00', NULL, 'Fuel ', 'yes', 'no', '2025-01-03 15:40:44', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (37, 20, 'Jeep licence $85,police $20,carwash $10,sheen and ', '305', '2025-01-01', '137.00', NULL, 'Jeep', 'yes', 'no', '2025-01-03 15:45:38', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (38, 12, 'Tiles Primary', '304', '2025-01-03', '215.00', NULL, 'Tiles', 'yes', 'no', '2025-01-03 15:46:37', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (39, 12, 'Tiles', '303', '2025-01-01', '252.00', NULL, 'Tiles ', 'yes', 'no', '2025-01-03 15:47:39', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (40, 4, 'Fuel Isuzu', '302', '2025-01-01', '60.00', NULL, 'Fuel ', 'yes', 'no', '2025-01-03 15:48:39', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (41, 10, 'Invoice book payment', '301', '2025-01-01', '180.00', NULL, 'Invoice books ', 'yes', 'no', '2025-01-03 15:49:45', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (42, 24, '13.79 Liters Fuel', '340', '2025-01-03', '20.00', NULL, 'Fuel', 'yes', 'no', '2025-01-03 16:01:10', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (43, 10, 'Primary classroom boards', '339', '2025-01-03', '369.12', NULL, 'class boards', 'yes', 'no', '2025-01-03 16:09:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (44, 25, 'Angeline Mburuma', '097', '2025-01-01', '5.00', NULL, 'Airtime', 'yes', 'no', '2025-01-04 11:41:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (46, 25, 'Modester Chetse', '099', '2025-01-01', '5.00', NULL, 'Airtime allowance', 'yes', 'no', '2025-01-03 16:15:31', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (48, 5, 'Water bottles(4)', '402', '2025-01-01', '2.00', NULL, 'Water 4 bottles', 'yes', 'no', '2025-01-04 11:40:51', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (49, 25, 'Angeline Mburuma', '403', '2025-01-01', '18.00', NULL, 'Airtime and data', 'yes', 'no', '2025-01-03 16:20:21', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (50, 5, 'Lunch meals (3)', '404', '2025-01-01', '15.00', NULL, '3 Teachers', 'yes', 'no', '2025-01-04 11:40:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (51, 18, 'Files photocopying', '341', '2025-01-01', '11.00', NULL, 'Registration files', 'yes', 'no', '2025-01-04 11:54:54', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (52, 20, 'Civilian Repairs', '323', '2025-01-01', '174.00', NULL, 'Rings ,Gasket,engine cleaner,silicone', 'yes', 'no', '2025-01-04 11:52:41', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (53, 30, 'Graduation  gowns &third term sports wear', '147', '2025-01-01', '406.00', NULL, 'Third  term 2024 expense', 'yes', 'no', '2025-01-05 17:31:42', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (54, 30, 'Primary &College jerseys', '148', '2025-01-01', '148.00', NULL, '16  College\r\n6  Primary', 'yes', 'no', '2025-01-05 17:29:15', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (55, 30, 'Uniforms', '351', '2025-01-01', '300.00', NULL, 'Tracksuits & Blazers', 'yes', 'no', '2025-01-04 12:30:19', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (56, 30, 'Uniforms', '352', '2025-01-01', '300.00', NULL, 'Uniforms', 'yes', 'no', '2025-01-04 12:31:11', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (57, 30, 'Uniforms', '354', '2025-01-01', '150.00', NULL, 'Uniforms', 'yes', 'no', '2025-01-04 12:32:07', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (58, 30, 'Uniforms', '355', '2025-01-01', '240.00', NULL, 'Uniforms', 'yes', 'no', '2025-01-04 12:33:11', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (59, 12, 'Steel Doors', '353', '2025-01-01', '200.00', NULL, 'Primary Doors', 'yes', 'no', '2025-01-04 12:34:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (60, 12, 'Cement Reviews', '251', '2025-01-01', '10.00', NULL, 'Cement', 'yes', 'no', '2025-01-04 12:35:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (61, 12, 'Reviews labour', '252', '2025-01-01', '15.00', NULL, 'Reviews Labour', 'yes', 'no', '2025-01-04 12:36:34', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (62, 18, 'Water  5000 ltrs', '253', '2025-01-01', '50.00', NULL, 'Water delivery 5000 ltrs', 'yes', 'no', '2025-01-05 17:47:51', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (63, 12, 'Tiler Labour', '254', '2025-01-01', '300.00', NULL, 'Floor Tiling', 'yes', 'no', '2025-01-04 12:40:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (64, 20, 'AFN 2476 Nissan', '255', '2025-01-04', '50.00', NULL, 'Nissan Repairs', 'yes', 'no', '2025-01-04 12:42:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (65, 12, 'Tiles,nails,drills', '256', '2025-01-04', '78.09', NULL, 'Halsted builders', 'yes', 'no', '2025-01-04 12:43:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (67, 19, 'Flyers', '259', '2025-01-04', '80.00', NULL, 'Southmews flyers', 'yes', 'no', '2025-01-04 12:46:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (70, 26, 'Cement 10 bags', '262', '2025-01-01', '200.00', NULL, 'Cement', 'yes', 'no', '2025-01-04 16:10:47', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (71, 5, 'Staff lunch', '405', '2025-01-04', '24.50', NULL, 'Lunch ', 'yes', 'no', '2025-01-04 16:19:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (72, 16, 'Shower Inspire', '257', '2025-01-04', '100.00', NULL, 'Shower', 'yes', 'no', '2025-01-04 16:20:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (73, 12, 'Timber', '261', '2025-01-04', '25.00', NULL, 'Timber Primary block', 'yes', 'no', '2025-01-04 16:25:11', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (74, 26, 'Rydaleridge Labour( Builders)', '263', '2025-01-01', '670.00', NULL, 'Labour', 'yes', 'no', '2025-01-04 16:30:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (75, 16, 'Inspire Labour ( painter ,builder,electrician)', '264', '2025-01-01', '1040.00', NULL, 'Inspire labour ', 'yes', 'no', '2025-01-04 16:37:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (76, 26, 'Rydaleridge Plan Design', '265', '2025-01-03', '500.00', NULL, 'Plan Design ', 'yes', 'no', '2025-01-04 16:46:48', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (77, 12, 'Concrete nails', '406', '2025-01-04', '6.00', NULL, 'Nails (Primary block )', 'yes', 'no', '2025-01-04 17:31:34', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (78, 16, 'Cement Inspire', '342', '2025-01-05', '23.00', NULL, 'Cement ', 'yes', 'no', '2025-01-05 14:16:50', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (79, 16, 'Inspire paint', '346', '2025-01-01', '266.82', NULL, 'Inspire paint ', 'yes', 'no', '2025-01-05 14:18:19', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (80, 16, 'Inspire Grout and tile adhesives', '345', '2025-01-05', '15.20', NULL, 'Grout and adhesives ', 'yes', 'no', '2025-01-05 14:20:48', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (83, 16, 'Inspire painter labour', '347', '2025-01-05', '100.00', NULL, 'Painter labour', 'yes', 'no', '2025-01-05 14:28:31', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (84, 6, 'Fuel', '348', '2025-01-05', '60.00', NULL, 'Chairman fuel', 'yes', 'no', '2025-01-05 14:30:14', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (85, 6, 'Expense by Chairman', '', '2025-01-05', '958.00', NULL, 'Chairman expense', 'yes', 'no', '2025-01-05 14:32:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (86, 5, 'Lunch', '407', '2025-01-05', '1.00', NULL, 'Lunch', 'yes', 'no', '2025-01-05 14:34:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (87, 6, 'Tshirt', '408', '2025-01-05', '5.00', NULL, 'Tshirt', 'yes', 'no', '2025-01-05 14:34:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (88, 12, 'Painter labour', '', '2025-01-05', '100.00', NULL, 'Painter labour', 'yes', 'no', '2025-01-05 17:58:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (89, 20, 'Sprinter oil', '266', '2025-01-06', '40.00', NULL, 'Oil ', 'yes', 'no', '2025-01-06 15:28:52', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (90, 6, 'Chairman expense', '266', '2025-01-06', '150.00', NULL, 'expense by chair ', 'yes', 'no', '2025-01-06 15:30:05', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (91, 16, 'Gate balance', '350', '2025-01-06', '295.00', NULL, 'Gate payment', 'yes', 'no', '2025-01-06 18:15:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (92, 30, 'Sherpam tailor', '349', '2025-01-06', '400.00', NULL, 'Uniforms Payment', 'yes', 'no', '2025-01-06 18:16:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (93, 18, 'Furniture Group desks(6)', '', '2025-01-06', '300.00', NULL, 'desks (6)', 'yes', 'no', '2025-01-06 18:18:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (94, 18, 'Steel doors (2)', '356', '2025-01-06', '30.00', NULL, 'Steel doors', 'yes', 'no', '2025-01-06 18:20:12', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (95, 6, 'Chairman expense', '', '2025-01-07', '15.00', NULL, 'Gas ', 'yes', 'no', '2025-01-07 10:06:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (96, 12, 'Tiler labour', '357', '2025-01-07', '200.00', NULL, 'Tiler', 'yes', 'no', '2025-01-07 13:22:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (97, 20, 'Sprinter repairs', '', '2025-01-06', '50.00', NULL, 'Mr Sprinter', 'yes', 'no', '2025-01-07 21:02:46', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (98, 12, 'Paint,Coverstrips & hammer', '', '2025-01-07', '231.60', NULL, 'Paint and tools', 'yes', 'no', '2025-01-07 21:27:33', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (99, 24, 'B18 Fuel', '', '2025-01-06', '20.00', NULL, 'B18 Fuel', 'yes', 'no', '2025-01-07 21:06:43', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (100, 5, 'Lunch ( Operations manager)', '', '2025-01-06', '9.00', NULL, 'Operations manager', 'yes', 'no', '2025-01-07 21:17:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (101, 18, 'New Hiace payment', '201', '2025-01-07', '500.00', NULL, 'Hiace payment', 'yes', 'no', '2025-01-07 21:26:55', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (102, 4, 'Fuel Isuzu 13.42 litres', '203', '2025-01-07', '20.00', NULL, 'Fuel ISUZU', 'yes', 'no', '2025-01-07 21:24:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (103, 20, 'Civilian Painter', '202', '2025-01-07', '50.00', NULL, 'Civilian repairs', 'yes', 'no', '2025-01-07 21:25:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (104, 12, 'Turpentine', '268', '2025-01-08', '13.00', NULL, '5l Turpentine', 'yes', 'no', '2025-01-08 14:27:52', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (105, 12, 'Paint', '268', '2025-01-08', '211.00', NULL, '', 'yes', 'no', '2025-01-08 17:28:04', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (106, 4, 'Fuel Isuzu27.40 ltrs', '204', '2025-01-08', '40.00', NULL, 'Fuel', 'yes', 'no', '2025-01-08 18:18:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (107, 16, 'Nyandoro builder labour', '205', '2025-01-08', '70.00', NULL, 'Builder ', 'yes', 'no', '2025-01-08 18:19:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (108, 30, 'Primary Ties payment', '206', '2025-01-08', '20.00', NULL, 'Ties', 'yes', 'no', '2025-01-09 20:08:35', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (109, 6, 'Chairman lunch', '206', '2025-01-08', '10.00', NULL, 'Lunch', 'yes', 'no', '2025-01-08 18:20:22', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (110, 18, 'transport allowance', '409', '2025-01-08', '1.00', NULL, 'Mr Sithole Transport from Boka', 'yes', 'no', '2025-01-09 08:58:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (111, 18, 'Ditsrict and province', '208', '2025-01-09', '150.00', NULL, 'District and province lunch', 'yes', 'no', '2025-01-09 19:56:51', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (112, 20, 'Nissan tyres (2)', '209', '2025-01-09', '150.00', NULL, 'Nissan Tires', 'yes', 'no', '2025-01-09 20:02:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (113, 30, 'ECD satchels and sports short deposit', '210', '2025-01-09', '70.00', NULL, 'ECD Uniforms deposit', 'yes', 'no', '2025-01-09 20:05:53', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (114, 30, 'Primary and secondary ties', '211', '2025-01-09', '18.00', NULL, 'Primary and Secondary Tie', 'yes', 'no', '2025-01-09 20:12:00', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (115, 30, 'High school caps', '212', '2025-01-09', '15.00', NULL, 'High school student caps', 'yes', 'no', '2025-01-09 20:15:42', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (116, 25, 'Director airtime', '213', '2025-01-09', '5.00', NULL, 'Director\'s airtime', 'yes', 'no', '2025-01-09 20:17:51', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (117, 6, 'Chairman’s instruction', '', '2025-01-09', '498.00', NULL, 'Instruction', 'yes', 'no', '2025-01-10 21:59:35', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (120, 12, 'Paint', '215', '2025-01-10', '190.00', NULL, 'Paint', 'yes', 'no', '2025-01-10 21:45:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (121, 36, 'Cabin', '216', '2025-01-10', '200.00', NULL, 'Cabin ', 'yes', 'no', '2025-01-10 21:48:35', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (122, 20, 'Nissan labour and  shocks', '217', '2025-01-10', '70.00', NULL, 'Nissan repairs', 'yes', 'no', '2025-01-10 21:49:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (123, 24, 'Fuel lorry', '218', '2025-01-10', '20.00', NULL, 'Fuel', 'yes', 'no', '2025-01-10 21:50:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (124, 12, 'Interior painting', '271', '2025-01-11', '120.00', NULL, 'Interior painting labour', 'yes', 'no', '2025-01-11 14:43:47', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (125, 18, 'Workshop, lunch and transport', '270', '2025-01-11', '30.00', NULL, 'workshop, lunch and transport', 'yes', 'no', '2025-01-11 14:49:19', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (126, 10, 'Planas Stationery', '219', '2025-01-12', '89.00', NULL, 'Stationery', 'yes', 'no', '2025-01-12 07:29:13', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (127, 4, 'Isuzu fuel', '221', '2025-01-12', '20.00', NULL, 'Fuel', 'yes', 'no', '2025-01-12 07:31:47', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (128, 6, 'Chairman\'s Instruction', '222', '2025-01-12', '411.00', NULL, 'Instruction ', 'yes', 'no', '2025-01-12 07:32:57', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (129, 36, 'Rydaleridge ECD', '223', '2025-01-12', '960.00', NULL, 'Quarrystones $340\r\nTransport $80\r\npitsand $150\r\nriversand $340 \r\nlabour setting out $50', 'yes', 'no', '2025-01-12 07:43:52', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (130, 12, 'Southmews Paint', '224', '2025-01-12', '125.50', NULL, 'Paint(outside paint79,roof guard 29)', 'yes', 'no', '2025-01-12 07:36:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (131, 36, 'Rydaleridge labour builder', '225', '2025-01-12', '300.00', NULL, 'Labour', 'yes', 'no', '2025-01-12 20:20:13', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (132, 36, 'Cement 25 bags plus transport', '221', '2025-01-12', '307.00', NULL, 'Cement +transport', 'yes', 'no', '2025-01-12 20:24:54', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (133, 20, 'Nissan painting', '', '2025-01-03', '180.00', NULL, 'Nissan repairs', 'yes', 'no', '2025-01-12 20:22:35', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (134, 6, 'Chairman Instruction', '', '2025-01-12', '213.00', NULL, 'Instruction', 'yes', 'no', '2025-01-12 20:38:22', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (135, 30, 'Pana Garments', '358', '2025-01-10', '300.00', NULL, 'uniforms part payments', 'yes', 'no', '2025-01-14 13:21:56', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (136, 30, 'Kitup investments', '359', '2025-01-13', '50.00', NULL, 'ECD bags and shorts balance payment', 'yes', 'no', '2025-01-14 13:16:46', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (137, 18, 'Mtizira C', '269', '2025-01-10', '30.00', NULL, 'Workshop and lunch', 'yes', 'no', '2025-01-13 17:27:15', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (138, 6, 'Chairman Instruction', '', '2025-01-13', '182.00', NULL, 'Instruction', 'yes', 'no', '2025-01-14 13:07:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (139, 4, 'Fuel Isuzu', '226', '2025-01-13', '40.00', NULL, 'Fuel', 'yes', 'no', '2025-01-14 13:08:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (140, 20, 'Nissan panel beating', '227', '2025-01-14', '330.00', NULL, 'Nissan repairs', 'yes', 'no', '2025-01-14 16:22:11', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (141, 11, 'Detergents', '361', '2025-01-14', '24.50', NULL, 'Toilet cleaner 5 litre\r\nCar Washer 5 litre\r\nDishwasher litre\r\nDip', 'yes', 'no', '2025-01-14 16:56:33', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (142, 18, 'Mrs Chivesa Application fee (3 children)', '410', '2025-01-14', '15.00', NULL, 'Referral fee', 'yes', 'no', '2025-01-14 17:00:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (143, 18, 'Glue ( toilets maintanance)', '272', '2025-01-14', '3.00', NULL, 'Glue (bond)', 'yes', 'no', '2025-01-14 17:03:04', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (144, 12, 'Painter labour', '273', '2025-01-14', '350.00', NULL, 'Labour', 'yes', 'no', '2025-01-14 17:03:44', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (145, 18, 'Petrol for lawn mower', '274', '2025-01-14', '10.00', NULL, '4 litres\r\n300ml 2 stroke', 'yes', 'no', '2025-01-14 17:06:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (146, 18, 'Water delivery 5000 litres', '360', '2025-01-14', '50.00', NULL, 'Water delivery', 'yes', 'no', '2025-01-14 17:09:44', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (147, 3, 'Fuel Quantum (34 litres)', '275', '2025-01-15', '50.00', NULL, 'Fuel', 'yes', 'no', '2025-01-15 22:28:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (148, 1, 'Fuel Nissan Mode(37.42 litres)', '275', '2025-01-15', '55.00', NULL, 'Fuel', 'yes', 'no', '2025-01-15 22:27:20', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (149, 35, 'Fuel Civilian (54 litres)', '275', '2025-01-15', '80.00', NULL, 'Fuel', 'yes', 'no', '2025-01-15 22:22:45', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (150, 34, 'Fuel Nissan Vale (33.34 litres)', '275', '2025-01-15', '50.00', NULL, 'Fuel', 'yes', 'no', '2025-01-15 22:20:05', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (151, 36, 'Bricks', '276', '2025-01-15', '1300.00', NULL, 'Bricks', 'yes', 'no', '2025-01-15 14:10:05', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (152, 16, 'Paint Inspire', '276', '2025-01-15', '200.00', NULL, 'Paint Inspire', 'yes', 'no', '2025-01-15 13:52:05', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (153, 18, 'Locks and trimming twine', '277', '2025-01-15', '43.00', NULL, 'Key locks and trimming twine', 'yes', 'no', '2025-01-15 13:58:34', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (154, 18, 'Book shelf', '362', '2025-01-15', '150.00', NULL, 'Book shelf', 'yes', 'no', '2025-01-15 14:14:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (155, 18, 'Primary desks (6)', '363', '2025-01-15', '300.00', NULL, '6 Desks ', 'yes', 'no', '2025-01-15 14:22:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (156, 16, 'Labour drawings', '', '2025-01-15', '160.00', NULL, 'Inspire drawings ', 'yes', 'no', '2025-01-15 22:05:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (157, 30, 'Pana Garments part payment', '', '2025-01-15', '300.00', NULL, 'Part payment ', 'yes', 'no', '2025-01-15 22:06:48', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (158, 30, 'ECD and Primary ties', '', '2025-01-15', '62.50', NULL, 'ECD ties x10\r\nPrimary tie x15', 'yes', 'no', '2025-01-15 22:09:46', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (159, 10, 'Stationery Prim and College', '', '2025-01-01', '200.00', NULL, 'Stationery ', 'yes', 'no', '2025-01-15 22:15:41', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (160, 6, 'Chairman’s instruction', '', '2025-01-15', '10.00', NULL, 'Lunch ', 'yes', 'no', '2025-01-15 22:30:44', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (161, 20, 'Auto mechanic labour', '279', '2025-01-15', '10.00', NULL, 'Labour', 'yes', 'no', '2025-01-16 14:14:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (162, 18, 'Brooms', '281', '2025-01-16', '44.00', NULL, 'Brooms and mops', 'yes', 'no', '2025-01-16 14:16:06', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (163, 6, 'Chairman\'s Instruction', '283', '2025-01-16', '296.00', NULL, 'Instruction', 'yes', 'no', '2025-01-16 14:27:31', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (164, 10, 'Workbooks for sale', '283', '2025-01-16', '120.00', NULL, 'Workbooks ECD A and B', 'yes', 'no', '2025-01-16 14:28:36', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (165, 10, 'High school requirements', '284', '2025-01-16', '74.00', NULL, '2 quires $8\r\nstamp $35\r\nteacher\'s guides $31', 'yes', 'no', '2025-01-16 14:31:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (166, 20, 'Pressure Quantum', '411', '2025-01-16', '1.00', NULL, 'Pressure', 'yes', 'no', '2025-01-16 14:40:31', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (167, 18, 'High school trefoil bell', '286', '2025-01-16', '20.00', NULL, '1 trefoil bell', 'yes', 'no', '2025-01-18 09:59:44', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (168, 20, 'ATF Sprinter', '287', '2025-01-17', '5.00', NULL, '1 ATF', 'yes', 'no', '2025-01-18 10:04:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (169, 20, 'ATF Nissan Caravan', '287', '2025-01-17', '5.00', NULL, '1 ATF', 'yes', 'no', '2025-01-18 10:05:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (170, 20, 'Tyre Fitting & Plug', '412', '2025-01-17', '5.00', NULL, 'tyre fitting & plug', 'yes', 'no', '2025-01-18 10:07:38', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (171, 12, 'painter', '288', '2025-01-18', '130.00', NULL, 'painting labour', 'yes', 'no', '2025-01-18 13:41:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (172, 4, 'Fuel Isuzu 13.06 litres', '229', '2025-01-16', '20.00', NULL, 'Fuel Isuzu', 'yes', 'no', '2025-01-18 19:40:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (173, 16, 'Inspire play area', '230', '2025-01-18', '600.00', NULL, 'Play area Inspire', 'yes', 'no', '2025-01-18 19:41:48', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (174, 6, 'Chairman\'s Instruction', '', '2025-01-18', '305.00', NULL, 'Instruction', 'yes', 'no', '2025-01-18 19:44:14', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (175, 16, 'Inspire  kids desks (6) ,Office desk (1)', '231', '2025-01-18', '300.00', NULL, 'Inspire Desks', 'yes', 'no', '2025-01-18 19:46:13', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (176, 36, 'Rydaleridge Cement (20 bags) + transport', '232', '2025-01-18', '255.00', NULL, 'Cement + transport', 'yes', 'no', '2025-01-18 19:50:10', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (177, 36, 'Builder labour footing', '233', '2025-01-18', '300.00', NULL, 'Footing stage', 'yes', 'no', '2025-01-18 19:51:37', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (178, 6, 'Chairman Instruction', '', '2025-01-21', '200.00', NULL, 'Instruction (Mutare)', 'yes', 'no', '2025-01-21 12:26:37', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (179, 16, 'Deposit cabinets Inspire *********', '', '2025-01-20', '300.00', NULL, 'Inspire deposit cabinets', 'yes', 'no', '2025-01-21 12:30:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (180, 18, 'District lunch', '', '2025-01-21', '10.00', NULL, 'Lunch ', 'yes', 'no', '2025-01-21 12:32:57', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (181, 37, 'November salaries', '', '2025-01-21', '1500.00', NULL, 'November salaries', 'yes', 'no', '2025-01-21 12:34:33', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (182, 16, 'Inspire cabinets', '', '2025-01-21', '250.00', NULL, 'Inspire cabinets', 'yes', 'no', '2025-01-21 12:35:38', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (183, 16, 'Inspire Play area balance', '', '2025-01-21', '300.00', NULL, 'Play area balance', 'yes', 'no', '2025-01-21 12:43:39', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (184, 34, 'Fuel (60.77 litres)', '234', '2025-01-21', '90.00', NULL, 'Fuel', 'yes', 'no', '2025-01-21 12:45:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (185, 3, 'Fuel (54.2 litres)', '234', '2025-01-21', '80.00', NULL, 'Fuel', 'yes', 'no', '2025-01-21 12:48:36', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (186, 2, 'Fuel (13.6 litres)', '234', '2025-01-21', '20.00', NULL, 'Fuel', 'yes', 'no', '2025-01-21 12:49:57', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (187, 1, 'Fuel (61.22 litres)', '234', '2025-01-21', '90.00', NULL, 'Fuel ', 'yes', 'no', '2025-01-21 12:50:58', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (188, 12, 'Southmews bookshelves deposit', '231', '2025-01-21', '300.00', NULL, '4 Book shelves deposit', 'yes', 'no', '2025-01-21 12:59:50', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (189, 4, 'Fuel Isuzu ( 32.7litres)', '296', '2025-01-22', '50.00', NULL, 'Fuel Isuzu ', 'yes', 'no', '2025-01-22 17:04:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (190, 18, 'Ushewekunze Chairman Nyarota', '', '2025-01-22', '20.00', NULL, 'lunch ', 'yes', 'no', '2025-01-22 17:08:42', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (191, 6, 'Chairman\'s Instrustion', '', '2025-01-23', '60.00', NULL, 'Instruction', 'yes', 'no', '2025-01-23 14:38:19', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (192, 16, 'Drawings labour', '', '2025-01-23', '200.00', NULL, 'Preschool drawings', 'yes', 'no', '2025-01-23 14:40:11', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (193, 6, 'Fuel Jeep (Hwange)', '', '2025-01-23', '130.00', NULL, 'Jeep Fuel', 'yes', 'no', '2025-01-23 14:41:56', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (194, 20, 'Carravan AGL Vale', '412', '2025-01-23', '5.00', NULL, 'Tyre plug', 'yes', 'no', '2025-01-23 15:57:06', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (195, 20, 'Carravan AGL Vale', '413', '2025-01-23', '3.00', NULL, 'Tyre plug', 'yes', 'no', '2025-01-23 15:57:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (196, 20, 'Carravan AGL Vale', '415', '2025-01-23', '1.00', NULL, 'Tyre pressure', 'yes', 'no', '2025-01-23 15:56:36', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (197, 18, 'Transport to town', '416', '2025-01-23', '2.00', NULL, 'Transport  allowance', 'yes', 'no', '2025-01-23 15:06:56', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (198, 20, 'Carravan AGL Vale', '418', '2025-01-23', '10.00', NULL, 'Tyre fitting', 'yes', 'no', '2025-01-23 15:55:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (199, 20, 'Sprinter', '417', '2025-01-23', '2.00', NULL, 'Tyre fixing', 'yes', 'no', '2025-01-23 15:17:21', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (200, 25, 'Airtime Allowance Head', '419', '2025-01-23', '10.00', NULL, 'Airtime', 'yes', 'no', '2025-01-23 15:47:00', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (201, 18, 'Water delivery (5000 litres)', '365', '2025-01-20', '50.00', NULL, 'Water delivery', 'yes', 'no', '2025-01-23 15:33:06', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (202, 10, 'May 2024 flyers balance', '366', '2025-01-23', '70.00', NULL, 'Flyers', 'yes', 'no', '2025-01-23 15:34:33', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (203, 30, 'Muvishi Boys shorts (18)', '367', '2025-01-23', '126.00', NULL, 'Boys shorts', 'yes', 'no', '2025-01-23 15:36:08', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (204, 20, 'Caravan modester', '289', '2025-01-20', '30.00', NULL, 'brakes', 'yes', 'no', '2025-01-23 15:37:43', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (205, 30, 'Pana Uniforms part payment', '368', '2025-01-23', '500.00', NULL, 'Uniform part payment', 'yes', 'no', '2025-01-23 15:37:45', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (206, 20, 'Caravan Modester', '369', '2025-01-23', '20.00', NULL, 'Mechanic labour', 'yes', 'no', '2025-01-23 15:38:39', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (207, 34, 'Fuel 6.57 litres', '290', '2025-01-20', '10.00', NULL, 'fuel', 'yes', 'no', '2025-01-23 15:42:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (208, 18, 'Head Mtizira C', '292', '2025-01-21', '10.00', NULL, 'transport fee', 'yes', 'no', '2025-01-23 15:53:47', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (209, 18, 'Head Mtizira C', '293', '2025-01-21', '20.00', NULL, 'Affiliation fee, transport &  lunch', 'yes', 'no', '2025-01-23 15:53:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (210, 12, 'Elson Mapenduka', '294', '2025-01-21', '260.00', NULL, '10 standard chairs & 10 junior chairs', 'yes', 'no', '2025-01-23 15:54:14', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (211, 10, 'George Mukumba', '295', '2025-01-21', '18.50', NULL, 'Catridge refill & transport', 'yes', 'no', '2025-01-23 15:54:38', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (212, 30, 'Steve tailor', '297', '2025-01-23', '61.00', NULL, 'uniforms logo', 'yes', 'no', '2025-01-23 15:50:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (213, 18, 'Photocopying', '', '2025-01-23', '7.00', NULL, 'Clearances\r\nCVs', 'yes', 'no', '2025-01-23 15:50:44', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (214, 25, 'Airtime allowance George Mukumba', '', '2025-01-23', '5.00', NULL, 'Airtime', 'yes', 'no', '2025-01-23 15:53:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (215, 20, 'Baby Quantum gear box oil ,cable tyre', '298', '2025-01-24', '21.00', NULL, 'Quantum repairs', 'yes', 'no', '2025-01-24 12:56:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (216, 20, 'Caravan AGL Vale Tyre patch', '420', '2025-01-24', '3.00', NULL, 'Tyre patch', 'yes', 'no', '2025-01-24 13:00:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (217, 18, 'Chigwende Sports Ground fee', '299', '2025-01-24', '20.00', NULL, 'Ground fee', 'yes', 'no', '2025-01-24 13:41:05', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (218, 6, 'Chairman\'s Instruction', '', '2025-01-26', '38.00', NULL, 'Instruction', 'yes', 'no', '2025-01-26 17:41:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (219, 36, 'Gravel', '', '2025-01-26', '450.00', NULL, 'Gravel', 'yes', 'no', '2025-01-26 17:43:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (220, 16, 'Inspire cabinet labour', '', '2025-01-26', '120.00', NULL, 'Cabinet labour', 'yes', 'no', '2025-01-26 17:44:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (221, 16, 'Tools Inspire', '', '2025-01-26', '60.00', NULL, 'Tools', 'yes', 'no', '2025-01-26 17:44:55', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (222, 36, 'Builder Box labour', '', '2025-01-26', '400.00', NULL, 'Builder labour', 'yes', 'no', '2025-01-26 17:45:53', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (223, 20, 'Sprinter 2 painting', '', '2025-01-26', '300.00', NULL, 'Sprinter 2 repairs', 'yes', 'no', '2025-01-26 17:46:39', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (224, 18, 'New small kombi part  payment', '', '2025-01-26', '300.00', NULL, 'Part payment', 'yes', 'no', '2025-01-26 17:47:53', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (225, 18, 'Water 5000 litres', '371', '2025-01-27', '50.00', NULL, 'Water delivery', 'yes', 'no', '2025-01-28 16:50:55', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (226, 1, 'Tyre Pressure', '421', '2025-01-24', '1.00', NULL, 'Tyre Pressure', 'yes', 'no', '2025-01-27 15:38:49', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (227, 3, 'Baby Quantum Tyre Pressure', '422', '2025-01-24', '1.00', NULL, 'Tyre Pressure', 'yes', 'no', '2025-01-27 13:33:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (228, 2, 'Sprinter door  Grease', '423', '2025-01-27', '5.00', NULL, 'Stanley Grease', 'yes', 'no', '2025-01-28 16:49:55', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (229, 2, 'Sprinter Fuel 47.6litres', '372', '2025-01-27', '70.00', NULL, 'Fuel', 'yes', 'no', '2025-01-28 16:46:22', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (230, 34, 'AGL Vale Fuel 54.4litres', '372', '2025-01-27', '80.00', NULL, 'Fuel', 'yes', 'no', '2025-01-28 16:47:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (231, 18, 'Swivel Chair', '', '2025-01-27', '45.00', NULL, 'Chair', 'yes', 'no', '2025-01-27 17:37:57', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (232, 16, 'Swivel Chair', '', '2025-01-27', '45.00', NULL, 'Chair', 'yes', 'no', '2025-01-27 17:38:27', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (233, 6, 'Chairman Instruction', '', '2025-01-27', '7.00', NULL, 'Instruction', 'yes', 'no', '2025-01-27 17:39:39', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (234, 20, 'Tyres Caravan AGL Vale', '', '2025-01-27', '140.00', NULL, 'TYRES X 2', 'yes', 'no', '2025-01-27 17:40:37', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (235, 20, 'AGL Vale Break Pads', '374', '2025-01-28', '35.00', NULL, 'Break Pads Fix and Supply', 'yes', 'no', '2025-01-28 12:31:39', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (236, 20, 'Baby Quantum Tyre Pressure', '424', '2025-01-28', '1.00', NULL, 'Baby Quantum Tyre Pressure', 'yes', 'no', '2025-01-28 12:38:07', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (237, 1, 'Caravan  Mode Fuel 54.4 litres', '373', '2025-01-28', '80.00', NULL, 'Fuel', 'yes', 'no', '2025-01-28 16:48:41', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (238, 3, 'Quantum Fuel 54.4 litres', '373', '2025-01-28', '80.00', NULL, 'Fuel', 'yes', 'no', '2025-01-28 16:46:58', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (239, 4, 'Fuel ISUZU (26.67 liters )', '238', '2025-01-28', '40.00', NULL, 'Fuel', 'yes', 'no', '2025-01-28 16:45:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (240, 16, 'Inspire charts, plastics, invoice books and mats', '239', '2025-01-28', '111.00', NULL, 'Inspire charts, plastics, invoice books and mats ', 'yes', 'no', '2025-01-28 14:17:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (241, 18, 'Primary chairs part payment', '376', '2025-01-28', '150.00', NULL, 'Chairs', 'yes', 'no', '2025-01-28 16:44:51', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (242, 18, 'Fuel 5 litres', '373', '2025-01-28', '8.00', NULL, 'Fuel lawn mower', 'yes', 'no', '2025-01-28 14:46:20', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (243, 18, 'Ruvimbo Bangamuseve(Staff)', '425', '2025-01-28', '5.00', NULL, 'For referring a student', 'yes', 'no', '2025-01-28 16:44:11', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (244, 25, 'Director’s airtime', '', '2025-01-28', '10.00', NULL, 'Airtime ', 'yes', 'no', '2025-01-28 16:43:23', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (245, 11, 'Lijat Investiments (Detergents)', '375', '2025-01-28', '12.65', NULL, 'Toilet Cleaner 5litres, Pine Fresh 5litres', 'yes', 'no', '2025-01-31 12:08:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (246, 18, 'Cleaning Equipments', '378', '2025-01-29', '21.00', NULL, '4 Mops, 3 Brooms', 'yes', 'no', '2025-01-29 13:12:05', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (247, 20, 'AGL Vale Bearing', '379', '2025-01-29', '36.00', NULL, 'Bearing repair, Stud nuts, Paces fit', 'yes', 'no', '2025-01-29 13:17:13', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (248, 20, 'AGL Vale Mechanic Labor', '380', '2025-01-29', '20.00', NULL, 'Mechanic labor', 'yes', 'no', '2025-01-31 12:07:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (249, 36, 'Rydaleridge roof', '', '2025-01-29', '500.00', NULL, 'roof timber', 'yes', 'no', '2025-01-29 14:48:42', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (250, 16, 'Inspire desks part payment', '', '2025-01-29', '200.00', NULL, 'Inspire desks', 'yes', 'no', '2025-01-29 14:49:38', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (251, 20, 'Civilian and sprinter  auto  labour', '', '2025-01-29', '50.00', NULL, 'Auto labour', 'yes', 'no', '2025-01-29 14:51:25', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (252, 16, 'Printing pictures for chats', '', '2025-01-29', '5.00', NULL, 'Printing', 'yes', 'no', '2025-01-29 14:52:21', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (253, 6, 'Rainham Instruction', '', '2025-01-29', '100.00', NULL, 'Instruction', 'yes', 'no', '2025-01-29 15:08:27', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (254, 6, 'Chairman\'s Instruction', '', '2025-01-29', '59.00', NULL, 'Instruction', 'yes', 'no', '2025-01-29 15:10:27', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (255, 18, 'Mukumba George (Sports meeting & transport)', '427', '2025-01-30', '5.00', NULL, 'Sports meeting & transport', 'yes', 'no', '2025-01-31 10:18:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (256, 10, 'A5 Acknowledgement Receipt Book', '301', '2025-01-31', '20.00', NULL, 'receipt books', 'yes', 'no', '2025-01-31 11:52:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (257, 6, 'Chairman\'s Instruction', '', '2025-01-31', '15.00', NULL, 'Instruction', 'yes', 'no', '2025-01-31 12:03:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (258, 11, 'Toilet brushes', '428', '2025-01-31', '5.00', NULL, 'Toilet brushes', 'yes', 'no', '2025-01-31 12:18:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (259, 4, 'Fuel', '240', '2025-01-31', '40.00', NULL, 'Fuel', 'yes', 'no', '2025-01-31 12:19:31', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (260, 18, 'Bookshelves', '241', '2025-01-31', '220.00', NULL, 'Bookshelves', 'yes', 'no', '2025-02-05 19:20:10', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (261, 12, 'Coverstrips and nails', '242', '2025-01-31', '105.00', NULL, 'Coverstrips and nails', 'yes', 'no', '2025-01-31 12:30:41', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (262, 16, '5 Royal Blue Jerseys', '381', '2025-01-31', '35.00', NULL, 'Pre-school jerseys', 'yes', 'no', '2025-01-31 15:14:14', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (263, 30, '10 Primary jerseys T & E Knit Wear', '381', '2025-01-31', '80.00', NULL, '10 Primary jerseys', 'yes', 'no', '2025-01-31 15:15:54', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (264, 19, 'Inspire Marketing', '243', '2025-02-01', '99.00', NULL, '$45 lunch\r\n$54 tshirts and caps', 'yes', 'no', '2025-02-03 09:17:44', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (265, 30, 'High school tshirts', '243', '2025-02-01', '15.00', NULL, 'College tshirts x5', 'yes', 'no', '2025-02-03 09:18:00', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (266, 16, 'Blocks and crayons Inspire', '244', '2025-02-01', '16.00', NULL, 'Toys', 'yes', 'no', '2025-02-03 09:24:46', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (267, 4, 'Fuel Isuzu (13,52 litres)', '245', '2025-02-01', '20.00', NULL, 'Isuzu Fuel', 'yes', 'no', '2025-02-03 09:24:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (268, 30, 'Primary satchels', '246', '2025-01-31', '240.00', NULL, 'satchels \r\nsports shorts', 'yes', 'no', '2025-02-03 09:24:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (269, 16, 'Desks balance', '247', '2025-02-03', '100.00', NULL, 'Desks balance', 'yes', 'no', '2025-02-03 09:26:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (270, 24, 'Fuel B18 (27.78 litres)', '248', '2025-02-03', '40.00', NULL, 'Fuel B18', 'yes', 'no', '2025-02-03 09:28:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (271, 18, 'Teachers Airtime', '302', '2025-01-31', '40.00', NULL, 'Teachers Airtime', 'yes', 'no', '2025-02-03 12:10:25', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (272, 34, 'Nissan Caravan AGL Fuel', '', '2025-02-02', '68.00', NULL, 'Nissan Caravan AGL Fuel', 'yes', 'no', '2025-02-03 12:20:10', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (273, 2, 'Fuel Sprinter AFQ  47.6LITRES', '304', '2025-02-03', '70.00', NULL, 'Sprinter Fuel', 'yes', 'no', '2025-02-03 12:46:20', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (274, 35, 'Civilian Jerry  Can Fuel 20.4litres', '304', '2025-02-03', '30.00', NULL, 'Jerry Can Fuel', 'yes', 'no', '2025-02-04 20:25:34', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (275, 16, 'Inspire 75\'\' TV', '305', '2025-02-03', '350.00', NULL, 'TV Purchase', 'yes', 'no', '2025-02-04 19:20:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (276, 20, 'Civillian Mechanic Labor', '306', '2025-02-03', '150.00', NULL, 'Mechanic Labor Civillian', 'yes', 'no', '2025-02-03 13:27:55', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (277, 11, 'Kala Chemicals Detergents', '382', '2025-02-03', '23.65', NULL, '10litres Dishwasher, 5litres toilet cleaner, 5liter Pine Fresh', 'yes', 'no', '2025-02-03 13:30:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (278, 16, 'Baby QuantumAFZ 1403 Fuel 20Litres', '', '2025-02-04', '30.00', NULL, 'Fuel Quantum AFZ', 'yes', 'no', '2025-02-04 11:34:33', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (279, 18, 'Water Supply 5000litres', '383', '2025-02-04', '50.00', NULL, 'Water supply', 'yes', 'no', '2025-02-04 19:13:05', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (280, 20, 'Nissan Caravan 0491 Tyre fixing', '431', '2025-02-04', '6.00', NULL, 'Nissan Caravan 0491 tyre fixing', 'yes', 'no', '2025-02-04 11:40:54', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (281, 20, 'Sprinter Benz Battery filling & terminator', '432', '2025-02-04', '12.00', NULL, 'Battery filling & Terminator', 'yes', 'no', '2025-02-05 19:39:10', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (282, 18, 'Transport fee (Simba Mechanic)', '433', '2025-02-04', '2.00', NULL, 'Transport fee to Gazaland', 'yes', 'no', '2025-02-04 11:43:36', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (283, 20, 'Sprinter Benz radiator', '307', '2025-02-04', '35.00', NULL, 'Sprinter Benz radiator', 'yes', 'no', '2025-02-04 15:10:06', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (284, 18, 'College Agriculture project Chicks (25)', '308', '2025-02-04', '26.00', NULL, ' Agriculture Day old chicks', 'yes', 'no', '2025-02-04 19:17:47', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (285, 20, 'Nissan Caravan  Mode  Oil 5litres', '309', '2025-02-04', '24.00', NULL, '5litres Delo Gold oil for Nissan caravan (Mode)', 'yes', 'no', '2025-02-04 19:18:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (286, 10, 'High school & grade 6 textbooks', '249', '2025-02-04', '1199.00', NULL, 'Form 1,Form 3 & Grade 6 textbooks', 'yes', 'no', '2025-02-04 19:10:41', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (287, 1, 'Fuel Carravan Mode(40.80)litres', '310', '2025-02-04', '60.00', NULL, 'Fuel carravan', 'yes', 'no', '2025-02-05 19:42:53', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (288, 35, 'Fuel Civilian (20,4 litres)', '310', '2025-02-04', '30.00', NULL, 'Civilian', 'yes', 'no', '2025-02-05 19:42:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (289, 5, 'Director\'s lunch', '', '2025-02-03', '13.00', NULL, 'Lunch', 'yes', 'no', '2025-02-05 19:21:51', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (290, 10, 'Emerald key  Accounts', '250', '2025-02-05', '20.00', NULL, 'Emerald key Accounts form 3', 'yes', 'no', '2025-02-05 19:25:50', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (291, 4, 'Fuel jeep', '250', '2025-02-05', '60.00', NULL, 'Fuel jeep', 'yes', 'no', '2025-02-05 19:27:58', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (292, 20, 'Council payment Baby quantum', '250', '2025-02-05', '34.00', NULL, 'Council payment', 'yes', 'no', '2025-02-05 19:28:57', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (293, 18, 'Jeep Parking and Airtime', '250', '2025-02-05', '5.00', NULL, 'Jeep parking', 'yes', 'no', '2025-02-05 19:30:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (294, 16, 'Inspire bags (8)', '250', '2025-02-05', '64.00', NULL, 'Inspire bags ', 'yes', 'no', '2025-02-05 19:31:54', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (295, 30, 'Sherpam  tailors High school uniforms', '', '2025-02-05', '580.00', NULL, 'High school bags(27)\r\nSports shorts (30)\r\n', 'yes', 'no', '2025-02-05 19:35:20', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (296, 20, 'Gear oil Civilian', '311', '2025-02-05', '19.00', NULL, 'Civilian Gear oil', 'yes', 'no', '2025-02-05 19:40:38', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (297, 10, 'Catridge refilling & drum replacement', '312', '2025-02-05', '26.00', NULL, 'Catridge', 'yes', 'no', '2025-02-05 19:44:14', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (298, 18, 'Mr Mukumba Transport to fill catridge', '434', '2025-02-05', '2.00', NULL, 'Transport allowance', 'yes', 'no', '2025-02-05 19:45:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (299, 34, 'Fuel AGL Caravan Vale', '', '2025-02-05', '30.00', NULL, 'Fuel top up', 'yes', 'no', '2025-02-05 19:49:14', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (300, 36, 'Compaction', '', '2025-02-01', '200.00', NULL, 'Rydaleridge ECD compaction', 'yes', 'no', '2025-02-05 19:57:12', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (301, 36, 'Riversand', '', '2025-02-05', '295.00', NULL, 'Rydaleridge ECD Riversand', 'yes', 'no', '2025-02-05 19:58:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (302, 20, 'Civilian battries', '', '2025-02-01', '220.00', NULL, 'Civilian Battries', 'yes', 'no', '2025-02-05 19:59:22', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (303, 24, 'B18 Fuel (27.78litres)', '', '2025-02-05', '40.00', NULL, 'Fuel B18', 'yes', 'no', '2025-02-06 09:24:27', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (304, 20, 'Baby Quantum (Honda Fit)', '', '2025-02-06', '60.00', NULL, 'Panel Beating (Balance $40)', 'yes', 'no', '2025-02-06 11:27:07', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (305, 20, 'Lorry repairs balance (Elson)', '', '2025-02-06', '130.00', NULL, 'Lorry repairs balance', 'yes', 'no', '2025-02-06 11:30:41', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (306, 30, 'Pana Garments tailor. Primary and High School unif', '384', '2025-02-06', '300.00', NULL, 'Pana Garments Uniforms', 'yes', 'no', '2025-02-06 15:06:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (307, 16, 'Balance durawall drawings', '', '2025-02-06', '120.00', NULL, 'Durawall drawings labour', 'yes', 'no', '2025-02-06 18:54:38', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (308, 38, 'Interhouse college medals X22', '313', '2025-02-07', '50.60', NULL, 'Medals', 'yes', 'no', '2025-02-07 10:04:39', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (309, 38, 'First Aid Kit College', '313', '2025-02-07', '64.00', NULL, 'First Aid Kit', 'yes', 'no', '2025-02-07 10:08:06', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (310, 11, '10 tapped buckets 20 litres ,4 Bins 100 litres,Bin', '313', '2025-02-07', '61.50', NULL, 'Bins and buckets with taps', 'yes', 'no', '2025-02-07 10:17:32', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (311, 38, 'Staff sports t-shirts', '313', '2025-02-07', '25.00', NULL, 'Staff sports t-shirts', 'yes', 'no', '2025-02-07 10:24:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (312, 38, 'Mukumba Transport allowance to buy sports iitems', '313', '2025-02-07', '3.00', NULL, 'Transport allowance ', 'yes', 'no', '2025-02-07 10:25:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (313, 35, 'Fuel Civillian 20.69litres', '', '2025-02-07', '30.00', NULL, 'Fuel Civillian 20.69litres', 'yes', 'no', '2025-02-07 11:32:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (314, 18, 'Trimmer Liner (trimming grass)', '314', '2025-02-07', '5.00', NULL, 'Trimmer Liner (trimming grass)', 'yes', 'no', '2025-02-07 11:45:36', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (315, 20, 'Civillian ( brushes, springs , souldering wire)', '314', '2025-02-07', '25.00', NULL, 'Civillian ( brushes, springs, souldering wire)', 'yes', 'no', '2025-02-07 11:47:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (316, 20, 'Civillian GTX Oil 5litres', '314', '2025-02-07', '20.00', NULL, 'Civillian GTX Oil 5litres', 'yes', 'no', '2025-02-07 11:48:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (317, 20, 'Civillian (Auto Labor)', '315', '2025-02-07', '50.00', NULL, 'Civillian Auto Labor', 'yes', 'no', '2025-02-07 11:49:41', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (318, 18, 'Simba Mechanic Transport Allowance', '436', '2025-02-07', '2.00', NULL, 'Transport Allowance', 'yes', 'no', '2025-02-07 11:52:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (319, 12, 'Tiler labour', '316', '2025-02-09', '34.00', NULL, 'Tiling Labour ', 'yes', 'no', '2025-02-09 12:46:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (320, 38, 'Generator for sports(5.4 litres)', '317', '2025-02-09', '10.00', NULL, 'Fuel top up ', 'yes', 'no', '2025-02-10 13:00:51', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (321, 4, 'Fuel Jeep (19.61 litres)', '319', '2025-02-09', '30.00', NULL, 'Fuel Jeep ', 'yes', 'no', '2025-02-09 12:49:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (322, 18, 'Fuel coupons (180 litres )', '320', '2025-02-09', '270.00', NULL, 'Fuel Coupons ', 'yes', 'no', '2025-02-09 12:51:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (323, 39, 'Norton  Farms', '323', '2025-02-10', '210.00', NULL, 'Norton Farm', 'yes', 'no', '2025-02-10 12:36:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (324, 34, 'Fuel Carravan Vale', '', '2025-02-10', '60.00', NULL, 'Fuel  AGL Vale', 'yes', 'no', '2025-02-10 12:38:48', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (325, 20, 'Small Kombi painting', '', '2025-02-10', '50.00', NULL, 'Kombi Painting', 'yes', 'no', '2025-02-10 12:39:31', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (326, 34, 'Fuel AGC Vale', '322', '2025-02-10', '20.00', NULL, 'Fuel AGC Vale', 'yes', 'no', '2025-02-10 13:02:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (327, 30, 'KitUp Tailor (Primary Sports wear)', '385', '2025-02-07', '51.00', NULL, 'Sports Wear (Primary)', 'yes', 'no', '2025-02-10 13:14:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (328, 30, 'Pana Garments Tailor Labor', '387', '2025-02-07', '200.00', NULL, 'Labor for Uniforms', 'yes', 'no', '2025-02-10 13:15:36', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (329, 16, 'KitUp Tailor (White Shorts)', '388', '2025-02-10', '28.00', NULL, 'Inspire White Shorts', 'yes', 'no', '2025-02-10 13:17:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (330, 18, '5000 litres Water', '389', '2025-02-10', '50.00', NULL, '5000 litres Water Supply', 'yes', 'no', '2025-02-10 13:19:52', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (331, 20, 'Nissan Caravan Mode (Tyre Pressure)', '437', '2025-02-10', '1.00', NULL, 'Tyre Pressure Nissan Caravan Mode', 'yes', 'no', '2025-02-10 13:33:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (332, 20, 'Nissan Caravan Vale (Tyre Pressure)', '438', '2025-02-07', '1.00', NULL, 'Tyre Pressure Nissan Caravan Vale', 'yes', 'no', '2025-02-10 13:58:48', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (333, 20, 'Nissan Caravan Vale (Tyre Pressure)', '439', '2025-02-10', '2.00', NULL, 'Tyre Pressure Nissan Caravan Vale', 'yes', 'no', '2025-02-10 14:05:22', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (334, 38, 'Primary Affiliation Fee', '', '2025-02-10', '120.00', NULL, 'Sports Affiliation fee', 'yes', 'no', '2025-02-10 14:44:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (335, 12, 'Strongroom brackets,spanners,drill,pump', '318', '2025-02-11', '210.00', NULL, 'Strong room brackets', 'yes', 'no', '2025-02-11 11:29:58', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (336, 12, 'Melamine shelves strong room', '327', '2025-02-11', '78.00', NULL, 'Strong room shelves', 'yes', 'no', '2025-02-11 11:31:14', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (337, 1, 'AGL Vale fuel(53.20 litres)', '326', '2025-02-11', '80.00', NULL, 'Fuel AGL Vale', 'yes', 'no', '2025-02-11 11:42:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (338, 2, 'Fuel Sprinter(47.60litres)', '326', '2025-02-11', '70.00', NULL, 'Fuel Sprinter', 'yes', 'no', '2025-02-11 11:41:47', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (339, 1, 'Fuel Caravan Mode (40.81 litres)', '326', '2025-02-11', '60.00', NULL, 'Fuel Mode', 'yes', 'no', '2025-02-11 11:40:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (340, 4, 'Fuel Isuzu AGF(25 litres)', '326', '2025-02-11', '40.00', NULL, 'Fuel Isuzu', 'yes', 'no', '2025-02-11 11:43:49', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (341, 12, 'Strongroom window tinting', '325', '2025-02-11', '45.00', NULL, 'Window tinting', 'yes', 'no', '2025-02-11 11:46:00', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (342, 26, 'Roof labour payment', '328', '2025-02-11', '300.00', NULL, 'Roof Labour', 'yes', 'no', '2025-02-11 11:48:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (343, 10, 'Primary Answersheets & High school plastic covers', '322', '2025-02-11', '47.00', NULL, 'Answesheets\r\nPlastic covers', 'yes', 'no', '2025-02-11 11:53:19', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (344, 10, 'A3 Frames and Photos printing', '441', '2025-02-11', '6.00', NULL, 'Frames\r\nphoto printing', 'yes', 'no', '2025-02-11 12:03:45', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (345, 20, 'Nissan Caravan Vale Tyre Repair', '440', '2025-02-10', '2.00', NULL, 'Nissan Caravan Vale Tyre Repair', 'yes', 'no', '2025-02-11 13:31:34', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (346, 38, 'College Affiliation Fee', '329', '2025-02-11', '150.00', NULL, 'Sports Affiliation Fee', 'yes', 'no', '2025-02-11 13:35:11', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (347, 20, 'Sprinter Benz Tyre Fixing', '442', '2025-02-11', '5.00', NULL, 'Sprinter Benz Tyre Fixing', 'yes', 'no', '2025-02-11 15:00:32', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (348, 30, 'Primary Dresses (13) Muvishi', '390', '2025-02-11', '195.00', NULL, '13 Tunic Dresses Primary', 'yes', 'no', '2025-02-16 17:45:07', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (349, 18, 'Plumber High School Pipes Repair', '392', '2025-02-11', '20.00', NULL, 'Repairing of Pipes High School', 'yes', 'no', '2025-02-11 15:36:43', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (350, 18, 'Key Lock (Kitchen)', '443', '2025-02-11', '3.00', NULL, 'Key Lock for kitchen door', 'yes', 'no', '2025-02-11 16:40:48', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (351, 18, 'Transport Allowance (Tembo from Boka)', '443', '2025-02-11', '0.50', NULL, 'Transport from Boka (Tembo)', 'yes', 'no', '2025-02-11 16:42:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (352, 20, 'Nissan Caravan Mode (Wipers)', '444', '2025-02-12', '5.00', NULL, 'Wipers Nissan Caravan Mode', 'yes', 'no', '2025-02-12 09:44:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (353, 18, 'Mr Mukumba transport to fill Catridge', '445', '2025-02-12', '2.00', NULL, 'Transport allowance to fill catridge', 'yes', 'no', '2025-02-12 13:29:57', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (354, 10, 'Ink (Black) for EPSON Printer', '330', '2025-02-12', '15.00', NULL, 'Ink for EPSON Printer', 'yes', 'no', '2025-02-12 13:32:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (355, 18, 'Fuel 5.38litres (Grass Cutting)', '330', '2025-02-12', '8.00', NULL, 'Fuel for grass cutting', 'yes', 'no', '2025-02-12 16:56:54', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (356, 20, 'Nissan Caravn Vale Tyre Fixing (Flat tyre)', '446', '2025-02-12', '6.00', NULL, 'Tyre fixing for Nissan Caravan Vale', 'yes', 'no', '2025-02-12 16:58:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (357, 38, 'Mr Mukumba transport allowance to sports meeting', '447', '2025-02-12', '2.00', NULL, 'Transport allowance for College Sports Meeting', 'yes', 'no', '2025-02-12 17:00:07', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (358, 18, 'Pills (College)', '448', '2025-02-13', '1.00', NULL, 'Pills (College)', 'yes', 'no', '2025-02-13 10:59:59', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (359, 4, 'Fuel Isuzu(26.66 litres )', '', '2025-02-16', '40.00', NULL, 'Fuel Isuzu', 'yes', 'no', '2025-02-16 17:40:47', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (360, 6, 'Chairman Instruction', '', '2025-02-16', '30.00', NULL, 'Instruction', 'yes', 'no', '2025-02-16 17:42:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (361, 5, 'Lunch (director)', '', '2025-02-16', '22.00', NULL, 'Lunch', 'yes', 'no', '2025-02-16 17:43:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (362, 36, 'Bricks', '', '2025-02-15', '650.00', NULL, 'Bricks Rydaleridge', 'yes', 'no', '2025-02-16 17:44:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (363, 25, 'Headmaster Mr Mtizira (Airtime Allowance)', '449', '2025-02-17', '10.00', NULL, 'Airtime Allowance ', 'yes', 'no', '2025-02-17 13:19:00', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (364, 18, 'Steel 3 Metres (Strong Room)', '450', '2025-02-17', '7.00', NULL, 'Steel for Strong Room (3 Metres)', 'yes', 'no', '2025-02-17 14:32:56', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (365, 20, 'Prime Bond (AFN Nissan Mode)', '451', '2025-02-17', '5.00', NULL, 'Prime Bond (AFN Nissan Mode)', 'yes', 'no', '2025-02-17 14:44:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (366, 18, 'Mr Mukumba Transport Allowance', '452', '2025-02-17', '2.00', NULL, 'Transport Allowance', 'yes', 'no', '2025-02-17 14:45:26', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (367, 16, 'Uniforms (GREMLOC Tailors)', '394', '2025-02-14', '274.00', NULL, 'Inspire Uniforms', 'yes', 'no', '2025-02-17 14:48:54', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (368, 11, 'Kala Chemicals (5l Toilet cleaner, 5l Pine Fresh)', '395', '2025-02-17', '13.00', NULL, '5l Toilet Cleaner, 5l Pine Fresh (Kala Chemicals)', 'yes', 'no', '2025-02-17 14:54:34', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (369, 18, '5000 litres Water Supply', '96', '2025-02-17', '50.00', NULL, '5000 litres Water Supply', 'yes', 'no', '2025-02-17 14:57:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (370, 34, '6.33 litres Fuel (Nissan Caravan AGL Vale)', '331', '2025-02-14', '10.00', NULL, '6.33 litres Fuel (Nissan Caravan AGL Vale)', 'yes', 'no', '2025-02-17 17:28:34', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (371, 34, '10.34 litres Fuel (Nissan Caravan AGL Vale)', '331', '2025-02-14', '15.00', NULL, '10.34 litres Fuel (Nissan Caravan AGL Vale)', 'yes', 'no', '2025-02-17 15:08:55', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (372, 10, 'Catridge Refill', '332', '2025-02-17', '15.00', NULL, 'Catridge Refill', 'yes', 'no', '2025-02-17 15:10:12', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (373, 20, 'White Sprinter Tyre Pressure', '453', '2025-02-17', '2.00', NULL, 'Tyre Pressure (White Sprinter)', 'yes', 'no', '2025-02-17 16:09:31', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (374, 20, 'Tyre Pressure (Nissan Caravan AGL Vale)', '454', '2025-02-17', '1.00', NULL, 'Tyre Pressure (Nissan Caravan AGL Vale)', 'yes', 'no', '2025-02-17 16:10:47', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (375, 26, 'Lands office lunch', '', '2025-02-17', '30.00', NULL, 'Lunch', 'yes', 'no', '2025-02-17 16:53:49', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (376, 18, 'ECD Slab labour', '', '2025-02-17', '200.00', NULL, 'Slab Labour', 'yes', 'no', '2025-02-17 17:00:13', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (377, 1, '40.8 litres Fuel (Nissan Caravan AFN Mode)', '334', '2025-02-17', '60.00', NULL, '40.8 litres Fuel Nissan Caravan AFN Mode', 'yes', 'no', '2025-02-17 17:06:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (378, 18, 'Drivers Airtime Allowance', '455', '2025-02-17', '20.00', NULL, 'Drivers Airtime Allowance', 'yes', 'no', '2025-02-17 17:29:46', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (379, 18, 'Drill Bits & Bolts', '333', '2025-02-17', '31.00', NULL, 'Drill Bits & Bolts', 'yes', 'no', '2025-02-17 17:31:36', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (380, 20, 'Engine Oil (White Sprinter)', '333', '2025-02-17', '19.00', NULL, 'Engine Oil (White Sprinter)', 'yes', 'no', '2025-02-17 17:41:50', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (381, 2, '34litres Fuel (Sprinter Benz)', '334', '2025-02-18', '50.00', NULL, '34 litres Fuel Sprinter Benz', 'yes', 'no', '2025-02-18 09:04:13', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (382, 40, '27.7 litres Fuel White Sprinter', '334', '2025-02-18', '40.00', NULL, '27.7 litres Fuel White Sprinter', 'yes', 'no', '2025-02-18 09:05:37', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (383, 24, 'Fuel (ABY B1800)', '', '2025-02-18', '30.00', NULL, 'Fuel (ABY B1800)', 'yes', 'no', '2025-02-18 09:08:04', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (384, 34, '48.6 litres Fuel AGL 4091', '334', '2025-02-18', '70.00', NULL, '48.6 LITRES Fuel AGL 4091', 'yes', 'no', '2025-02-18 09:09:33', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (385, 20, 'Nissan Caravan AGL (Fixing tyre puncture and rim', '456', '2025-02-19', '7.00', NULL, 'Tyre Puncture and rim fixing ( Nissan Caravan AGL Vale)', 'yes', 'no', '2025-02-19 09:50:38', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (386, 20, 'Tyre Repair (White Sprinter)', '460', '2025-02-18', '3.00', NULL, 'Tyre Repair (White Sprinter)', 'yes', 'no', '2025-02-19 09:52:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (387, 4, 'Fuel (27.2litres)', '336', '2025-02-18', '40.00', NULL, 'Fuel Isuzu', 'yes', 'no', '2025-02-19 09:53:32', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (388, 20, 'Carravan Vale AGL Wheel', '338', '2025-02-19', '70.00', NULL, 'Wheel', 'yes', 'no', '2025-02-19 09:54:56', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (389, 20, 'Battery Filling (Nissan Caravan Mode)', '457', '2025-02-18', '15.00', NULL, 'Battery Filling (Nissan Caravan Mode)', 'yes', 'no', '2025-02-19 09:55:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (390, 20, 'Tyre fixing (Sprinter Benz)', '458', '2025-02-19', '2.00', NULL, 'Tyre fixing (Sprinrter Benz)', 'yes', 'no', '2025-02-19 09:57:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (391, 10, 'Report Books', '337', '2025-02-19', '110.00', NULL, 'Report Books (ECD, Primary & High School)', 'yes', 'no', '2025-02-19 15:12:02', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (392, 18, 'A3 Frames (2)', '337', '2025-02-19', '6.00', NULL, 'A3 Frames (2)', 'yes', 'no', '2025-02-19 15:13:55', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (393, 10, 'Primary & College Potraits', '337', '2025-02-19', '5.00', NULL, 'Primary & College Potraits', 'yes', 'no', '2025-02-19 15:19:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (394, 20, 'Control Arm (Nissan Caravan Mode)', '338', '2025-02-19', '35.00', NULL, 'Control Arm (Nissan Caravan Mode)', 'yes', 'no', '2025-02-19 15:25:19', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (395, 20, 'Bolts, Nuts & Bolt removal (Nissan Caravan Mode)', '461', '2025-02-19', '8.00', NULL, 'Bolts, nuts & bolts repair (Nissan Caravan Mode)', 'yes', 'no', '2025-02-19 15:28:15', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (396, 20, 'Tyre repair (Nissan Caravan Mode)', '462', '2025-02-19', '3.00', NULL, 'Tyre repair ( Nissan Caravan Mode)', 'yes', 'no', '2025-02-19 15:29:37', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (397, 18, 'Transport Allowance (Admire)', '463', '2025-02-19', '2.00', NULL, 'Transport allowance (Admire)', 'yes', 'no', '2025-02-19 15:30:44', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (398, 18, 'Komby hire for school run', '339', '2025-02-19', '20.00', NULL, 'Komby hire for school run', 'yes', 'no', '2025-02-20 09:11:43', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (399, 20, 'Brake Fluid (Nissan Caravan Mode)', '464', '2025-02-20', '5.00', NULL, 'Brake fluid (Nissan Caravan Mode)', 'yes', 'no', '2025-02-20 10:51:56', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (400, 20, 'Gearbox (White Sprinter ABN)', '', '2025-02-12', '250.00', NULL, 'Gearbox (White Sprinter ABN)', 'yes', 'no', '2025-02-20 14:00:58', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (401, 20, 'Mechanic Labor (White Sprinter ABN)', '', '2025-02-12', '30.00', NULL, 'Mechanic labor (White Sprinter ABN)', 'yes', 'no', '2025-02-20 14:03:41', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (402, 20, 'Grills (White Sprinter ABN)', '', '2025-02-12', '50.00', NULL, 'Grill (White Sprinter ABN)', 'yes', 'no', '2025-02-20 14:05:05', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (403, 38, '34 litres Fuel (White Sprinter ABN)', '', '2025-02-12', '50.00', NULL, '34 litres Fuel (White Sprinter)', 'yes', 'no', '2025-02-20 14:07:33', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (404, 20, 'Chassis (White Sprinter)', '', '2025-02-12', '25.00', NULL, 'Chassis (White Sprinter)', 'yes', 'no', '2025-02-20 14:10:19', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (405, 20, 'Back Seat and Mounting (White Sprinter ABN)', '', '2025-02-12', '45.00', NULL, 'Back Seat and  Mounting (White SprInter ABN)', 'yes', 'no', '2025-02-20 14:15:20', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (406, 20, 'Bolts and Horseclamps (White Sprinter ABN)', '', '2025-02-12', '3.00', NULL, 'Bolts and Horseclamps (White Sprinter ABN)', 'yes', 'no', '2025-02-20 14:17:51', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (407, 20, 'Starter and timing bolt (White Sprinter ABN)', '', '2025-02-12', '120.00', NULL, 'Starter and timing bolt (White Sprinter ABN)', 'yes', 'no', '2025-02-20 14:20:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (408, 20, 'View mirror, door handles and door cables (White S', '', '2025-02-12', '100.00', NULL, 'View mirror, door handles and door cables (White Sprinter ABN)', 'yes', 'no', '2025-02-20 15:53:46', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (409, 20, 'Mechanic (Nissan Caravan Mode)', '465', '2025-02-20', '12.00', NULL, 'Mechanic (Nissan Caravan Mode)', 'yes', 'no', '2025-02-20 15:55:54', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (410, 20, 'Tyre Pressure (Nissan Caravan Mode)', '467', '2025-02-20', '1.00', NULL, 'Tyre Pressure (Nissan Caravan Mode)', 'yes', 'no', '2025-02-20 15:57:01', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (411, 20, 'Brake fluid, ATF, Break pads (Nissan Caravan Mode)', '340', '2025-02-20', '14.00', NULL, 'Brake fluid, ATF, Break pads (Nissan Caravan Mode)', 'yes', 'no', '2025-02-20 15:59:07', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (412, 20, 'Lower ball joint (Nissan Caravan Mode)', '', '2025-02-14', '10.00', NULL, 'Lower ball joint (Nissan Caravan Mode)', 'yes', 'no', '2025-02-20 16:03:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (413, 20, 'Mechanic (Nissan Caravan Mode)', '', '2025-02-14', '20.00', NULL, 'Mechanic (Nissan Caravan Mode)', 'yes', 'no', '2025-02-20 17:08:47', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (414, 20, 'Gas man (Nissan Caravan Mode)', '', '2025-02-14', '4.00', NULL, 'Gas man (Nissan Caravan Mode)', 'yes', 'no', '2025-02-20 17:11:13', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (415, 20, 'Gear oil 2 litres  (Baby quantum)', '', '2025-02-14', '20.00', NULL, 'Gear oil 2 litres (Baby quantum)', 'yes', 'no', '2025-02-20 17:13:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (416, 20, 'Studs (Nissan Caravan AGL Vale)', '', '2025-02-13', '15.00', NULL, 'Studs (Nissan Caravan AGL Vale)', 'yes', 'no', '2025-02-20 17:16:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (417, 20, 'Studs ( Nissan Caravan AGL Vale)', '', '2025-02-14', '15.00', NULL, 'Studs (Nissan Caravan AGL Vale)', 'yes', 'no', '2025-02-20 17:17:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (418, 20, 'Pirod bearing (Sprinter Benz)', '', '2025-02-14', '15.00', NULL, 'Pirod bearing (Sprinter Benz)', 'yes', 'no', '2025-02-20 17:18:51', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (419, 20, 'Kits (Sprinter Benz)', '', '2025-02-14', '6.00', NULL, 'Kits (Sprinter Benz)', 'yes', 'no', '2025-02-20 17:20:39', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (420, 20, 'Clutch plate (Sprinter Benz)', '', '2025-02-14', '15.00', NULL, 'Clutch plate (Sprinter Benz)', 'yes', 'no', '2025-02-20 17:23:33', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (421, 20, 'Clutch cylinder (Sprinter Benz)', '', '2025-02-14', '50.00', NULL, 'Clutch cylinder (Sprinter Benz)', 'yes', 'no', '2025-02-20 17:28:41', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (422, 20, 'Mechanic (Sprinter Benz)', '', '2025-02-14', '20.00', NULL, 'Mechanic (Sprinter Benz)', 'yes', 'no', '2025-02-20 17:30:40', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (423, 20, 'Simba mechanic (Sprinter Benz)', '', '2025-02-14', '100.00', NULL, 'Simba mechanic (Sprinter Benz)', 'yes', 'no', '2025-02-20 19:31:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (424, 20, 'Brake fluid (Sprinter Benz)', '', '2025-02-14', '5.00', NULL, 'Brake fluid(Sprinter Benz)', 'yes', 'no', '2025-02-20 19:32:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (425, 20, 'Panel Beater (New komby)', '', '2025-02-13', '440.00', NULL, 'Panel beater (New komby)', 'yes', 'no', '2025-02-20 19:34:15', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (426, 20, 'Battery (New Komby)', '', '2025-02-13', '105.00', NULL, 'Battery (New Komby)', 'yes', 'no', '2025-02-20 19:35:08', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (427, 20, 'Engine cleaner and bolts (New Komby)', '', '2025-02-13', '8.00', NULL, 'Engine cleaner and bolts (New Komby)', 'yes', 'no', '2025-02-20 19:36:08', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (428, 20, 'Diesel Filter', '', '2025-02-13', '8.00', NULL, 'Diesel filter (New Komby)', 'yes', 'no', '2025-02-20 19:36:57', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (429, 20, 'Bracket (New Komby)', '', '2025-02-13', '10.00', NULL, 'Bracket (New Komby)', 'yes', 'no', '2025-02-20 19:37:48', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (430, 20, 'Fan Belt (New Komby)', '', '2025-02-13', '5.00', NULL, 'Fan belt (New Komby)', 'yes', 'no', '2025-02-20 19:38:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (431, 20, 'Timing belt (New Komby)', '', '2025-02-13', '20.00', NULL, 'Timing belt (New Komby)', 'yes', 'no', '2025-02-20 19:39:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (432, 20, 'Clutch (New Komby)', '', '2025-02-13', '20.00', NULL, 'Clutch (New Komby)', 'yes', 'no', '2025-02-20 19:40:14', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (433, 20, 'Pump services (Civillian', '', '2025-02-13', '150.00', NULL, 'Pump services (Civillian)', 'yes', 'no', '2025-02-20 19:42:10', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (434, 20, 'Injectors (Civillian)', '', '2025-02-13', '120.00', NULL, 'Injectores (Civillian)', 'yes', 'no', '2025-02-20 19:51:21', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (435, 20, 'Braes (Civillian)', '', '2025-02-13', '60.00', NULL, 'Brakes (Civillian)', 'yes', 'no', '2025-02-20 20:05:29', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (436, 20, 'Shoes and brake drums (Civillian', '', '2025-02-13', '50.00', NULL, 'Shoes and brake drums (Civillian)', 'yes', 'no', '2025-02-20 20:07:15', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (437, 20, 'Diesel filter and bracket (Civillian)', '', '2025-02-13', '20.00', NULL, 'Diesel filtera and bracket (Civillian)', 'yes', 'no', '2025-02-20 20:08:42', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (438, 20, 'Starter (Civillian)', '', '2025-02-13', '130.00', NULL, 'Starter (Civillian)', 'yes', 'no', '2025-02-20 20:09:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (439, 35, '74.8 litres Fuel (Civillian)', '', '2025-02-13', '110.00', NULL, 'Fuel 74.8 litres (Civillian', 'yes', 'no', '2025-02-20 20:11:14', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (440, 20, 'Cutting plate and fitting (Civillian)', '', '2025-02-13', '70.00', NULL, 'Cutting plate and fitting (Civillian)', 'yes', 'no', '2025-02-20 20:12:32', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (441, 20, 'Fan belt (Civillian)', '', '2025-02-13', '5.00', NULL, 'Fan belt (Civillian)', 'yes', 'no', '2025-02-20 20:13:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (442, 20, 'View mirror (Civillian)', '', '2025-02-13', '20.00', NULL, 'View mirror (Civillian)', 'yes', 'no', '2025-02-20 20:14:17', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (443, 20, 'Tank welding (Civillian)', '', '2025-02-13', '5.00', NULL, 'Tank welding (Civillian)', 'yes', 'no', '2025-02-20 20:15:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (444, 20, 'Oil (Civillian)', '', '2025-02-13', '19.00', NULL, 'Oil (Civillian)', 'yes', 'no', '2025-02-20 20:15:45', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (445, 20, 'Horse clamp, diesel pipe and engine cleaner (Civil', '', '2025-02-13', '11.00', NULL, 'Horse clamp, diesel pipe and engine cleaner (Civillian)', 'yes', 'no', '2025-02-20 20:17:11', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (446, 19, 'Marketing allowance (Staff)', '', '2025-02-15', '50.00', NULL, 'Marketing allowance (Staff)', 'yes', 'no', '2025-02-20 20:18:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (447, 18, 'Center fee Ctrest breeders', '', '2025-02-24', '25.00', NULL, 'Center fee', 'yes', 'no', '2025-02-24 17:02:30', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (448, 5, 'Director\'s lunch', '', '2025-02-24', '5.00', NULL, 'Lunch', 'yes', 'no', '2025-02-24 17:05:46', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (450, 6, 'Chairman Instruction', '', '2025-02-24', '80.00', NULL, 'Instruction', 'yes', 'no', '2025-02-24 17:26:25', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (451, 18, 'Transport allowance (George Mukumba)', '466', '2025-02-20', '4.00', NULL, 'Transport allowance to boka and Cart fee for chicken feed', 'yes', 'no', '2025-02-25 08:35:28', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (452, 18, 'Starter feed 50kg & Stress pack 100g', '341', '2025-02-21', '37.00', NULL, 'Starter feed 50kg $34, Stress pack 100g $3', 'yes', 'no', '2025-02-25 08:39:42', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (453, 40, '10,42 litres Fuel (White sprinter)', '344', '2025-02-22', '15.00', NULL, '10.42 litres Fuel (White sprinter)', 'yes', 'no', '2025-02-25 09:01:06', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (454, 20, 'Rim repair (White sprinter ABN)', '470', '2025-02-22', '5.00', NULL, 'Rim repair (White sprinter ABN)', 'yes', 'no', '2025-02-25 09:04:11', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (455, 1, '40.2 litres fuel (Nissan Caravan Mode)', '345', '2025-02-25', '60.00', NULL, '40.2 litres fuel (Nissan caravan Mode)', 'yes', 'no', '2025-02-25 16:27:09', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (456, 34, '46,9 litres fuel (Nissan caravan AGL Vale)', '345', '2025-02-25', '70.00', NULL, '46.9 litre fuel (Nissan caravan AGL Vale)', 'yes', 'no', '2025-02-25 16:28:56', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (457, 2, '40.2 litres fuel (Sprinter benz)', '345', '2025-02-25', '60.00', NULL, '40.2 litres fuel (Sprinter Benz)', 'yes', 'no', '2025-02-25 16:30:53', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (458, 20, 'Bearing (White Sprinter)', '346', '2025-02-25', '25.00', NULL, 'Bearing (White Sprinter)', 'yes', 'no', '2025-02-25 16:34:03', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (459, 20, 'Press fitting (White Sprinter)', '346', '2025-02-25', '5.00', NULL, 'Press fitting (White Sprinter)', 'yes', 'no', '2025-02-25 16:37:20', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (460, 20, 'Brake fluid (White Sprinter)', '346', '2025-02-25', '5.00', NULL, 'Brake fluid (White Sprinter)', 'yes', 'no', '2025-02-25 16:40:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (461, 18, '5000 litres water supplied', '398', '2025-02-25', '50.00', NULL, '5000 litres water supplied', 'yes', 'no', '2025-02-26 07:57:16', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (462, 11, '5litres Dishwasher (Kala Chemicals)', '399', '2025-02-26', '6.00', NULL, '5 litres Dishwasher', 'yes', 'no', '2025-02-26 08:55:50', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (463, 4, 'Fuel ISUZU', '', '2025-02-24', '40.00', NULL, 'Fuel ISUZU', 'yes', 'no', '2025-02-26 10:34:24', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (464, 18, 'Gate locks', '', '2025-02-26', '12.00', NULL, 'Padlocks', 'yes', 'no', '2025-02-26 10:37:37', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (465, 20, 'Sprinter door', '', '2025-02-26', '25.00', NULL, 'Sprinter Door ', 'yes', 'no', '2025-02-26 13:58:19', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (466, 20, 'Shoe adjuster', '', '2025-02-26', '30.00', NULL, 'Adjuster', 'yes', 'no', '2025-02-26 14:01:18', NULL);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (467, 20, 'Brake  Kits x 4', '', '2025-02-26', '12.00', NULL, 'Brake kits', 'yes', 'no', '2025-02-26 14:02:07', NULL);


#
# TABLE STRUCTURE FOR: fee_groups
#

DROP TABLE IF EXISTS `fee_groups`;

CREATE TABLE `fee_groups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `is_system` int NOT NULL DEFAULT '0',
  `description` text,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;

INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (1, 'First Term High School Tuition Fees', 0, 'January , February and March Fees', 'no', '2024-12-09 14:46:22');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (2, 'First Term Transport Zone A', 0, '', 'no', '2024-12-09 14:37:29');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (3, 'First Term Transport Zone B', 0, '', 'no', '2024-12-09 14:37:43');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (4, 'First Term Transport Zone A Siblings', 0, '', 'no', '2024-12-09 14:37:56');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (5, 'First Term Transport Zone B Siblings', 0, '', 'no', '2024-12-09 14:46:10');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (7, 'Boys Form 1 Uniform Pack', 0, 'Boys Uniform Pack ', 'no', '2025-01-09 17:55:44');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `is_active`, `created_at`) VALUES (8, 'Girls Form 1 Uniform Pack', 0, 'Uniform Park for Girls', 'no', '2025-01-09 18:00:46');


#
# TABLE STRUCTURE FOR: fee_groups_feetype
#

DROP TABLE IF EXISTS `fee_groups_feetype`;

CREATE TABLE `fee_groups_feetype` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fee_session_group_id` int DEFAULT NULL,
  `fee_groups_id` int DEFAULT NULL,
  `feetype_id` int DEFAULT NULL,
  `session_id` int DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `fine_type` varchar(50) NOT NULL DEFAULT 'none',
  `due_date` date DEFAULT NULL,
  `fine_percentage` float(10,2) NOT NULL DEFAULT '0.00',
  `fine_amount` float(10,2) NOT NULL DEFAULT '0.00',
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fee_session_group_id` (`fee_session_group_id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_groups_feetype_ibfk_1` FOREIGN KEY (`fee_session_group_id`) REFERENCES `fee_session_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_2` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_3` FOREIGN KEY (`feetype_id`) REFERENCES `feetype` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3;

INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (1, 1, 1, 1, 21, '87.00', 'none', '2025-01-15', '0.00', '0.00', 'no', '2024-12-06 07:53:45');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (2, 2, 2, 2, 21, '30.00', 'none', '2025-01-15', '0.00', '0.00', 'no', '2024-12-06 07:54:50');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (3, 3, 3, 3, 21, '45.00', 'none', '2025-01-15', '0.00', '0.00', 'no', '2024-12-06 07:58:59');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (4, 4, 4, 4, 21, '23.00', 'none', '2025-01-15', '0.00', '0.00', 'no', '2024-12-06 07:59:35');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (5, 5, 5, 5, 21, '34.00', 'none', '2025-01-15', '0.00', '0.00', 'no', '2024-12-06 08:00:32');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (7, 1, 1, 6, 21, '87.00', 'none', '2025-02-01', '0.00', '0.00', 'no', '2024-12-09 14:39:09');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (8, 1, 1, 11, 21, '87.00', 'none', '2025-03-01', '0.00', '0.00', 'no', '2024-12-09 14:39:39');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (9, 2, 2, 7, 21, '30.00', 'none', '2025-02-01', '0.00', '0.00', 'no', '2024-12-09 14:40:44');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (10, 2, 2, 12, 21, '30.00', 'none', '2025-03-01', '0.00', '0.00', 'no', '2024-12-09 14:41:06');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (11, 3, 3, 8, 21, '45.00', 'none', '2025-01-01', '0.00', '0.00', 'no', '2024-12-09 14:41:31');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (12, 3, 3, 13, 21, '45.00', 'none', '2025-03-01', '0.00', '0.00', 'no', '2024-12-09 14:41:54');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (13, 4, 4, 9, 21, '23.00', 'none', '2025-02-01', '0.00', '0.00', 'no', '2024-12-09 14:42:45');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (14, 4, 4, 16, 21, '23.00', 'none', '2025-03-01', '0.00', '0.00', 'no', '2024-12-09 14:43:12');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (15, 5, 5, 10, 21, '34.00', 'none', '2025-02-01', '0.00', '0.00', 'no', '2024-12-09 14:47:12');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (16, 5, 5, 17, 21, '34.00', 'none', '2025-03-01', '0.00', '0.00', 'no', '2024-12-09 14:47:34');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (17, 7, 7, 18, 21, '140.00', 'none', '2025-01-01', '0.00', '0.00', 'no', '2025-01-09 18:00:00');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `is_active`, `created_at`) VALUES (18, 8, 8, 19, 21, '140.00', 'none', '2025-01-01', '0.00', '0.00', 'no', '2025-01-09 18:00:20');


#
# TABLE STRUCTURE FOR: fee_receipt_no
#

DROP TABLE IF EXISTS `fee_receipt_no`;

CREATE TABLE `fee_receipt_no` (
  `id` int NOT NULL AUTO_INCREMENT,
  `payment` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: fee_session_groups
#

DROP TABLE IF EXISTS `fee_session_groups`;

CREATE TABLE `fee_session_groups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fee_groups_id` int DEFAULT NULL,
  `session_id` int DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_session_groups_ibfk_1` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_session_groups_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;

INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (1, 1, 21, 'no', '2024-12-06 07:53:45');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (2, 2, 21, 'no', '2024-12-06 07:54:50');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (3, 3, 21, 'no', '2024-12-06 07:58:59');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (4, 4, 21, 'no', '2024-12-06 07:59:35');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (5, 5, 21, 'no', '2024-12-06 08:00:32');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (7, 7, 21, 'no', '2025-01-09 18:00:00');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`) VALUES (8, 8, 21, 'no', '2025-01-09 18:00:20');


#
# TABLE STRUCTURE FOR: feemasters
#

DROP TABLE IF EXISTS `feemasters`;

CREATE TABLE `feemasters` (
  `id` int NOT NULL AUTO_INCREMENT,
  `session_id` int DEFAULT NULL,
  `feetype_id` int NOT NULL,
  `class_id` int DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `description` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `feemasters_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_2` FOREIGN KEY (`feetype_id`) REFERENCES `feetype` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_3` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: fees_discounts
#

DROP TABLE IF EXISTS `fees_discounts`;

CREATE TABLE `fees_discounts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `session_id` int DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `percentage` float(10,2) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `description` text,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fees_discounts_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: fees_reminder
#

DROP TABLE IF EXISTS `fees_reminder`;

CREATE TABLE `fees_reminder` (
  `id` int NOT NULL AUTO_INCREMENT,
  `reminder_type` varchar(10) DEFAULT NULL,
  `day` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'before', 2, 0, '2020-02-28 15:38:32', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'before', 5, 0, '2020-02-28 15:38:36', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'after', 2, 0, '2020-02-28 15:38:40', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'after', 5, 0, '2020-02-28 15:38:44', NULL);


#
# TABLE STRUCTURE FOR: feetype
#

DROP TABLE IF EXISTS `feetype`;

CREATE TABLE `feetype` (
  `id` int NOT NULL AUTO_INCREMENT,
  `is_system` int NOT NULL DEFAULT '0',
  `feecategory_id` int DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `code` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb3;

INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (1, 0, NULL, 'January Tuition Fees', 'J01', 'no', '', '2024-12-06 07:43:16', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (2, 0, NULL, 'January Transport Zone A', 'J02', 'no', 'Ushewekunze $30', '2024-12-06 07:46:43', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (3, 0, NULL, 'January Transport Zone B', 'J03', 'no', 'Mufakose, Amalinda $45', '2024-12-06 07:46:05', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (4, 0, NULL, 'January Siblings Discount Zone A', 'J02-23', 'no', 'Siblings discount for Zone A 75% of $30 = $23', '2024-12-07 07:49:34', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (5, 0, NULL, 'January Siblings Discount Zone B', 'J03-34', 'no', 'Siblings Discount 75% of $45 = $34', '2024-12-07 07:49:51', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (6, 0, NULL, 'February Tuition Fees', 'F01', 'no', '', '2024-12-07 07:15:08', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (7, 0, NULL, 'February Transport Zone A', 'F02', 'no', '', '2024-12-07 07:16:46', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (8, 0, NULL, 'February Transport Zone B', 'F03', 'no', '', '2024-12-07 07:17:32', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (9, 0, NULL, 'February Siblings Discount Zone A ', 'F02-23', 'no', '', '2024-12-07 07:19:43', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (10, 0, NULL, 'February Siblings Discount Zone B', 'F03-34', 'no', '', '2024-12-07 07:22:06', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (11, 0, NULL, 'March Tuition Fees', 'M01', 'no', '', '2024-12-07 07:27:59', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (12, 0, NULL, 'March Transport Zone A', 'M02', 'no', '', '2024-12-07 07:28:30', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (13, 0, NULL, 'March Transport Zone B', 'M03', 'no', '', '2024-12-07 07:25:33', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (16, 0, NULL, 'March Sibling Discount Zone A', 'M02-23', 'no', '', '2024-12-07 07:50:46', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (17, 0, NULL, 'March Sibling Discount Zone B ', 'M03-34', 'no', '', '2024-12-07 08:15:55', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (18, 0, NULL, 'Boys College Uniform F1 Pack', 'CUS01', 'no', 'Boys College Form 1 Pack', '2025-01-09 17:56:29', NULL);
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `code`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (19, 0, NULL, 'Gilrs College Uniform F1 Pack', 'CUS02', 'no', 'Girls College Uniform F1 Pack', '2025-01-09 17:57:02', NULL);


#
# TABLE STRUCTURE FOR: filetypes
#

DROP TABLE IF EXISTS `filetypes`;

CREATE TABLE `filetypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_extension` text,
  `file_mime` text,
  `file_size` int NOT NULL,
  `image_extension` text,
  `image_mime` text,
  `image_size` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `filetypes` (`id`, `file_extension`, `file_mime`, `file_size`, `image_extension`, `image_mime`, `image_size`, `created_at`) VALUES (1, 'pdf, zip, jpg, jpeg, png, txt, 7z, gif, csv, docx, mp3, mp4, accdb, odt, ods, ppt, pptx, xlsx, wmv, jfif, apk, ppt, bmp, jpe, mdb, rar, xls, svg', 'application/pdf, image/zip, image/jpg, image/png, image/jpeg, text/plain, application/x-zip-compressed, application/zip, image/gif, text/csv, application/vnd.openxmlformats-officedocument.wordprocessingml.document, audio/mpeg, application/msaccess, application/vnd.oasis.opendocument.text, application/vnd.oasis.opendocument.spreadsheet, application/vnd.ms-powerpoint, application/vnd.openxmlformats-officedocument.presentationml.presentation, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, video/x-ms-wmv, video/mp4, image/jpeg, application/vnd.android.package-archive, application/x-msdownload, application/vnd.ms-powerpoint, image/bmp, image/jpeg, application/msaccess, application/vnd.ms-excel, image/svg+xml', 100048576, 'jfif, png, jpe, jpeg, jpg, bmp, gif, svg', 'image/jpeg, image/png, image/jpeg, image/jpeg, image/bmp, image/gif, image/x-ms-bmp, image/svg+xml', 10048576, '2021-01-30 15:03:03');


#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int NOT NULL AUTO_INCREMENT,
  `enquiry_id` int NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `enquiry_id` (`enquiry_id`),
  KEY `followup_by` (`followup_by`),
  CONSTRAINT `follow_up_ibfk_1` FOREIGN KEY (`enquiry_id`) REFERENCES `enquiry` (`id`) ON DELETE CASCADE,
  CONSTRAINT `follow_up_ibfk_2` FOREIGN KEY (`followup_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` text NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menu_id` int NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int NOT NULL,
  `parent_id` int NOT NULL,
  `ext_url` text,
  `open_new_tab` int DEFAULT '0',
  `ext_url_link` text,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int DEFAULT NULL,
  `publish` int NOT NULL DEFAULT '0',
  `description` text,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `menu_id` (`menu_id`),
  CONSTRAINT `front_cms_menu_items_ibfk_1` FOREIGN KEY (`menu_id`) REFERENCES `front_cms_menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (1, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', 1, 0, NULL, 'no', '2019-12-03 00:11:50');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 1, 'Contact Us', 76, 0, NULL, NULL, NULL, 'contact-us', 4, 0, NULL, 'no', '2019-12-03 00:11:52');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Complain', 2, 0, NULL, NULL, NULL, 'complain', 3, 0, NULL, 'no', '2019-12-03 00:11:52');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 1, 'Online Admission', 0, 0, '1', NULL, 'http://yourschoolurl.com/online_admission', 'admssion', 2, 0, NULL, 'no', '2019-12-21 17:33:00');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` text,
  `open_new_tab` int NOT NULL DEFAULT '0',
  `ext_url` text NOT NULL,
  `ext_url_link` text NOT NULL,
  `publish` int NOT NULL DEFAULT '0',
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 16:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 16:54:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `page_id` int DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int DEFAULT '0',
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` text,
  `meta_description` text,
  `meta_keyword` text,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext,
  `publish_date` date DEFAULT NULL,
  `publish` int DEFAULT '0',
  `sidebar` int DEFAULT '0',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>home page</p>', '0000-00-00', 1, NULL, 'no', '2019-12-02 17:23:47');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<p>[form-builder:complain]</p>', '0000-00-00', 1, NULL, 'no', '2019-11-13 12:16:36');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 16:46:04');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<section class=\"contact\">\r\n<div class=\"container\">\r\n<div class=\"row\">\r\n<h2 class=\"col-md-12 col-sm-12\">Send In Your Query</h2>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<div class=\"col-md-12 col-sm-12\">[form-builder:contact_us]<!--./row--></div>\r\n<!--./col-md-12--></div>\r\n<!--./row--></div>\r\n<!--./container--></section>\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\"><img src=\"http://192.168.1.81/repos/smartschool/uploads/gallery/media/pin.svg\" />\r\n<h3>Our Location</h3>\r\n\r\n<p>350 Fifth Avenue, 34th floor New York NY 10118-3299 USA</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\"><img src=\"http://192.168.1.81/repos/smartschool/uploads/gallery/media/phone.svg\" />\r\n<h3>CALL US</h3>\r\n\r\n<p>E-mail : info@abcschool.com</p>\r\n\r\n<p>Mobile : +91-9009987654</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\"><img src=\"http://192.168.1.81/repos/smartschool/uploads/gallery/media/clock.svg\" />\r\n<h3>Working Hours</h3>\r\n\r\n<p>Mon-Fri : 9 am to 5 pm</p>\r\n\r\n<p>Sat : 9 am to 3 pm</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-12 col-sm-12\">\r\n<div class=\"mapWrapper fullwidth\"><iframe frameborder=\"0\" height=\"500\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"no\" src=\"http://maps.google.com/maps?f=q&source=s_q&hl=EN&q=time+square&aq=&sll=40.716558,-73.931122&sspn=0.40438,1.056747&ie=UTF8&rq=1&ev=p&split=1&radius=33.22&hq=time+square&hnear=&ll=37.061753,-95.677185&spn=0.438347,0.769043&z=9&output=embed\" width=\"100%\"></iframe></div>\r\n</div>', '0000-00-00', 0, NULL, 'no', '2019-05-04 17:46:41');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `program_id` int DEFAULT NULL,
  `media_gallery_id` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` text,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` text,
  `description` text,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `meta_title` text NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `feature_image` text NOT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int DEFAULT '0',
  `is_active_front_cms` int DEFAULT '0',
  `is_active_sidebar` int DEFAULT '0',
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` text NOT NULL,
  `whatsapp_url` varchar(255) NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` text,
  `footer_text` varchar(500) DEFAULT NULL,
  `cookie_consent` varchar(255) NOT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `whatsapp_url`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `cookie_consent`, `fav_icon`, `created_at`) VALUES (1, 'material_pink', NULL, 1, 1, './uploads/school_content/logo/1725446861-168628203666d83acd67a9a!WhatsApp Image 2024-09-03 at 6.44.39 PM (2).jpeg', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', '', '', './uploads/school_content/logo/1725446861-1645044766d83acd67bb1!WhatsApp Image 2024-09-03 at 6.44.39 PM (1).jpeg', '2024-09-04 12:47:41');


#
# TABLE STRUCTURE FOR: gateway_ins
#

DROP TABLE IF EXISTS `gateway_ins`;

CREATE TABLE `gateway_ins` (
  `id` int NOT NULL AUTO_INCREMENT,
  `online_admission_id` int DEFAULT NULL,
  `gateway_name` varchar(50) NOT NULL,
  `module_type` varchar(255) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `parameter_details` mediumtext NOT NULL,
  `payment_status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `online_admission_id` (`online_admission_id`),
  CONSTRAINT `gateway_ins_ibfk_1` FOREIGN KEY (`online_admission_id`) REFERENCES `online_admissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: gateway_ins_response
#

DROP TABLE IF EXISTS `gateway_ins_response`;

CREATE TABLE `gateway_ins_response` (
  `id` int NOT NULL AUTO_INCREMENT,
  `gateway_ins_id` int DEFAULT NULL,
  `posted_data` text,
  `response` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `gateway_ins_id` (`gateway_ins_id`),
  CONSTRAINT `gateway_ins_response_ibfk_1` FOREIGN KEY (`gateway_ins_id`) REFERENCES `gateway_ins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: grades
#

DROP TABLE IF EXISTS `grades`;

CREATE TABLE `grades` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exam_type` varchar(250) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `point` float(10,1) DEFAULT NULL,
  `mark_from` float(10,2) DEFAULT NULL,
  `mark_upto` float(10,2) DEFAULT NULL,
  `description` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'school_grade_system', 'A', '5.0', '100.00', '74.00', 'Excellent', 'no', '2025-02-25 08:47:03', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'school_grade_system', 'B', '4.0', '74.00', '65.00', 'Very Good', 'no', '2025-02-25 08:47:10', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'school_grade_system', 'C', '3.0', '64.00', '50.00', 'Good', 'no', '2025-02-25 08:46:33', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'school_grade_system', 'D', '1.0', '49.00', '40.00', 'Satisfactory', 'no', '2025-02-25 08:48:42', NULL);
INSERT INTO `grades` (`id`, `exam_type`, `name`, `point`, `mark_from`, `mark_upto`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'school_grade_system', 'F', '0.0', '39.00', '0.00', 'Fail', 'no', '2025-02-25 08:48:24', NULL);


#
# TABLE STRUCTURE FOR: homework
#

DROP TABLE IF EXISTS `homework`;

CREATE TABLE `homework` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class_id` int NOT NULL,
  `section_id` int NOT NULL,
  `session_id` int NOT NULL,
  `staff_id` int NOT NULL,
  `subject_group_subject_id` int DEFAULT NULL,
  `subject_id` int DEFAULT NULL,
  `homework_date` date NOT NULL,
  `submit_date` date NOT NULL,
  `marks` float(10,2) DEFAULT NULL,
  `description` text,
  `create_date` date NOT NULL,
  `evaluation_date` date DEFAULT NULL,
  `document` varchar(200) DEFAULT NULL,
  `created_by` int NOT NULL,
  `evaluated_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  KEY `session_id` (`session_id`),
  KEY `staff_id` (`staff_id`),
  KEY `subject_id` (`subject_id`),
  KEY `evaluated_by` (`evaluated_by`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `homework_ibfk_1` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_3` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_5` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_6` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_7` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_8` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: homework_evaluation
#

DROP TABLE IF EXISTS `homework_evaluation`;

CREATE TABLE `homework_evaluation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `homework_id` int NOT NULL,
  `student_id` int NOT NULL,
  `student_session_id` int DEFAULT NULL,
  `marks` float(10,2) DEFAULT NULL,
  `note` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `homework_id` (`homework_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `homework_evaluation_ibfk_1` FOREIGN KEY (`homework_id`) REFERENCES `homework` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_evaluation_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_evaluation_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: hostel
#

DROP TABLE IF EXISTS `hostel`;

CREATE TABLE `hostel` (
  `id` int NOT NULL AUTO_INCREMENT,
  `hostel_name` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `address` text,
  `intake` int DEFAULT NULL,
  `description` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: hostel_rooms
#

DROP TABLE IF EXISTS `hostel_rooms`;

CREATE TABLE `hostel_rooms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `hostel_id` int DEFAULT NULL,
  `room_type_id` int DEFAULT NULL,
  `room_no` varchar(200) DEFAULT NULL,
  `no_of_bed` int DEFAULT NULL,
  `cost_per_bed` float(10,2) DEFAULT '0.00',
  `title` varchar(200) DEFAULT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hostel_id` (`hostel_id`),
  KEY `room_type_id` (`room_type_id`),
  CONSTRAINT `hostel_rooms_ibfk_1` FOREIGN KEY (`hostel_id`) REFERENCES `hostel` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hostel_rooms_ibfk_2` FOREIGN KEY (`room_type_id`) REFERENCES `room_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: id_card
#

DROP TABLE IF EXISTS `id_card`;

CREATE TABLE `id_card` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `school_name` varchar(100) NOT NULL,
  `school_address` varchar(500) NOT NULL,
  `background` varchar(100) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `sign_image` varchar(100) NOT NULL,
  `enable_vertical_card` int NOT NULL DEFAULT '0',
  `header_color` varchar(100) NOT NULL,
  `enable_admission_no` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_class` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_fathers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_mothers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_blood_group` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_barcode` tinyint NOT NULL DEFAULT '1' COMMENT '0=disable,1=enable',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `enable_vertical_card`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `enable_student_barcode`, `status`) VALUES (1, 'Sample Student Identity Card Horizontal', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', 0, '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1);
INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `enable_vertical_card`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `enable_student_barcode`, `status`) VALUES (2, 'Sample Student Identity Card Vertical', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', 1, '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1);


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int NOT NULL AUTO_INCREMENT,
  `income_head_id` int DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT '0.00',
  `note` text,
  `is_active` varchar(255) DEFAULT 'yes',
  `documents` varchar(255) DEFAULT NULL,
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `income_head_id` (`income_head_id`),
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`income_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb3;

INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 2, 'Rufaro Chawira', '001', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:03:36', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 3, 'Rufaro Chawira', '001', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:32:41', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (3, 2, 'Dashon Calvin Suruma', '002', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:33:11', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (4, 3, 'Dashonm Calvin Suruma', '002', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:33:46', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (5, 3, 'Kelly Dikito', '003', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:34:14', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (6, 3, 'Tinayeishe Dikito', '004', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:34:51', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (7, 2, 'Roy Kwandasvika', '005', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:31:47', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (8, 3, 'Roy Kwandasvika', '005', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:31:18', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (9, 2, 'Caroline Mparutsa', '006', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:30:50', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (10, 3, 'Caroline Mparutsa', '10', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:30:20', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (11, 2, 'Believe Bene', '007', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:29:25', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (12, 3, 'Believe Bene', '007', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:28:47', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (13, 2, 'Trinity Shoko', '008', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:28:04', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (14, 3, 'Trinity Shoko', '008', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:27:18', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (15, 2, 'Kimberly Chibade', '009', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:26:30', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (16, 3, 'Kimberly Chibade', '009', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:25:53', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (17, 2, 'Kelly Dikito', '010', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:23:51', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (18, 2, 'Tinayeishe Dikito', '011', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:24:35', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (19, 2, 'Shammah Gonese', '013', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:23:14', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (20, 3, 'Shammah Gonese', '013', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:22:03', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (21, 2, 'Blessing Mavhengere', '015', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:21:35', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (22, 3, 'Blessing Mavhengere', '015', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:21:04', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (23, 2, 'Anotidaishe Tarubuda', '018', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:20:29', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (24, 3, 'Anotidaishe Tarubuda', '018', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:19:49', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (25, 2, 'Ashilla Manake', '022', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:19:15', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (26, 3, 'Ashilla Manake', '022', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:18:47', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (27, 2, 'Ashwell Nemukuyu', '025', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:17:24', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (28, 3, 'Ashwell Nemukuyu', '025', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:16:38', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (29, 2, 'Joseph Nyandoro', '026', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:15:55', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (30, 2, 'Aaliyah Mutengu', '028', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:15:19', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (31, 3, 'Aaliyah Mutengu', '028', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:14:10', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (32, 3, 'Isheatida V Chongo', '029', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:13:42', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (33, 2, 'Priviledge Mutangadura', '030', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:13:10', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (34, 3, 'Priviledge Mutangadura', '030', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:12:44', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (35, 2, 'Tamia Munetsi', '032', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:12:16', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (36, 3, 'Tamia Munetsi', '032', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:11:28', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (37, 2, 'Isheatida V  Chongo', '035', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:10:54', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (38, 2, 'Tinevimbo Chinodyaruswa', '039', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:10:25', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (39, 3, 'Tinevimbo Chinodyaruswa', '039', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:09:50', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (40, 2, 'Kutenda Magwagwa', '042', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:09:19', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (41, 3, 'Kutenda Magwagwa', '042', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:08:51', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (42, 2, 'Tatenda Savanhu', '045', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:08:23', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (43, 3, 'Tatenda Savanhu', '045', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:07:50', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (44, 2, 'Tawananyasha Meki', '047', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:07:16', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (45, 3, 'Tawananyasha Meki', '047', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:06:47', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (46, 2, 'Nyasha Kasinamuchengeti', '048', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:06:21', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (47, 3, 'Nyasha Kasinamuchengeti', '048', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:05:55', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (48, 2, 'Nyasha Gunda', '050', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:05:24', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (49, 3, 'Nyasha Gunda', '050', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:04:59', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (50, 2, 'Brighton Rihambe', '053', '2025-01-01', '40.00', '', 'yes', NULL, 'no', '2025-01-08 22:04:29', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (51, 3, 'Brighton Rihambe', '053', '2025-01-01', '10.00', '', 'yes', NULL, 'no', '2025-01-08 22:04:03', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (52, 2, 'Fadzai Kwangwari', '059', '2025-01-08', '40.00', '', 'yes', NULL, 'no', '2025-01-08 14:33:09', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (53, 3, 'Fadzai Kwangwari', '059', '2025-01-08', '10.00', '', 'yes', NULL, 'no', '2025-01-08 14:33:41', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (54, 2, 'Amarah Alseti', '060', '2025-01-08', '40.00', '', 'yes', NULL, 'no', '2025-01-08 14:34:13', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (55, 3, 'Amarah Alseti', '060', '2025-01-08', '10.00', '', 'yes', NULL, 'no', '2025-01-08 14:34:44', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (56, 1, 'Praise Mahere', '5303', '2025-01-01', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 18:58:31', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (57, 1, 'Ashilla Manake', '5304', '2025-01-01', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 19:00:16', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (58, 1, 'Priviledge Mutangadura', '5305', '2025-01-01', '140.00', 'starter pack', 'yes', NULL, 'no', '2025-01-09 19:03:58', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (59, 1, 'Tamia Munetsi', '5306', '2025-01-01', '140.00', 'starter pack', 'yes', NULL, 'no', '2025-01-09 19:07:13', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (60, 1, 'Kelly Dikito', '5307', '2025-01-01', '160.00', 'tie, full jersey, s/sleeve shirt, skirt, sports short, t shirt, blazer, tracksuit, satchel', 'yes', NULL, 'no', '2025-01-09 19:10:55', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (61, 1, 'Tinevimbo Chinodyaruswa', '5308', '2025-01-01', '34.00', 'tie, short, s/sleeve shirt, sunhat', 'yes', NULL, 'no', '2025-01-09 19:12:42', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (62, 1, 'Aaliyah Mutengu', '5309', '2025-01-01', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 19:14:03', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (63, 1, 'Believe Bene', '5310', '2025-01-01', '124.00', 'tie,shirt, blazer, sunhat, tracksuit, satchel, skirt', 'yes', NULL, 'no', '2025-01-09 19:15:42', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (64, 1, 'Isheatida V Chongo', '5311', '2025-01-01', '100.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 19:17:50', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (65, 1, 'Tatenda Savanhu', '5312', '2025-01-01', '109.00', 'tie, shirt, sunhat, tracksuit, t shirt, sports short, satchel, short', 'yes', NULL, 'no', '2025-01-09 19:24:53', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (66, 1, 'Joseph Nyandoro', '5313', '2025-01-01', '40.00', 'Satchel, tie, short', 'yes', NULL, 'no', '2025-01-09 19:26:34', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (67, 1, 'Tawananyasha Meki', '5314', '2025-01-01', '54.00', 'tie, short, shirt, satchel', 'yes', NULL, 'no', '2025-01-09 19:44:11', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (68, 1, 'Kutenda Magwagwa', '5315', '2025-01-01', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 19:49:43', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (69, 1, 'Nyasha Kasinamuchengeti', '5316', '2025-01-01', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 19:51:30', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (70, 1, 'Kimberly Chibade', '5317', '2025-01-01', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 19:53:32', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (71, 1, 'Nyasha Gunda', '5318', '2025-01-01', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 19:54:30', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (72, 1, 'Trinity Shoko', '5319', '2025-01-01', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 19:55:40', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (73, 1, 'Brighton Rihambe', '5320', '2025-01-01', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 19:56:36', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (74, 1, 'Isheatida V Chongo', '5321', '2025-01-02', '40.00', 'Starter pack (balance)', 'yes', NULL, 'no', '2025-01-09 20:01:59', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (75, 1, 'Takudzwa Mpansi', '5322', '2025-01-02', '30.00', 'Tie, shirt, trousers', 'yes', NULL, 'no', '2025-01-09 20:18:19', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (76, 1, 'Tinevimbo Chinodyaruswa', '5323', '2025-01-02', '55.00', 'Blazer, satchel', 'yes', NULL, 'no', '2025-01-09 20:20:33', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (77, 1, 'Cleopatra Karombo', '5324', '2025-01-02', '40.00', 'Tie, skirt, shirt, sun hat', 'yes', NULL, 'no', '2025-01-09 20:22:13', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (78, 1, 'Sharmaine Machoko', '5325', '2025-01-03', '100.00', 'Tie, full jersey, sun hat, track suit, golf t-shirt, skirt', 'yes', NULL, 'no', '2025-01-09 20:42:03', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (79, 1, 'Rufaro Chawira', '5326', '2025-01-03', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 20:44:24', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (80, 1, 'Calvin Suruma', '5327', '2025-01-03', '160.00', 'tie,full jersey, s/sleeve shirt, trousers, blazer, t shirt, tracksuit, sports short, satchel', 'yes', NULL, 'no', '2025-01-09 20:57:02', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (81, 1, 'Praise Kufa', '5328', '2025-01-04', '90.00', 'Starter pack (balance $50)', 'yes', NULL, 'no', '2025-01-09 21:11:35', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (82, 1, 'Tawananyasha Gwanzura', '5330', '2025-01-04', '18.00', 'Trousers', 'yes', NULL, 'no', '2025-01-09 21:12:43', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (83, 1, 'Anotidaishe Tarubuda', '5330', '2025-01-06', '140.00', 'starter pack', 'yes', NULL, 'no', '2025-01-09 21:14:05', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (84, 1, 'Jerina Ziki', '5331', '2025-01-06', '93.00', 'full jersey, tracksuit, satchel, skirt', 'yes', NULL, 'no', '2025-01-09 21:15:51', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (85, 1, 'Blessing Mavhengere', '5332', '2025-01-07', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 21:17:00', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (86, 1, 'Tinayeishe Dikito', '5333', '2025-01-08', '150.00', 'Starter pack, t shirt', 'yes', NULL, 'no', '2025-01-09 21:18:05', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (87, 1, 'Roy Kwandasviks', '5334', '2025-01-09', '140.00', 'Starter pack', 'yes', NULL, 'no', '2025-01-09 21:19:19', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (88, 1, 'Roy Kwandasvika', '5335', '2025-01-09', '20.00', 't shirt, sports short', 'yes', NULL, 'no', '2025-01-09 21:21:12', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (89, 1, 'Trinity Shoko', '5337', '2025-01-09', '10.00', 'T shirt', 'yes', NULL, 'no', '2025-01-09 21:21:47', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (90, 1, 'Jerina Ziki', '5338', '2025-01-10', '32.00', 'tie, shirt, sunhat,t shirt', 'yes', NULL, 'no', '2025-01-11 12:25:21', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (91, 1, 'Bilton Manceye', '5339', '2025-01-10', '68.00', 'Short, rrousers, satchel, s/sleeve shirt', 'yes', NULL, 'no', '2025-01-11 12:26:37', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (92, 1, 'Bilton Manceye', '5340', '2025-01-10', '2.00', 'socks', 'yes', NULL, 'no', '2025-01-11 12:27:26', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (93, 1, 'Brighton Rihambe', '5341', '2025-01-10', '20.00', 'Sports short, t shirt', 'yes', NULL, 'no', '2025-01-11 12:28:40', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (94, 1, 'Shammah Gonese', '5342', '2025-01-11', '95.00', 'tie, skirt, blazer. sunhat, skirt, satchel', 'yes', NULL, 'no', '2025-01-11 12:31:07', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (95, 2, 'Bilton Manceye', '066', '2025-01-10', '40.00', '', 'yes', NULL, 'no', '2025-01-11 13:22:58', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (96, 3, 'Bilton Manceye', '066', '2025-01-10', '10.00', '', 'yes', NULL, 'no', '2025-01-11 13:23:27', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (97, 2, 'Tatenda Sithole', '5012', '2025-01-13', '40.00', '', 'yes', NULL, 'no', '2025-01-13 17:05:19', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (98, 3, 'Tatenda Sithole', '5012', '2025-01-13', '10.00', '', 'yes', NULL, 'no', '2025-01-13 17:05:46', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (99, 1, 'Tatenda Sithole', '5343', '2025-01-13', '50.00', 'skirt, shirt, tie, full jersey', 'yes', NULL, 'no', '2025-01-13 17:07:06', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (100, 1, 'Takudzwa Mpansi', '5344', '2025-01-13', '25.00', 'Satchel', 'yes', NULL, 'no', '2025-01-13 17:07:46', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (101, 1, 'cleopatra karombo', '5345', '2025-01-13', '55.00', 'full jersey, tracksuit, t shirt', 'yes', NULL, 'no', '2025-01-13 17:08:48', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (102, 1, 'cleopatra karombo', '5346', '2025-01-13', '5.00', 'cap', 'yes', NULL, 'no', '2025-01-13 17:09:27', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (103, 2, 'Alex Chinzambwa', '5021', '2025-01-16', '40.00', '', 'yes', NULL, 'no', '2025-01-17 17:36:05', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (104, 3, 'Alex Chinzambwa', '5021', '2025-01-16', '10.00', '', 'yes', NULL, 'no', '2025-01-17 17:36:32', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (105, 2, 'moses mlotshwa', '075', '2025-01-15', '40.00', '', 'yes', NULL, 'no', '2025-01-18 11:36:11', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (106, 3, 'moses mlotshwa', '075', '2025-01-15', '10.00', '', 'yes', NULL, 'no', '2025-01-18 11:36:45', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (107, 2, 'Emmanuel Mutenga', '072', '2025-01-14', '40.00', '', 'yes', NULL, 'no', '2025-01-18 12:11:08', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (108, 3, 'Emmanuel Mutenga', '072', '2025-01-14', '10.00', '', 'yes', NULL, 'no', '2025-01-18 12:12:23', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (109, 2, 'Tawananyasha Nemuramba', '070', '2025-01-12', '40.00', '', 'yes', NULL, 'no', '2025-01-18 12:15:30', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (110, 3, 'Tawananyasha Nemuramba', '070', '2025-01-12', '10.00', '', 'yes', NULL, 'no', '2025-01-18 12:16:46', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (111, 1, 'tawananyasha nemuramba', '5347', '2025-01-14', '70.00', 'starter pack ($70)', 'yes', NULL, 'no', '2025-01-18 13:22:22', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (112, 1, 'Tyler mwariwangu', '5348', '2025-01-14', '15.00', 'long sleeve shirt', 'yes', NULL, 'no', '2025-01-18 13:23:11', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (113, 1, 'praise mahere', '5349', '2025-01-14', '25.00', 'full jersey, t shirt', 'yes', NULL, 'no', '2025-01-18 13:24:48', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (114, 1, 'Fadzai Kwngwiri', '5350', '2025-01-14', '70.00', 's/sleeve shirt, skirt,tie, tracksuit, sunhat', 'yes', NULL, 'no', '2025-01-18 13:26:37', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (115, 1, 'emmanuel mutenga', '5351', '2025-01-14', '80.00', 'tie, shirt, trousers, tracksuit, t shirt, sunhat', 'yes', NULL, 'no', '2025-01-18 13:28:07', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (116, 1, 'caroline muparutsa', '5352', '2025-01-14', '5.00', 'cap', 'yes', NULL, 'no', '2025-01-18 13:28:56', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (117, 1, 'praise mahere', '5353', '2025-01-14', '5.00', 'cap', 'yes', NULL, 'no', '2025-01-18 13:29:30', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (118, 1, 'tatenda sithole', '5354', '2025-01-14', '35.00', 'tracksuit, sunhat', 'yes', NULL, 'no', '2025-01-18 13:30:30', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (119, 1, 'tatenda sithole', '5356', '2025-01-14', '10.00', 't shirt', 'yes', NULL, 'no', '2025-01-18 13:31:11', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (120, 1, 'believe bene', '5357', '2025-01-15', '10.00', 't shirt', 'yes', NULL, 'no', '2025-01-18 13:31:50', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (121, 1, 'moses mlotshwa', '5358', '2025-01-15', '90.00', 'tie, s/sleeve shirt, trousers, sunhat, tracksuit, t shirt, short', 'yes', NULL, 'no', '2025-01-18 13:33:14', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (122, 1, 'moses mlotshwa', '5359', '2025-01-15', '5.00', 'cap', 'yes', NULL, 'no', '2025-01-18 13:34:05', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (123, 1, 'takudzwa mpansi', '5361', '2025-01-15', '15.00', 'full jersey', 'yes', NULL, 'no', '2025-01-18 13:35:19', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (124, 1, 'anotida mudando', '5362', '2025-01-15', '15.00', 'full jersey', 'yes', NULL, 'no', '2025-01-18 13:36:21', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (125, 1, 'rufaro chawira', '5363', '2025-01-15', '10.00', 't shirt', 'yes', NULL, 'no', '2025-01-18 13:36:59', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (126, 1, 'fadzai kwangwari', '5364', '2025-01-15', '15.00', 'cap, t shirt', 'yes', NULL, 'no', '2025-01-18 13:37:47', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (127, 1, 'kimberly chibade', '5365', '2025-01-16', '20.00', 'sports short, t shirt', 'yes', NULL, 'no', '2025-01-18 13:38:48', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (128, 1, 'elton pinzirai', '5366', '2025-01-17', '40.00', 'sunhat, s/sleeve shirt, trousers, satchel, (balance $21)', 'yes', NULL, 'no', '2025-01-18 13:40:02', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (129, 1, 'rufaro chawira', '5357', '2025-01-17', '5.00', 'cap', 'yes', NULL, 'no', '2025-01-18 13:40:33', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (130, 1, 'fadzai kwangwari', '5368', '2025-01-20', '30.00', 'blazer', 'yes', NULL, 'no', '2025-01-22 12:11:32', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (131, 1, 'alex chinzambwa', '5369', '2025-01-20', '17.00', 'shirt, tie', 'yes', NULL, 'no', '2025-01-22 12:15:14', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (132, 1, 'ashilla manake', '5370', '2025-01-20', '10.00', 't shirt', 'yes', NULL, 'no', '2025-01-22 12:16:11', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (133, 1, 'bilton manceye', '5371', '2025-01-20', '4.00', 'tie', 'yes', NULL, 'no', '2025-01-22 12:22:01', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (134, 1, 'alex chinzambwa', '2472', '2025-01-21', '18.00', 'trousers', 'yes', NULL, 'no', '2025-01-22 12:23:02', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (135, 1, 'tawananyasha meki', '2473', '2025-01-21', '48.00', 'tracksuit, trousers', 'yes', NULL, 'no', '2025-01-22 12:24:02', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (136, 1, 'tinevimbo chinodyaruswa', '5374', '2025-01-20', '10.00', 't shirt', 'yes', NULL, 'no', '2025-01-22 12:25:07', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (137, 1, 'Moses Mlotshwa', '5375', '2025-01-23', '30.00', 'Blazer', 'yes', NULL, 'no', '2025-01-28 11:19:12', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (138, 1, 'Bilton Manceye', '5376', '2025-01-28', '30.00', 'Tracksuit', 'yes', NULL, 'no', '2025-01-28 11:20:27', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (139, 1, 'Brighton Rihambe', '5378', '2025-01-30', '20.00', 'Full Jersey', 'yes', NULL, 'no', '2025-01-30 14:25:02', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (140, 1, 'Tamia Munetsi', '5379', '2025-02-04', '20.00', 't-shirt, short', 'yes', NULL, 'no', '2025-02-04 12:38:07', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (141, 1, 'Takunda Chivese', '5380', '2025-02-05', '25.00', 'Satchel', 'yes', NULL, 'no', '2025-02-06 12:05:50', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (142, 1, 'Emmanuel Mutenga', '5381', '2025-02-06', '30.00', 'Blazer', 'yes', NULL, 'no', '2025-02-06 12:07:03', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (143, 1, 'Praise Kufa', '5382', '2025-02-06', '50.00', 'Starter pack balance', 'yes', NULL, 'no', '2025-02-06 12:07:51', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (144, 1, 'Praise Mahere', '5383', '2025-02-06', '10.00', 'Sports Short', 'yes', NULL, 'no', '2025-02-06 12:08:46', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (145, 1, 'Aaliyah Mutengu', '5384', '2025-02-10', '10.00', 'T=SHIRT', 'yes', NULL, 'no', '2025-02-10 12:32:11', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (146, 1, 'Tadiwanashe Daka', '5385', '2025-02-10', '10.00', 'Sports Short', 'yes', NULL, 'no', '2025-02-10 12:33:01', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (147, 1, 'Fadzai Kwangwari', '5386', '2025-02-10', '26.00', 'Slack, Sports short', 'yes', NULL, 'no', '2025-02-11 14:46:02', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (148, 1, 'Alex Chinzambwa', '5387', '2025-02-11', '5.00', 'Cap', 'yes', NULL, 'no', '2025-02-11 14:46:34', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (149, 4, 'Primary & College Civvies Day', '', '2025-02-14', '388.00', 'College $114, Primary School $228.5, ECD $46', 'yes', NULL, 'no', '2025-02-17 18:04:37', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (150, 1, 'Blessing Mavhengere', '5388', '2025-02-12', '10.00', 'T-Shirt', 'yes', NULL, 'no', '2025-02-19 11:34:38', NULL);
INSERT INTO `income` (`id`, `income_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (151, 1, 'Ashilla Manake', '5389', '2025-02-18', '10.00', 'Sports Short', 'yes', NULL, 'no', '2025-02-19 11:35:14', NULL);


#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 'Uniforms', '', 'yes', 'no', '2024-12-05 18:40:40', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 'Registration Fee', '', 'yes', 'no', '2024-12-09 15:30:13', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (3, 'Application Fee', '', 'yes', 'no', '2024-12-09 15:34:05', NULL);
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (4, 'Civvies 1st Term', '', 'yes', 'no', '2025-02-17 18:00:46', NULL);


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_category_id` int DEFAULT NULL,
  `item_store_id` int DEFAULT NULL,
  `item_supplier_id` int DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `quantity` int NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `item_store_id` (`item_store_id`),
  KEY `item_supplier_id` (`item_supplier_id`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_2` FOREIGN KEY (`item_store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_3` FOREIGN KEY (`item_supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (1, 7, NULL, NULL, 'Dungaree serge grey dress', '32', NULL, '24x-3,\r\n26x-10,\r\n28x-10,\r\n30x-3,\r\n32x-3,\r\n36x-3', 0, NULL, '2025-01-13 11:10:47', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (2, 8, NULL, NULL, 'Size 12 White Short Sleeve Shirts', '3', NULL, 'Size 12', 0, NULL, '2025-01-13 11:13:43', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (3, 8, NULL, NULL, 'Size 13 White Short Sleeve Shirts', '23', NULL, '13x-10,\r\n14x-10,\r\n15x-3', 0, NULL, '2025-01-13 11:13:30', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (4, 6, NULL, NULL, 'Size 12 Maroon Shirts', '3', NULL, 'Size 12', 0, NULL, '2025-01-13 11:15:47', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (5, 6, NULL, NULL, 'Size 13 Maroon Shirts', '27', NULL, '13x-10,\r\n14x-10,\r\n15x-7', 0, NULL, '2025-01-13 11:16:50', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (6, 9, NULL, NULL, 'Size 30 Grey Shorts', '23', NULL, '30x-3,\r\n28x-5,\r\n26x-10,\r\n24x-5', 0, NULL, '2025-01-13 12:55:41', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (7, 9, NULL, NULL, 'Size 36 Grey Shorts', '33', NULL, '36x-25,\r\n38x-8', 0, NULL, '2025-01-13 12:56:30', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (8, 9, NULL, NULL, 'Size 40 Grey Shorts', '2', NULL, 'Size 40', 0, NULL, '2025-01-13 12:57:10', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (9, 2, NULL, NULL, 'Grey Slax Trousers', '20', NULL, '26x-5,\r\n28x-5,\r\n30x-5,\r\n32x-5', 0, NULL, '2025-01-13 12:59:23', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (10, 4, NULL, NULL, 'B15 Grey Trousers', '8', NULL, 'B15x-8', 0, NULL, '2025-01-13 13:00:07', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (11, 4, NULL, NULL, 'Grey Trousers', '15', NULL, 'M2x-8,\r\nM3x-2,\r\nM4x-4,\r\nM6x-1', 0, NULL, '2025-01-13 13:00:47', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (12, 4, NULL, NULL, 'Size B4 Trousers', '15', NULL, 'B4x-5,\r\nB6x-10', 0, NULL, '2025-01-13 13:04:15', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (13, 4, NULL, NULL, 'Size B9 Grey Trousers', '8', NULL, 'B9x-3,\r\nB7x-5', 0, NULL, '2025-01-13 13:04:48', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (14, 4, NULL, NULL, 'B15 Grey Trousers 2', '10', NULL, 'B15x-10', 0, NULL, '2025-01-13 13:05:40', NULL);
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`, `updated_at`) VALUES (15, 4, NULL, NULL, 'Size M6 Grey Trousers', '25', NULL, 'M6x-2,\r\nM4x-8,\r\nM3x-5,\r\nM2x-10', 0, NULL, '2025-01-13 13:06:38', NULL);


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (2, 'SA College Girls Grey Slax', 'yes', 'Purchased from South Africa College Girls Trousers ', '2025-01-13 10:57:45', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (3, 'SA Primary Girls Grey Slax', 'yes', 'Purchased from South Africa Primary Girls Trousers', '2025-01-13 10:57:56', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (4, 'SA College Boys Grey Serge Trousers', 'yes', 'Purchased from South Africa College Grey Trousers', '2025-01-13 10:59:39', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (5, 'SA Primary Girls Tunics', 'yes', 'Purchased from South Africa Girls Tunic', '2025-01-13 11:05:49', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (6, 'SA College Maroon Short Sleeve Shirts', 'yes', 'Purchased from South Africa Maroon Shirts', '2025-01-13 11:15:07', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (7, 'SA Primary Girls Dungaree Serge Grey Dress', 'yes', 'Purchased from South Africa Primary Grey Dress', '2025-01-13 11:05:39', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (8, 'SA College Girls Short Sleeve White Shirts', 'yes', 'Purchased from South Africa College White Shirts', '2025-01-13 11:07:42', NULL);
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (9, 'SA College Grey Shorts', 'yes', 'Purchased from South Africa Grey Shorts', '2025-01-13 11:07:00', NULL);


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `issue_type` varchar(15) DEFAULT NULL,
  `issue_to` int NOT NULL,
  `issue_by` int DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `quantity` int NOT NULL,
  `note` text NOT NULL,
  `is_returned` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_active` varchar(10) DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  KEY `issue_by` (`issue_by`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_3` FOREIGN KEY (`issue_to`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_4` FOREIGN KEY (`issue_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `quantity` int DEFAULT NULL,
  `purchase_price` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (1, 'Director\'s Stores', 'DS', 'Items stored at Director\'s Office', '2025-01-13 13:10:58');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (2, 'Administrator\'s Stores', 'AD', 'Items stored at Admin Office', '2025-01-13 13:11:43');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`) VALUES (1, 'A-Wear Clothing South Africa', '27694140107', 'zubair@awear.co.za', 'Fordsburg 2033', 'Zubair', '27694140107', 'zubair@awear.co.za', 'Supplies Uniforms to Southmews from South Africa');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_rtl` int NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb3;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 0, 'no', 'no', '2019-11-20 13:23:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 0, 'no', 'no', '2019-11-20 13:42:42', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 0, 'no', 'no', '2019-11-20 13:38:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 0, 'no', 'no', '2019-11-20 13:47:28', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 0, 'no', 'no', '2019-11-20 13:54:10', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 0, 'no', 'no', '2019-11-20 13:41:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 0, 'no', 'no', '2021-01-23 09:09:32', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 0, 'no', 'no', '2019-11-20 14:12:08', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 0, 'no', 'no', '2019-11-20 14:11:40', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 0, 'no', 'no', '2019-11-20 13:39:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 0, 'no', 'no', '2019-11-20 14:03:25', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 0, 'no', 'no', '2019-11-20 14:13:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 0, 'no', 'no', '2019-11-20 14:25:33', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'kn', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 0, 'no', 'no', '2019-11-20 14:01:48', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 0, 'no', 'no', '2019-11-20 14:19:09', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 0, 'no', 'no', '2019-11-20 14:24:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'it', 0, 'no', 'no', '2021-01-23 09:09:32', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 0, 'no', 'no', '2019-11-20 14:20:27', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 0, 'no', 'no', '2019-11-20 13:39:51', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 0, 'no', 'no', '2019-11-20 13:40:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 0, 'no', 'no', '2019-11-20 14:21:17', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 0, 'no', 'no', '2019-11-20 13:59:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'lk ', 0, 'no', 'no', '2021-01-23 09:09:32', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 0, 'no', 'no', '2019-11-20 14:21:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 0, 'no', 'no', '2019-12-03 13:06:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 0, 'no', 'no', '2019-11-20 13:40:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 0, 'no', 'no', '2019-11-20 13:41:15', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 0, 'no', 'no', '2019-11-20 14:23:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 0, 'no', 'no', '2019-11-20 13:36:34', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 0, 'no', 'no', '2019-11-20 14:02:36', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 0, 'no', 'no', '2019-11-20 13:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 0, 'no', 'no', '2019-11-21 06:49:18', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 0, 'no', 'no', '2019-11-20 14:18:29', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 0, 'no', 'no', '2019-11-20 14:14:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 0, 'no', 'no', '2020-06-15 05:25:27', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'Kurdish', 'ku', 'iq', 0, 'no', 'no', '2020-12-21 02:15:31', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'Lao', 'lo', 'la', 0, 'no', 'no', '2020-12-21 02:15:36', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'Croatia', 'hr', 'hr', 0, 'no', 'no', '2022-06-07 13:48:21', '0000-00-00');


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: lesson
#

DROP TABLE IF EXISTS `lesson`;

CREATE TABLE `lesson` (
  `id` int NOT NULL AUTO_INCREMENT,
  `session_id` int NOT NULL,
  `subject_group_subject_id` int NOT NULL,
  `subject_group_class_sections_id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  KEY `subject_group_class_sections_id` (`subject_group_class_sections_id`),
  CONSTRAINT `lesson_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_ibfk_2` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_ibfk_3` FOREIGN KEY (`subject_group_class_sections_id`) REFERENCES `subject_group_class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: lesson_plan_forum
#

DROP TABLE IF EXISTS `lesson_plan_forum`;

CREATE TABLE `lesson_plan_forum` (
  `id` int NOT NULL AUTO_INCREMENT,
  `subject_syllabus_id` int NOT NULL,
  `type` varchar(20) NOT NULL COMMENT 'staff,student',
  `staff_id` int DEFAULT NULL,
  `student_id` int DEFAULT NULL,
  `message` text NOT NULL,
  `created_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subject_syllabus_id` (`subject_syllabus_id`),
  KEY `student_id` (`student_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `lesson_plan_forum_ibfk_1` FOREIGN KEY (`subject_syllabus_id`) REFERENCES `subject_syllabus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_plan_forum_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_plan_forum_ibfk_3` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: libarary_members
#

DROP TABLE IF EXISTS `libarary_members`;

CREATE TABLE `libarary_members` (
  `id` int NOT NULL AUTO_INCREMENT,
  `library_card_no` varchar(50) DEFAULT NULL,
  `member_type` varchar(50) DEFAULT NULL,
  `member_id` int DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message` text,
  `record_id` text,
  `user_id` int DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `platform` varchar(50) DEFAULT NULL,
  `agent` varchar(50) DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1923 DEFAULT CHARSET=utf8mb3;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On settings id 1', '1', 1, 'Update', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:11:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated On settings id 1', '1', 1, 'Update', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:13:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record updated On settings id 1', '1', 1, 'Update', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:14:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record updated On settings id 1', '1', 1, 'Update', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:14:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'Record updated On settings id 1', '1', 1, 'Update', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:14:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'Record updated On Front CMS Setting id 1', '1', 1, 'Update', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:17:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'Record updated On settings id 1', '1', 1, 'Update', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:17:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'New Record inserted On student edit fields id 1', '1', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:18:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'Record updated On settings id 1', '1', 1, 'Update', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:18:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'New Record inserted On student edit fields id 2', '2', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:18:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'New Record inserted On student edit fields id 3', '3', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:18:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'New Record inserted On student edit fields id 4', '4', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'New Record inserted On student edit fields id 5', '5', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'New Record inserted On student edit fields id 6', '6', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'New Record inserted On student edit fields id 7', '7', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'New Record inserted On student edit fields id 8', '8', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'New Record inserted On student edit fields id 9', '9', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'New Record inserted On student edit fields id 10', '10', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'New Record inserted On student edit fields id 11', '11', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'New Record inserted On student edit fields id 12', '12', 1, 'Insert', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'Record updated On settings id 1', '1', 1, 'Update', '171.48.110.174', 'Windows 10', 'Chrome 128.0.0.0', '2024-09-04 07:19:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-26 18:41:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'Record updated On  student edit fields id 12', '12', 1, 'Update', '197.221.255.9', 'Windows 10', 'Firefox 132.0', '2024-11-27 04:47:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'Record updated On  student edit fields id 12', '12', 1, 'Update', '197.221.255.9', 'Windows 10', 'Firefox 132.0', '2024-11-27 04:47:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'Record updated On settings id 1', '1', 1, 'Update', '197.221.255.9', 'Windows 10', 'Firefox 132.0', '2024-11-27 04:48:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 09:28:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 09:28:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 16:37:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:13:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:13:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:14:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:15:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:16:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:16:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:16:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:18:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:18:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:19:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:19:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:20:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:20:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:21:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:21:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:27:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:27:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:28:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:28:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:34:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'Record updated On settings id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Chrome 131.0.0.0', '2024-11-27 21:35:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'New Record inserted On  staff designation id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:16:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'New Record inserted On  staff designation id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:17:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'New Record inserted On  staff designation id 3', '3', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:18:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'New Record inserted On  staff designation id 4', '4', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:19:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'New Record inserted On  staff designation id 5', '5', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:21:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'New Record inserted On  staff designation id 6', '6', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:24:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'New Record inserted On  staff designation id 7', '7', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:24:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'New Record inserted On  staff designation id 8', '8', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:27:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'Record updated On  staff designation id 8', '8', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:27:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'New Record inserted On  staff designation id 9', '9', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:29:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'New Record inserted On  staff designation id 10', '10', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:29:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'New Record inserted On department id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:32:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'New Record inserted On department id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:33:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'New Record inserted On department id 3', '3', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:33:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'New Record inserted On department id 4', '4', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:33:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'New Record inserted On department id 5', '5', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:34:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'New Record inserted On department id 6', '6', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:35:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'Record updated On staff id 2', '2', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:39:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'New Record inserted On  income head   id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:40:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'New Record inserted On  expense head id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:43:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'New Record inserted On  expense head id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:44:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'New Record inserted On  expense head id 3', '3', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:44:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'New Record inserted On  expense head id 4', '4', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:45:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'New Record inserted On  expense head id 5', '5', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:46:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'New Record inserted On  expense head id 6', '6', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:47:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'Record updated On  expense head id 6', '6', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:48:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'New Record inserted On  expense head id 7', '7', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:48:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'New Record inserted On  expense head id 8', '8', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:49:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'New Record inserted On  expense head id 9', '9', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:50:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'New Record inserted On  expense head id 10', '10', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:52:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'New Record inserted On  expense head id 11', '11', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:53:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'Record updated On settings id 1', '1', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-05 18:58:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'New Record inserted On sections id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:30:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'Record updated On sections id 1', '1', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:31:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'New Record inserted On sections id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:31:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'New Record inserted On subject groups id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:31:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'New Record inserted On subject groups id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:33:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'New Record inserted On subject groups id 3', '3', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:33:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'New Record inserted On subject groups id 4', '4', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:34:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'New Record inserted On subject groups id 5', '5', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:34:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'New Record inserted On subjects id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:35:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'New Record inserted On subjects id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:37:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'Record updated On subjects id 1', '1', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 06:38:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'New Record inserted On  fee type id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:41:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'Record updated On  fee type id 1', '1', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:42:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'Record updated On  fee type id 1', '1', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:43:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'New Record inserted On  fee type id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:44:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'Record updated On  fee type id 2', '2', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:44:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'Record updated On  fee type id 1', '1', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:45:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'New Record inserted On  fee type id 3', '3', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:46:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'Record updated On  fee type id 2', '2', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:46:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'New Record inserted On  fee type id 4', '4', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:48:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'New Record inserted On  fee type id 5', '5', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:50:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'Record updated On  fee type id 4', '4', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:50:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'New Record inserted On  fee group id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:52:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'New Record inserted On  fee group id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:52:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'New Record inserted On  fee groups feetype id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:53:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'New Record inserted On  fee groups feetype id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:54:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'Record updated On  fee group id 2', '2', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:56:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'New Record inserted On  fee group id 3', '3', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:57:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'New Record inserted On  fee group id 4', '4', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:57:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'New Record inserted On  fee group id 5', '5', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:57:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'New Record inserted On  fee groups feetype id 3', '3', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:58:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'New Record inserted On  fee groups feetype id 4', '4', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 07:59:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'New Record inserted On  fee groups feetype id 5', '5', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:00:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'Record updated On  student edit fields id 4', '4', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:04:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'Record updated On  student edit fields id 7', '7', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:04:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'Record updated On  student edit fields id 12', '12', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:05:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'New Record inserted On student edit fields id 13', '13', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:05:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'Record updated On settings id 1', '1', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:05:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'New Record inserted On students id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'New Record inserted On  student session id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'New Record inserted On users id 1', '1', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'New Record inserted On users id 2', '2', 1, 'Insert', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'Record updated On students id 1', '1', 1, 'Update', '102.128.79.145', 'Windows 10', 'Firefox 133.0', '2024-12-06 08:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'New Record inserted On  fee type id 6', '6', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:15:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'New Record inserted On  fee type id 7', '7', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:16:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'New Record inserted On  fee type id 8', '8', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:17:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'New Record inserted On  fee type id 9', '9', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:19:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'New Record inserted On  fee type id 10', '10', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:22:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'New Record inserted On  fee type id 11', '11', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:24:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'New Record inserted On  fee type id 12', '12', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:24:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'New Record inserted On  fee type id 13', '13', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:25:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'New Record inserted On  fee type id 14', '14', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:26:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'New Record inserted On  fee type id 15', '15', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:27:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'Record updated On  fee type id 11', '11', 1, 'Update', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:27:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'Record updated On  fee type id 12', '12', 1, 'Update', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:28:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'Record updated On  fee type id 12', '12', 1, 'Update', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:28:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'Record deleted On  fee type id 15', '15', 1, 'Delete', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:48:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'Record deleted On  fee type id 14', '14', 1, 'Delete', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:48:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'Record updated On  fee type id 4', '4', 1, 'Update', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:49:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'Record updated On  fee type id 5', '5', 1, 'Update', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:49:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'New Record inserted On  fee type id 16', '16', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 07:50:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'New Record inserted On  fee type id 17', '17', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:15:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'New Record inserted On students id 2', '2', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:21:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'New Record inserted On  student session id 2', '2', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:21:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'New Record inserted On users id 3', '3', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:21:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'New Record inserted On users id 4', '4', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:21:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'Record updated On students id 2', '2', 1, 'Update', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:21:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'New Record inserted On students id 3', '3', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'New Record inserted On  student session id 3', '3', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'New Record inserted On users id 5', '5', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'New Record inserted On users id 6', '6', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'Record updated On students id 3', '3', 1, 'Update', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'New Record inserted On  fee group id 6', '6', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:34:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'New Record inserted On  fee groups feetype id 6', '6', 1, 'Insert', '102.128.76.144', 'Windows 10', 'Firefox 133.0', '2024-12-07 08:36:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'Record updated On  fee group id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:37:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'Record updated On  fee group id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:37:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'Record updated On  fee group id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:37:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'Record updated On  fee group id 4', '4', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:37:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'Record updated On  fee group id 6', '6', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:38:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'Record deleted On  fee group id 6', '6', 1, 'Delete', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:38:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'Record updated On  fee group id 5', '5', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:38:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'New Record inserted On  fee groups feetype id 7', '7', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:39:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'New Record inserted On  fee groups feetype id 8', '8', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:39:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'New Record inserted On  fee groups feetype id 9', '9', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:40:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'New Record inserted On  fee groups feetype id 10', '10', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:41:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'New Record inserted On  fee groups feetype id 11', '11', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:41:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'New Record inserted On  fee groups feetype id 12', '12', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:41:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'New Record inserted On  fee groups feetype id 13', '13', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:42:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'New Record inserted On  fee groups feetype id 14', '14', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:43:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'Record updated On  fee group id 5', '5', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:46:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'Record updated On  fee group id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:46:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'New Record inserted On  fee groups feetype id 15', '15', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:47:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'New Record inserted On  fee groups feetype id 16', '16', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:47:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'New Record inserted On students id 4', '4', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'New Record inserted On  student session id 4', '4', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'New Record inserted On users id 7', '7', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'New Record inserted On users id 8', '8', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'Record updated On students id 4', '4', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'New Record inserted On roles id 8', '8', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 14:53:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'Record updated On roles id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 15:07:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'Record updated On staff id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 15:17:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'Record updated On staff id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 15:19:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'Record updated On staff id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 15:19:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'New Record inserted On roles id 9', '9', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 15:21:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'New Record inserted On  income head   id 2', '2', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 15:30:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'New Record inserted On  income head   id 3', '3', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 15:34:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'New Record inserted On  expense head id 12', '12', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 16:05:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'New Record inserted On  expense head id 13', '13', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 16:06:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'New Record inserted On  expense head id 14', '14', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 16:06:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'New Record inserted On  expense head id 15', '15', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 16:06:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'Record updated On  expense head id 13', '13', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-09 16:06:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'New Record inserted On subjects id 3', '3', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:31:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'New Record inserted On subjects id 4', '4', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:33:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'Record updated On subjects id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:33:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'Record updated On subjects id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:34:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'Record updated On subjects id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:34:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'Record updated On subjects id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:34:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'Record updated On subjects id 4', '4', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:34:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'New Record inserted On subjects id 5', '5', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:41:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On subjects id 6', '6', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:41:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'New Record inserted On subjects id 7', '7', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:41:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'New Record inserted On subjects id 8', '8', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:43:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'New Record inserted On subjects id 9', '9', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:43:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'New Record inserted On subjects id 10', '10', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:43:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'Record updated On subjects id 9', '9', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 11:43:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'New Record inserted On subjects id 11', '11', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 14:34:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'New Record inserted On subjects id 12', '12', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 14:34:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'New Record inserted On subjects id 13', '13', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 14:35:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'New Record inserted On subject groups id 1', '1', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 14:37:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'New Record inserted On subject groups id 2', '2', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 14:38:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'New Record inserted On subject groups id 3', '3', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 14:39:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'New Record inserted On subject groups id 4', '4', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 14:40:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'New Record inserted On subject groups id 5', '5', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 133.0', '2024-12-10 14:40:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'New Record inserted On students id 5', '5', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:10:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'New Record inserted On  student session id 5', '5', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:10:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On users id 9', '9', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:10:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'New Record inserted On users id 10', '10', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:10:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'Record updated On students id 5', '5', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:10:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'New Record inserted On students id 6', '6', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:14:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'New Record inserted On  student session id 6', '6', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:14:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'New Record inserted On users id 11', '11', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:14:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'New Record inserted On users id 12', '12', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:14:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'Record updated On students id 6', '6', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:14:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'New Record inserted On students id 7', '7', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:17:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'New Record inserted On  student session id 7', '7', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:17:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'New Record inserted On users id 13', '13', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:17:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'New Record inserted On users id 14', '14', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:17:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'Record updated On students id 7', '7', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:17:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'New Record inserted On students id 8', '8', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:24:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'New Record inserted On  student session id 8', '8', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:24:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'New Record inserted On users id 15', '15', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:24:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'New Record inserted On users id 16', '16', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:24:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'Record updated On students id 8', '8', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:24:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'New Record inserted On students id 9', '9', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:30:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'New Record inserted On  student session id 9', '9', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:30:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'New Record inserted On users id 17', '17', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:30:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'New Record inserted On users id 18', '18', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:30:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'Record updated On students id 9', '9', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:30:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'New Record inserted On students id 10', '10', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:32:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'New Record inserted On  student session id 10', '10', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:32:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'New Record inserted On users id 19', '19', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:32:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'New Record inserted On users id 20', '20', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:32:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'Record updated On students id 10', '10', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:32:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'New Record inserted On students id 11', '11', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:36:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'New Record inserted On  student session id 11', '11', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:36:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'New Record inserted On users id 21', '21', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'New Record inserted On users id 22', '22', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'Record updated On students id 11', '11', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'New Record inserted On students id 12', '12', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:40:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'New Record inserted On  student session id 12', '12', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:40:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'New Record inserted On users id 23', '23', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:40:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'New Record inserted On users id 24', '24', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:40:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'Record updated On students id 12', '12', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:40:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'New Record inserted On students id 13', '13', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:43:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'New Record inserted On  student session id 13', '13', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:43:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'New Record inserted On users id 25', '25', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:43:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'New Record inserted On users id 26', '26', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:43:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'Record updated On students id 13', '13', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:43:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'New Record inserted On students id 14', '14', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'New Record inserted On  student session id 14', '14', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'New Record inserted On users id 27', '27', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'New Record inserted On users id 28', '28', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'Record updated On students id 14', '14', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'New Record inserted On students id 15', '15', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:54:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'New Record inserted On  student session id 15', '15', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:54:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'New Record inserted On users id 29', '29', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:54:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'New Record inserted On users id 30', '30', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:54:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'Record updated On students id 15', '15', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:54:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'New Record inserted On students id 16', '16', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:57:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (271, 'New Record inserted On  student session id 16', '16', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:57:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (272, 'New Record inserted On users id 31', '31', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:57:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (273, 'New Record inserted On users id 32', '32', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:57:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'Record updated On students id 16', '16', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 14:57:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'New Record inserted On students id 17', '17', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:02:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'New Record inserted On  student session id 17', '17', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:02:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'New Record inserted On users id 33', '33', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:02:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (278, 'New Record inserted On users id 34', '34', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:02:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (279, 'Record updated On students id 17', '17', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:02:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (280, 'New Record inserted On students id 18', '18', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:05:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (281, 'New Record inserted On  student session id 18', '18', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:05:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (282, 'New Record inserted On users id 35', '35', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:05:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (283, 'New Record inserted On users id 36', '36', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:05:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'Record updated On students id 18', '18', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:05:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'New Record inserted On students id 19', '19', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'New Record inserted On  student session id 19', '19', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (287, 'New Record inserted On users id 37', '37', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (288, 'New Record inserted On users id 38', '38', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (289, 'Record updated On students id 19', '19', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (290, 'New Record inserted On students id 20', '20', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:12:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (291, 'New Record inserted On  student session id 20', '20', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:12:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (292, 'New Record inserted On users id 39', '39', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:12:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (293, 'New Record inserted On users id 40', '40', 3, 'Insert', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:12:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (294, 'Record updated On students id 20', '20', 3, 'Update', '102.128.76.203', 'Windows 10', 'Firefox 134.0', '2024-12-18 15:12:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (295, 'New Record inserted On  expense head id 16', '16', 2, 'Insert', '102.128.76.207', 'Windows 10', 'Firefox 133.0', '2025-01-01 21:29:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (296, 'New Record inserted On  expenses   id 1', '1', 2, 'Insert', '102.128.76.207', 'Windows 10', 'Firefox 133.0', '2025-01-01 21:30:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (297, 'Record updated On staff id 3', '3', 1, 'Update', '102.128.79.252', 'Windows 10', 'Firefox 133.0', '2025-01-02 10:32:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (298, 'Record updated On staff id 3', '3', 1, 'Update', '102.128.79.252', 'Windows 10', 'Firefox 133.0', '2025-01-02 10:32:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (299, 'New Record inserted On  expenses   id 2', '2', 2, 'Insert', '102.128.79.173', 'Windows 10', 'Firefox 133.0', '2025-01-02 12:16:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (300, 'New Record inserted On students id 21', '21', 3, 'Insert', '77.246.55.175', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:19:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (301, 'New Record inserted On  student session id 21', '21', 3, 'Insert', '77.246.55.175', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:19:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (302, 'New Record inserted On users id 41', '41', 3, 'Insert', '77.246.55.175', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:19:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (303, 'New Record inserted On users id 42', '42', 3, 'Insert', '77.246.55.175', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:19:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (304, 'Record updated On students id 21', '21', 3, 'Update', '77.246.55.175', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:19:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (305, 'New Record inserted On students id 22', '22', 3, 'Insert', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:45:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (306, 'New Record inserted On  student session id 22', '22', 3, 'Insert', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:45:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (307, 'New Record inserted On users id 43', '43', 3, 'Insert', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:45:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (308, 'New Record inserted On users id 44', '44', 3, 'Insert', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:45:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (309, 'Record updated On students id 22', '22', 3, 'Update', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:45:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (310, 'New Record inserted On students id 23', '23', 3, 'Insert', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:52:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (311, 'New Record inserted On  student session id 23', '23', 3, 'Insert', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:52:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (312, 'New Record inserted On users id 45', '45', 3, 'Insert', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:52:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (313, 'New Record inserted On users id 46', '46', 3, 'Insert', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:52:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (314, 'Record updated On students id 23', '23', 3, 'Update', '77.246.52.54', 'Windows 10', 'Firefox 127.0', '2025-01-02 13:52:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (315, 'New Record inserted On students id 24', '24', 3, 'Insert', '197.221.253.169', 'Windows 10', 'Firefox 127.0', '2025-01-02 14:06:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (316, 'New Record inserted On  student session id 24', '24', 3, 'Insert', '197.221.253.169', 'Windows 10', 'Firefox 127.0', '2025-01-02 14:06:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'New Record inserted On users id 47', '47', 3, 'Insert', '197.221.253.169', 'Windows 10', 'Firefox 127.0', '2025-01-02 14:06:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'New Record inserted On users id 48', '48', 3, 'Insert', '197.221.253.169', 'Windows 10', 'Firefox 127.0', '2025-01-02 14:06:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (319, 'Record updated On students id 24', '24', 3, 'Update', '197.221.253.169', 'Windows 10', 'Firefox 127.0', '2025-01-02 14:06:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (320, 'Record updated On students id 21', '21', 3, 'Update', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:25:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (321, 'Record updated On  student session id 21', '21', 3, 'Update', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:25:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'New Record inserted On students id 25', '25', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:30:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'New Record inserted On  student session id 25', '25', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:30:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'New Record inserted On users id 49', '49', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:30:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'New Record inserted On users id 50', '50', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:30:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'Record updated On students id 25', '25', 3, 'Update', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:30:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'New Record inserted On students id 26', '26', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (328, 'New Record inserted On  student session id 26', '26', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (329, 'New Record inserted On users id 51', '51', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (330, 'New Record inserted On users id 52', '52', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (331, 'Record updated On students id 26', '26', 3, 'Update', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (332, 'New Record inserted On students id 27', '27', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:41:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (333, 'New Record inserted On  student session id 27', '27', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:41:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (334, 'New Record inserted On users id 53', '53', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:41:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (335, 'New Record inserted On users id 54', '54', 3, 'Insert', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:41:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (336, 'Record updated On students id 27', '27', 3, 'Update', '77.246.50.126', 'Windows 10', 'Firefox 127.0', '2025-01-02 19:41:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (337, 'New Record inserted On students id 28', '28', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:10:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (338, 'New Record inserted On  student session id 28', '28', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:10:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (339, 'New Record inserted On users id 55', '55', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:10:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (340, 'New Record inserted On users id 56', '56', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:10:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (341, 'Record updated On students id 28', '28', 3, 'Update', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:10:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (342, 'New Record inserted On students id 29', '29', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:21:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (343, 'New Record inserted On  student session id 29', '29', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:21:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (344, 'New Record inserted On users id 57', '57', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:21:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (345, 'New Record inserted On users id 58', '58', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:21:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (346, 'Record updated On students id 29', '29', 3, 'Update', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:21:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (347, 'New Record inserted On students id 30', '30', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:27:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (348, 'New Record inserted On  student session id 30', '30', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:27:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (349, 'New Record inserted On users id 59', '59', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:27:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (350, 'New Record inserted On users id 60', '60', 3, 'Insert', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:27:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (351, 'Record updated On students id 30', '30', 3, 'Update', '77.246.52.191', 'Windows 10', 'Firefox 127.0', '2025-01-03 09:27:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (352, 'New Record inserted On students id 31', '31', 3, 'Insert', '77.246.55.167', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:11:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (353, 'New Record inserted On  student session id 31', '31', 3, 'Insert', '77.246.55.167', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:11:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (354, 'New Record inserted On users id 61', '61', 3, 'Insert', '77.246.55.167', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:11:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (355, 'New Record inserted On users id 62', '62', 3, 'Insert', '77.246.55.167', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:11:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (356, 'Record updated On students id 31', '31', 3, 'Update', '77.246.55.167', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:11:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (357, 'New Record inserted On students id 32', '32', 3, 'Insert', '77.246.55.229', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:24:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (358, 'New Record inserted On  student session id 32', '32', 3, 'Insert', '77.246.55.229', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:24:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (359, 'New Record inserted On users id 63', '63', 3, 'Insert', '77.246.55.229', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:24:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (360, 'New Record inserted On users id 64', '64', 3, 'Insert', '77.246.55.229', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:24:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (361, 'Record updated On students id 32', '32', 3, 'Update', '77.246.55.229', 'Windows 10', 'Firefox 127.0', '2025-01-03 10:24:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (362, 'New Record inserted On students id 33', '33', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:38:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (363, 'New Record inserted On  student session id 33', '33', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:38:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (364, 'New Record inserted On users id 65', '65', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:38:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (365, 'New Record inserted On users id 66', '66', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:38:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (366, 'Record updated On students id 33', '33', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:38:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (367, 'New Record inserted On students id 34', '34', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:40:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (368, 'New Record inserted On  student session id 34', '34', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:40:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (369, 'New Record inserted On users id 67', '67', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:40:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (370, 'New Record inserted On users id 68', '68', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:40:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (371, 'Record updated On students id 34', '34', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:40:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (372, 'New Record inserted On students id 35', '35', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:43:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (373, 'New Record inserted On  student session id 35', '35', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:43:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (374, 'New Record inserted On users id 69', '69', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:43:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (375, 'New Record inserted On users id 70', '70', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:43:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (376, 'Record updated On students id 35', '35', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:43:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (377, 'New Record inserted On students id 36', '36', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:45:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (378, 'New Record inserted On  student session id 36', '36', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:45:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (379, 'New Record inserted On users id 71', '71', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:45:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (380, 'New Record inserted On users id 72', '72', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:45:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (381, 'Record updated On students id 36', '36', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:45:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (382, 'New Record inserted On students id 37', '37', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:54:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (383, 'New Record inserted On  student session id 37', '37', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:54:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (384, 'New Record inserted On users id 73', '73', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:54:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (385, 'New Record inserted On users id 74', '74', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:54:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (386, 'Record updated On students id 37', '37', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:54:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (387, 'New Record inserted On students id 38', '38', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:57:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (388, 'New Record inserted On  student session id 38', '38', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:57:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (389, 'New Record inserted On users id 75', '75', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:57:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (390, 'New Record inserted On users id 76', '76', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:57:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (391, 'Record updated On students id 38', '38', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 12:57:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (392, 'New Record inserted On students id 39', '39', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:00:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (393, 'New Record inserted On  student session id 39', '39', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:00:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (394, 'New Record inserted On users id 77', '77', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:00:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (395, 'New Record inserted On users id 78', '78', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:00:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (396, 'Record updated On students id 39', '39', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:00:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (397, 'New Record inserted On students id 40', '40', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:02:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (398, 'New Record inserted On  student session id 40', '40', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:02:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (399, 'New Record inserted On users id 79', '79', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:02:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (400, 'New Record inserted On users id 80', '80', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:02:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (401, 'Record updated On students id 40', '40', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:02:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (402, 'New Record inserted On students id 41', '41', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:08:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (403, 'New Record inserted On  student session id 41', '41', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:08:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (404, 'New Record inserted On users id 81', '81', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:08:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (405, 'New Record inserted On users id 82', '82', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:08:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (406, 'Record updated On students id 41', '41', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:08:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (407, 'New Record inserted On students id 42', '42', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:10:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (408, 'New Record inserted On  student session id 42', '42', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:10:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (409, 'New Record inserted On users id 83', '83', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:10:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (410, 'New Record inserted On users id 84', '84', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:10:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (411, 'Record updated On students id 42', '42', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:10:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (412, 'New Record inserted On students id 43', '43', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:11:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (413, 'New Record inserted On  student session id 43', '43', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:11:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (414, 'New Record inserted On users id 85', '85', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:11:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (415, 'New Record inserted On users id 86', '86', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:11:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (416, 'Record updated On students id 43', '43', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:11:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (417, 'New Record inserted On students id 44', '44', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:15:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (418, 'New Record inserted On  student session id 44', '44', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:15:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (419, 'New Record inserted On users id 87', '87', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:15:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (420, 'New Record inserted On users id 88', '88', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:15:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (421, 'Record updated On students id 44', '44', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:15:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (422, 'New Record inserted On students id 45', '45', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:16:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (423, 'New Record inserted On  student session id 45', '45', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:16:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (424, 'New Record inserted On users id 89', '89', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:16:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (425, 'New Record inserted On users id 90', '90', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:16:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (426, 'Record updated On students id 45', '45', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:16:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (427, 'New Record inserted On students id 46', '46', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:20:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (428, 'New Record inserted On  student session id 46', '46', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:20:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (429, 'New Record inserted On users id 91', '91', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:20:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (430, 'New Record inserted On users id 92', '92', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:20:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (431, 'Record updated On students id 46', '46', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:20:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (432, 'New Record inserted On students id 47', '47', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:20:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (433, 'New Record inserted On  student session id 47', '47', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:20:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (434, 'New Record inserted On users id 93', '93', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:20:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (435, 'New Record inserted On users id 94', '94', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:20:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (436, 'Record updated On students id 47', '47', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:20:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (437, 'New Record inserted On students id 48', '48', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:22:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (438, 'New Record inserted On  student session id 48', '48', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:22:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (439, 'New Record inserted On users id 95', '95', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:22:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (440, 'New Record inserted On users id 96', '96', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:22:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (441, 'Record updated On students id 48', '48', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:22:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (442, 'New Record inserted On students id 49', '49', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:24:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (443, 'New Record inserted On  student session id 49', '49', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:24:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (444, 'New Record inserted On users id 97', '97', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:24:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (445, 'New Record inserted On users id 98', '98', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:24:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (446, 'Record updated On students id 49', '49', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:24:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (447, 'New Record inserted On students id 50', '50', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:27:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (448, 'New Record inserted On  student session id 50', '50', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:27:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (449, 'New Record inserted On users id 99', '99', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:27:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (450, 'New Record inserted On users id 100', '100', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:27:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (451, 'Record updated On students id 50', '50', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:27:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (452, 'New Record inserted On students id 51', '51', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:30:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (453, 'New Record inserted On  student session id 51', '51', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:30:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (454, 'New Record inserted On users id 101', '101', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:30:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (455, 'New Record inserted On users id 102', '102', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:30:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (456, 'Record updated On students id 51', '51', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:30:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (457, 'New Record inserted On students id 52', '52', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:31:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (458, 'New Record inserted On  student session id 52', '52', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:31:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (459, 'New Record inserted On users id 103', '103', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:31:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (460, 'New Record inserted On users id 104', '104', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:31:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (461, 'Record updated On students id 52', '52', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:31:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (462, 'New Record inserted On students id 53', '53', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (463, 'New Record inserted On  student session id 53', '53', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (464, 'New Record inserted On users id 105', '105', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (465, 'New Record inserted On users id 106', '106', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (466, 'Record updated On students id 53', '53', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:33:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (467, 'New Record inserted On students id 54', '54', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:34:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (468, 'New Record inserted On  student session id 54', '54', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:34:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (469, 'New Record inserted On users id 107', '107', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:34:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (470, 'New Record inserted On users id 108', '108', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:34:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (471, 'Record updated On students id 54', '54', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:34:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (472, 'New Record inserted On students id 55', '55', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:36:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (473, 'New Record inserted On  student session id 55', '55', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:36:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (474, 'New Record inserted On users id 109', '109', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:36:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (475, 'New Record inserted On users id 110', '110', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:36:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (476, 'Record updated On students id 55', '55', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:36:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (477, 'New Record inserted On students id 56', '56', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:38:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (478, 'New Record inserted On  student session id 56', '56', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:38:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (479, 'New Record inserted On users id 111', '111', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:38:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (480, 'New Record inserted On users id 112', '112', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:38:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (481, 'Record updated On students id 56', '56', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:38:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (482, 'New Record inserted On students id 57', '57', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:40:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (483, 'New Record inserted On  student session id 57', '57', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:40:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (484, 'New Record inserted On users id 113', '113', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:40:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (485, 'New Record inserted On users id 114', '114', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:40:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (486, 'Record updated On students id 57', '57', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 127.0', '2025-01-03 13:40:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (487, 'New Record inserted On students id 58', '58', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:43:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (488, 'New Record inserted On  student session id 58', '58', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:43:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (489, 'New Record inserted On users id 115', '115', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:43:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (490, 'New Record inserted On users id 116', '116', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:43:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (491, 'Record updated On students id 58', '58', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:43:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (492, 'New Record inserted On students id 59', '59', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:46:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (493, 'New Record inserted On  student session id 59', '59', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:46:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (494, 'New Record inserted On users id 117', '117', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:46:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (495, 'New Record inserted On users id 118', '118', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:46:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (496, 'Record updated On students id 59', '59', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:46:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (497, 'New Record inserted On students id 60', '60', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:50:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (498, 'New Record inserted On  student session id 60', '60', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:50:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (499, 'New Record inserted On users id 119', '119', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:50:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (500, 'New Record inserted On users id 120', '120', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:50:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (501, 'Record updated On students id 60', '60', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:50:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (502, 'New Record inserted On students id 61', '61', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:58:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (503, 'New Record inserted On  student session id 61', '61', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:58:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (504, 'New Record inserted On users id 121', '121', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:58:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (505, 'New Record inserted On users id 122', '122', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:58:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (506, 'Record updated On students id 61', '61', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 13:58:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (507, 'New Record inserted On students id 62', '62', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:03:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (508, 'New Record inserted On  student session id 62', '62', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:03:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (509, 'New Record inserted On users id 123', '123', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:03:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (510, 'New Record inserted On users id 124', '124', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:03:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (511, 'Record updated On students id 62', '62', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:03:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (512, 'New Record inserted On students id 63', '63', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:09:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (513, 'New Record inserted On  student session id 63', '63', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:09:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (514, 'New Record inserted On users id 125', '125', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:09:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (515, 'New Record inserted On users id 126', '126', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:09:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (516, 'Record updated On students id 63', '63', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:09:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (517, 'New Record inserted On students id 64', '64', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:12:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (518, 'New Record inserted On  student session id 64', '64', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:12:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (519, 'New Record inserted On users id 127', '127', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:12:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (520, 'New Record inserted On users id 128', '128', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:12:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (521, 'Record updated On students id 64', '64', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:12:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (522, 'New Record inserted On students id 65', '65', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:15:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (523, 'New Record inserted On  student session id 65', '65', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:15:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (524, 'New Record inserted On users id 129', '129', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:15:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (525, 'New Record inserted On users id 130', '130', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:15:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (526, 'Record updated On students id 65', '65', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:15:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (527, 'New Record inserted On students id 66', '66', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:19:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (528, 'New Record inserted On  student session id 66', '66', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:19:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (529, 'New Record inserted On users id 131', '131', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:19:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (530, 'New Record inserted On users id 132', '132', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:19:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (531, 'Record updated On students id 66', '66', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:19:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (532, 'New Record inserted On students id 67', '67', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:23:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (533, 'New Record inserted On  student session id 67', '67', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:23:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (534, 'New Record inserted On users id 133', '133', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:23:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (535, 'New Record inserted On users id 134', '134', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:23:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (536, 'Record updated On students id 67', '67', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:23:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (537, 'New Record inserted On students id 68', '68', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:26:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (538, 'New Record inserted On  student session id 68', '68', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:26:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (539, 'New Record inserted On users id 135', '135', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:26:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (540, 'New Record inserted On users id 136', '136', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:26:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (541, 'Record updated On students id 68', '68', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:26:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (542, 'New Record inserted On  expenses   id 3', '3', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:32:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (543, 'New Record inserted On students id 69', '69', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:33:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (544, 'New Record inserted On  student session id 69', '69', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:33:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (545, 'New Record inserted On users id 137', '137', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:33:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (546, 'New Record inserted On users id 138', '138', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:33:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (547, 'Record updated On students id 69', '69', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:33:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (548, 'New Record inserted On  expenses   id 4', '4', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:34:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (549, 'New Record inserted On  expenses   id 5', '5', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:34:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (550, 'New Record inserted On  expense head id 17', '17', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:35:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (551, 'New Record inserted On students id 70', '70', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:35:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (552, 'New Record inserted On  student session id 70', '70', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:35:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (553, 'New Record inserted On users id 139', '139', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:35:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (554, 'New Record inserted On users id 140', '140', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:35:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (555, 'Record updated On students id 70', '70', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:35:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (556, 'New Record inserted On  expenses   id 6', '6', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:36:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (557, 'New Record inserted On  expense head id 18', '18', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:36:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (558, 'New Record inserted On  expenses   id 7', '7', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:37:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (559, 'New Record inserted On  expense head id 19', '19', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:37:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (560, 'New Record inserted On  expenses   id 8', '8', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:38:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (561, 'New Record inserted On students id 71', '71', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:39:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (562, 'New Record inserted On  student session id 71', '71', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:39:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (563, 'New Record inserted On users id 141', '141', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:39:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (564, 'New Record inserted On users id 142', '142', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:39:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (565, 'Record updated On students id 71', '71', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:39:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (566, 'New Record inserted On  expenses   id 9', '9', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:40:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (567, 'New Record inserted On  expenses   id 10', '10', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:41:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (568, 'New Record inserted On  expenses   id 11', '11', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:41:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (569, 'New Record inserted On  expenses   id 12', '12', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:43:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (570, 'New Record inserted On  expenses   id 13', '13', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:44:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (571, 'New Record inserted On  expenses   id 14', '14', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:45:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (572, 'New Record inserted On  expenses   id 15', '15', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:47:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (573, 'New Record inserted On students id 72', '72', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:47:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (574, 'New Record inserted On  student session id 72', '72', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:47:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (575, 'New Record inserted On users id 143', '143', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:47:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (576, 'New Record inserted On users id 144', '144', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:47:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (577, 'Record updated On students id 72', '72', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:47:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (578, 'New Record inserted On  expenses   id 16', '16', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:48:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (579, 'New Record inserted On  expense head id 20', '20', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:50:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (580, 'New Record inserted On students id 73', '73', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:50:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (581, 'New Record inserted On  student session id 73', '73', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:50:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (582, 'New Record inserted On users id 145', '145', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:50:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (583, 'New Record inserted On users id 146', '146', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:50:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (584, 'Record updated On students id 73', '73', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:50:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (585, 'New Record inserted On  expenses   id 17', '17', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:51:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (586, 'New Record inserted On  expenses   id 18', '18', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:52:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (587, 'New Record inserted On students id 74', '74', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:52:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (588, 'New Record inserted On  student session id 74', '74', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:52:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (589, 'New Record inserted On users id 147', '147', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:52:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (590, 'New Record inserted On users id 148', '148', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:52:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (591, 'Record updated On students id 74', '74', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:52:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (592, 'New Record inserted On  expenses   id 19', '19', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:54:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (593, 'New Record inserted On  expenses   id 20', '20', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:55:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (594, 'New Record inserted On students id 75', '75', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:56:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (595, 'New Record inserted On  student session id 75', '75', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:56:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (596, 'New Record inserted On users id 149', '149', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:56:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (597, 'New Record inserted On users id 150', '150', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:56:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (598, 'Record updated On students id 75', '75', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:56:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (599, 'New Record inserted On  expense head id 21', '21', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:56:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (600, 'New Record inserted On  expenses   id 21', '21', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:57:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (601, 'New Record inserted On students id 76', '76', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:58:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (602, 'New Record inserted On  student session id 76', '76', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:58:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (603, 'New Record inserted On users id 151', '151', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:58:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (604, 'New Record inserted On users id 152', '152', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:58:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (605, 'Record updated On students id 76', '76', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 14:58:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (606, 'New Record inserted On  expenses   id 22', '22', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 14:59:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (607, 'New Record inserted On  expenses   id 23', '23', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:00:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (608, 'New Record inserted On students id 77', '77', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:05:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (609, 'New Record inserted On  student session id 77', '77', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:05:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (610, 'New Record inserted On users id 153', '153', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:05:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (611, 'New Record inserted On users id 154', '154', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:05:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (612, 'Record updated On students id 77', '77', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:05:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (613, 'New Record inserted On students id 78', '78', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:08:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (614, 'New Record inserted On  student session id 78', '78', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:08:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (615, 'New Record inserted On users id 155', '155', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:08:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (616, 'New Record inserted On users id 156', '156', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:08:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (617, 'Record updated On students id 78', '78', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:08:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (618, 'New Record inserted On students id 79', '79', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:09:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (619, 'New Record inserted On  student session id 79', '79', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:09:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (620, 'New Record inserted On users id 157', '157', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:09:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (621, 'New Record inserted On users id 158', '158', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:09:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (622, 'Record updated On students id 79', '79', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:09:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (623, 'New Record inserted On students id 80', '80', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:11:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (624, 'New Record inserted On  student session id 80', '80', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:11:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (625, 'New Record inserted On users id 159', '159', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:11:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (626, 'New Record inserted On users id 160', '160', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:11:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (627, 'Record updated On students id 80', '80', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:11:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (628, 'New Record inserted On students id 81', '81', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (629, 'New Record inserted On  student session id 81', '81', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (630, 'New Record inserted On users id 161', '161', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (631, 'New Record inserted On users id 162', '162', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (632, 'Record updated On students id 81', '81', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (633, 'New Record inserted On  expense head id 22', '22', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:13:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (634, 'New Record inserted On  expenses   id 24', '24', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:14:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (635, 'New Record inserted On  expense head id 23', '23', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:15:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (636, 'New Record inserted On students id 82', '82', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:15:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (637, 'New Record inserted On  student session id 82', '82', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:15:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (638, 'New Record inserted On users id 163', '163', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:15:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (639, 'New Record inserted On users id 164', '164', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:15:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (640, 'Record updated On students id 82', '82', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:15:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (641, 'New Record inserted On  expenses   id 25', '25', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:18:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (642, 'New Record inserted On students id 83', '83', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:18:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (643, 'New Record inserted On  student session id 83', '83', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:18:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (644, 'New Record inserted On users id 165', '165', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:18:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (645, 'New Record inserted On users id 166', '166', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:18:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (646, 'Record updated On students id 83', '83', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:18:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (647, 'New Record inserted On  expenses   id 26', '26', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:21:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (648, 'New Record inserted On students id 84', '84', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:22:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (649, 'New Record inserted On  student session id 84', '84', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:22:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (650, 'New Record inserted On users id 167', '167', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:22:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (651, 'New Record inserted On users id 168', '168', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:22:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (652, 'Record updated On students id 84', '84', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:22:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (653, 'New Record inserted On students id 85', '85', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:24:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (654, 'New Record inserted On  student session id 85', '85', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:24:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (655, 'New Record inserted On users id 169', '169', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:24:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (656, 'New Record inserted On users id 170', '170', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:24:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (657, 'Record updated On students id 85', '85', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:24:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (658, 'New Record inserted On  expenses   id 27', '27', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:26:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (659, 'New Record inserted On  expenses   id 28', '28', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:27:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (660, 'New Record inserted On students id 86', '86', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:27:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (661, 'New Record inserted On  student session id 86', '86', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:27:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (662, 'New Record inserted On users id 171', '171', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:27:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (663, 'New Record inserted On users id 172', '172', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:27:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (664, 'Record updated On students id 86', '86', 2, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:27:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (665, 'Record updated On students id 22', '22', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:30:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (666, 'Record updated On  student session id 22', '22', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:30:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (667, 'New Record inserted On  expenses   id 29', '29', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:31:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (668, 'New Record inserted On  expenses   id 30', '30', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:32:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (669, 'New Record inserted On  Income   id 1', '1', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:32:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (670, 'New Record inserted On  expenses   id 31', '31', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:33:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (671, 'New Record inserted On  expenses   id 32', '32', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:35:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (672, 'New Record inserted On  Income   id 2', '2', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:35:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (673, 'New Record inserted On  expenses   id 33', '33', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:36:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (674, 'New Record inserted On  Income   id 3', '3', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:36:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (675, 'New Record inserted On  expenses   id 34', '34', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:36:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (676, 'New Record inserted On  Income   id 4', '4', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:37:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (677, 'New Record inserted On  expenses   id 35', '35', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:37:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (678, 'New Record inserted On  Income   id 5', '5', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:37:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (679, 'New Record inserted On  Income   id 6', '6', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:38:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (680, 'New Record inserted On  Income   id 7', '7', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:39:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (681, 'New Record inserted On  expenses   id 36', '36', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:40:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (682, 'New Record inserted On  Income   id 8', '8', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:41:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (683, 'New Record inserted On  Income   id 9', '9', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:42:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (684, 'New Record inserted On  Income   id 10', '10', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:44:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (685, 'New Record inserted On  expenses   id 37', '37', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:45:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (686, 'New Record inserted On  Income   id 11', '11', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:46:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (687, 'New Record inserted On  expenses   id 38', '38', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:46:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (688, 'New Record inserted On  Income   id 12', '12', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:46:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (689, 'New Record inserted On  Income   id 13', '13', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (690, 'New Record inserted On  expenses   id 39', '39', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:47:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (691, 'New Record inserted On  Income   id 14', '14', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:48:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (692, 'New Record inserted On  expenses   id 40', '40', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:48:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (693, 'New Record inserted On  expenses   id 41', '41', 2, 'Insert', '102.128.76.177', 'iOS', 'Safari 604.1', '2025-01-03 15:49:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (694, 'New Record inserted On  expense head id 24', '24', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 15:58:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (695, 'New Record inserted On  expenses   id 42', '42', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:01:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (696, 'New Record inserted On  expenses   id 43', '43', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:09:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (697, 'New Record inserted On  expense head id 25', '25', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:10:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (698, 'New Record inserted On  expenses   id 44', '44', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:12:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (699, 'New Record inserted On  expenses   id 45', '45', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:14:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (700, 'New Record inserted On  expenses   id 46', '46', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:15:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (701, 'New Record inserted On  expenses   id 47', '47', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:17:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (702, 'New Record inserted On  expenses   id 48', '48', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:19:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (703, 'New Record inserted On  expenses   id 49', '49', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:20:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (704, 'New Record inserted On  expenses   id 50', '50', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 16:22:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (705, 'New Record inserted On  Income   id 15', '15', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 18:29:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (706, 'New Record inserted On  Income   id 16', '16', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 18:30:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (707, 'New Record inserted On  Income   id 17', '17', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 18:31:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (708, 'New Record inserted On  Income   id 18', '18', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 18:35:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (709, 'New Record inserted On  Income   id 19', '19', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 18:36:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (710, 'New Record inserted On  Income   id 20', '20', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 18:36:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (711, 'New Record inserted On  Income   id 21', '21', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:00:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (712, 'New Record inserted On  Income   id 22', '22', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:11:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (713, 'New Record inserted On  Income   id 23', '23', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:13:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (714, 'New Record inserted On  Income   id 24', '24', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:14:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (715, 'Record updated On students id 21', '21', 3, 'Update', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:18:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (716, 'Record updated On  student session id 21', '21', 3, 'Update', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:18:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (717, 'New Record inserted On  Income   id 25', '25', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:36:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (718, 'New Record inserted On  Income   id 26', '26', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:36:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (719, 'New Record inserted On  Income   id 27', '27', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:37:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (720, 'New Record inserted On  Income   id 28', '28', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:38:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (721, 'New Record inserted On  Income   id 29', '29', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:39:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (722, 'New Record inserted On  Income   id 30', '30', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:40:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (723, 'New Record inserted On  Income   id 31', '31', 3, 'Insert', '217.15.117.122', 'Windows 10', 'Firefox 133.0', '2025-01-03 19:41:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (724, 'New Record inserted On  Income   id 32', '32', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 09:42:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (725, 'New Record inserted On  Income   id 33', '33', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 09:43:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (726, 'New Record inserted On  Income   id 34', '34', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 09:45:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (727, 'New Record inserted On  Income   id 35', '35', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 10:16:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (728, 'New Record inserted On  Income   id 36', '36', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 10:17:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (729, 'New Record inserted On  Income   id 37', '37', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 10:18:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (730, 'New Record inserted On  Income   id 38', '38', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 10:43:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (731, 'New Record inserted On  Income   id 39', '39', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 10:44:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (732, 'New Record inserted On  Income   id 40', '40', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 10:57:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (733, 'New Record inserted On  Income   id 41', '41', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 10:57:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (734, 'Record updated On students id 23', '23', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 10:59:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (735, 'Record updated On  student session id 23', '23', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 10:59:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (736, 'New Record inserted On  expenses   id 51', '51', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:35:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (737, 'Record updated On  expenses   id 51', '51', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:38:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (738, 'Record updated On  expenses   id 50', '50', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:40:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (739, 'Record updated On  expenses   id 48', '48', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:40:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (740, 'Record updated On  expenses   id 44', '44', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:41:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (741, 'Record deleted On  expenses   id 35', '35', 1, 'Delete', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:42:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (742, 'New Record inserted On  expense head id 26', '26', 1, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:43:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (743, 'Record updated On  expenses   id 13', '13', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:44:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (744, 'Record updated On  expenses   id 12', '12', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:45:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (745, 'Record updated On  expenses   id 8', '8', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:45:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (746, 'Record updated On  expenses   id 24', '24', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:47:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (747, 'New Record inserted On students id 87', '87', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (748, 'New Record inserted On  student session id 87', '87', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (749, 'New Record inserted On users id 173', '173', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (750, 'New Record inserted On users id 174', '174', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (751, 'Record updated On students id 87', '87', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (752, 'New Record inserted On  expenses   id 52', '52', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:52:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (753, 'Record updated On  expenses   id 51', '51', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:54:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (754, 'Record updated On students id 39', '39', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:57:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (755, 'Record updated On  student session id 39', '39', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 11:57:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (756, 'New Record inserted On  expense head id 27', '27', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:03:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (757, 'New Record inserted On  expense head id 28', '28', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:03:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (758, 'New Record inserted On  expenses   id 53', '53', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:06:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (759, 'Record updated On students id 24', '24', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:06:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (760, 'Record updated On  student session id 24', '24', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:06:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (761, 'New Record inserted On  expense head id 29', '29', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:08:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (762, 'New Record inserted On  expenses   id 54', '54', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:10:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (763, 'New Record inserted On  Income   id 42', '42', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:22:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (764, 'New Record inserted On  Income   id 43', '43', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:22:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (765, 'New Record inserted On  Income   id 44', '44', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:23:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (766, 'New Record inserted On  expense head id 30', '30', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:24:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (767, 'New Record inserted On  Income   id 45', '45', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:24:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (768, 'New Record inserted On  Income   id 46', '46', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:25:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (769, 'New Record inserted On  Income   id 47', '47', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:25:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (770, 'Record updated On  expenses   id 54', '54', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:26:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (771, 'Record deleted On  expense head id 28', '28', 1, 'Delete', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:26:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (772, 'New Record inserted On  Income   id 48', '48', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:26:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (773, 'New Record inserted On  Income   id 49', '49', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:27:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (774, 'Record updated On  expense head id 27', '27', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:27:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (775, 'New Record inserted On  Income   id 50', '50', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:28:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (776, 'Record updated On  expense head id 21', '21', 1, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:28:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (777, 'New Record inserted On  Income   id 51', '51', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:28:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (778, 'New Record inserted On  expenses   id 55', '55', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:30:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (779, 'New Record inserted On  expenses   id 56', '56', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:31:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (780, 'New Record inserted On  expenses   id 57', '57', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:32:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (781, 'New Record inserted On  expenses   id 58', '58', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:33:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (782, 'New Record inserted On  expenses   id 59', '59', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:34:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (783, 'New Record inserted On  expenses   id 60', '60', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:35:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (784, 'New Record inserted On  expenses   id 61', '61', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:36:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (785, 'New Record inserted On  expense head id 31', '31', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:37:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (786, 'Record updated On students id 47', '47', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:38:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (787, 'Record updated On  student session id 47', '47', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:38:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (788, 'New Record inserted On  expenses   id 62', '62', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:38:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (789, 'New Record inserted On  expenses   id 63', '63', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:40:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (790, 'New Record inserted On  expenses   id 64', '64', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:42:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (791, 'New Record inserted On  expenses   id 65', '65', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:43:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (792, 'New Record inserted On  expenses   id 66', '66', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:45:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (793, 'New Record inserted On  expenses   id 67', '67', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:46:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (794, 'New Record inserted On  expenses   id 68', '68', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:49:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (795, 'Record updated On students id 54', '54', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:51:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (796, 'Record updated On  student session id 54', '54', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:51:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (797, 'New Record inserted On students id 88', '88', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:58:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (798, 'New Record inserted On  student session id 88', '88', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:58:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (799, 'New Record inserted On users id 175', '175', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:58:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (800, 'New Record inserted On users id 176', '176', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:58:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (801, 'Record updated On students id 88', '88', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 12:58:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (802, 'Record updated On students id 77', '77', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:05:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (803, 'Record updated On  student session id 77', '77', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:05:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (804, 'Record updated On students id 78', '78', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:06:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (805, 'Record updated On  student session id 78', '78', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:06:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (806, 'Record updated On students id 79', '79', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:08:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (807, 'Record updated On  student session id 79', '79', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:08:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (808, 'Record updated On students id 80', '80', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:13:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (809, 'Record updated On  student session id 80', '80', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:13:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (810, 'Record updated On students id 81', '81', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:14:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (811, 'Record updated On  student session id 81', '81', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:14:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (812, 'Record updated On students id 82', '82', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:16:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (813, 'Record updated On  student session id 82', '82', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:16:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (814, 'Record updated On students id 83', '83', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:19:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (815, 'Record updated On  student session id 83', '83', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:19:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (816, 'Record updated On students id 84', '84', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:19:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (817, 'Record updated On  student session id 84', '84', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:19:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (818, 'Record updated On students id 85', '85', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:21:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (819, 'Record updated On  student session id 85', '85', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:21:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (820, 'Record updated On students id 86', '86', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:22:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (821, 'Record updated On  student session id 86', '86', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:22:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (822, 'New Record inserted On students id 89', '89', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:28:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (823, 'New Record inserted On  student session id 89', '89', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:28:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (824, 'New Record inserted On users id 177', '177', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:28:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (825, 'New Record inserted On users id 178', '178', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:28:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (826, 'Record updated On students id 89', '89', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:28:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (827, 'New Record inserted On students id 90', '90', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:35:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (828, 'New Record inserted On  student session id 90', '90', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:35:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (829, 'New Record inserted On users id 179', '179', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:35:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (830, 'New Record inserted On users id 180', '180', 3, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:35:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (831, 'Record updated On students id 90', '90', 3, 'Update', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 13:35:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (832, 'New Record inserted On  expenses   id 69', '69', 2, 'Insert', '102.128.76.177', 'Windows 10', 'Firefox 133.0', '2025-01-04 15:45:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (833, 'New Record inserted On  expenses   id 70', '70', 2, 'Insert', '77.246.50.116', 'Windows 10', 'Firefox 133.0', '2025-01-04 16:10:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (834, 'Record deleted On  expenses   id 69', '69', 1, 'Delete', '77.246.50.116', 'Windows 10', 'Firefox 133.0', '2025-01-04 16:16:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (835, 'Record deleted On  expenses   id 68', '68', 1, 'Delete', '77.246.50.116', 'Windows 10', 'Firefox 133.0', '2025-01-04 16:16:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (836, 'Record deleted On  expenses   id 66', '66', 1, 'Delete', '77.246.50.116', 'Windows 10', 'Firefox 133.0', '2025-01-04 16:16:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (837, 'New Record inserted On  expenses   id 71', '71', 2, 'Insert', '77.246.50.116', 'Windows 10', 'Firefox 133.0', '2025-01-04 16:19:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (838, 'New Record inserted On  expenses   id 72', '72', 2, 'Insert', '77.246.50.116', 'Windows 10', 'Firefox 133.0', '2025-01-04 16:20:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (839, 'New Record inserted On  expenses   id 73', '73', 2, 'Insert', '77.246.50.116', 'Windows 10', 'Firefox 133.0', '2025-01-04 16:25:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (840, 'New Record inserted On  expenses   id 74', '74', 2, 'Insert', '77.246.50.116', 'Windows 10', 'Firefox 133.0', '2025-01-04 16:30:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (841, 'New Record inserted On  expenses   id 75', '75', 2, 'Insert', '77.246.50.116', 'iOS', 'Safari 604.1', '2025-01-04 16:37:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (842, 'New Record inserted On  expenses   id 76', '76', 2, 'Insert', '77.246.50.116', 'iOS', 'Safari 604.1', '2025-01-04 16:46:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (843, 'New Record inserted On  expenses   id 77', '77', 2, 'Insert', '77.246.50.116', 'iOS', 'Safari 604.1', '2025-01-04 17:31:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (844, 'New Record inserted On students id 91', '91', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:02:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (845, 'New Record inserted On  student session id 91', '91', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:02:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (846, 'New Record inserted On users id 181', '181', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:02:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (847, 'New Record inserted On users id 182', '182', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:02:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (848, 'Record updated On students id 91', '91', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:02:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (849, 'New Record inserted On students id 92', '92', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:04:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (850, 'New Record inserted On  student session id 92', '92', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:04:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (851, 'New Record inserted On users id 183', '183', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:04:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (852, 'New Record inserted On users id 184', '184', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:04:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (853, 'Record updated On students id 92', '92', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:04:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (854, 'New Record inserted On students id 93', '93', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:08:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (855, 'New Record inserted On  student session id 93', '93', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:08:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (856, 'New Record inserted On users id 185', '185', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:08:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (857, 'New Record inserted On users id 186', '186', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:08:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (858, 'Record updated On students id 93', '93', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:08:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (859, 'New Record inserted On students id 94', '94', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:11:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (860, 'New Record inserted On  student session id 94', '94', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:11:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (861, 'New Record inserted On users id 187', '187', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:11:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (862, 'New Record inserted On users id 188', '188', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:11:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (863, 'Record updated On students id 94', '94', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:11:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (864, 'New Record inserted On students id 95', '95', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:14:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (865, 'New Record inserted On  student session id 95', '95', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:14:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (866, 'New Record inserted On users id 189', '189', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:14:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (867, 'New Record inserted On users id 190', '190', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:14:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (868, 'Record updated On students id 95', '95', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:14:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (869, 'New Record inserted On students id 96', '96', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:17:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (870, 'New Record inserted On  student session id 96', '96', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:17:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (871, 'New Record inserted On users id 191', '191', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:17:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (872, 'New Record inserted On users id 192', '192', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:17:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (873, 'Record updated On students id 96', '96', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:17:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (874, 'New Record inserted On students id 97', '97', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:19:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (875, 'New Record inserted On  student session id 97', '97', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:19:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (876, 'New Record inserted On users id 193', '193', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:19:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (877, 'New Record inserted On users id 194', '194', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:19:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (878, 'Record updated On students id 97', '97', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:19:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (879, 'New Record inserted On students id 98', '98', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:21:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (880, 'New Record inserted On  student session id 98', '98', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:21:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (881, 'New Record inserted On users id 195', '195', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:21:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (882, 'New Record inserted On users id 196', '196', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:21:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (883, 'Record updated On students id 98', '98', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:21:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (884, 'New Record inserted On students id 99', '99', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:23:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (885, 'New Record inserted On  student session id 99', '99', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:23:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (886, 'New Record inserted On users id 197', '197', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:23:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (887, 'New Record inserted On users id 198', '198', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:23:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (888, 'Record updated On students id 99', '99', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:23:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (889, 'New Record inserted On students id 100', '100', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:26:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (890, 'New Record inserted On  student session id 100', '100', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:26:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (891, 'New Record inserted On users id 199', '199', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:26:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (892, 'New Record inserted On users id 200', '200', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:26:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (893, 'Record updated On students id 100', '100', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:26:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (894, 'New Record inserted On students id 101', '101', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:29:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (895, 'New Record inserted On  student session id 101', '101', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:29:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (896, 'New Record inserted On users id 201', '201', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:29:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (897, 'New Record inserted On users id 202', '202', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:29:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (898, 'Record updated On students id 101', '101', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:29:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (899, 'New Record inserted On students id 102', '102', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:33:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (900, 'New Record inserted On  student session id 102', '102', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:33:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (901, 'New Record inserted On users id 203', '203', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:33:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (902, 'New Record inserted On users id 204', '204', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:33:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (903, 'Record updated On students id 102', '102', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 10:33:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (904, 'New Record inserted On  expenses   id 78', '78', 2, 'Insert', '102.128.79.223', 'iOS', 'Safari 604.1', '2025-01-05 14:16:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (905, 'New Record inserted On  expenses   id 79', '79', 2, 'Insert', '102.128.79.223', 'iOS', 'Safari 604.1', '2025-01-05 14:18:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (906, 'New Record inserted On students id 103', '103', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (907, 'New Record inserted On  student session id 103', '103', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (908, 'New Record inserted On users id 205', '205', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (909, 'New Record inserted On users id 206', '206', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (910, 'Record updated On students id 103', '103', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (911, 'New Record inserted On  expenses   id 80', '80', 2, 'Insert', '77.246.55.225', 'iOS', 'Safari 604.1', '2025-01-05 14:20:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (912, 'New Record inserted On  expense head id 32', '32', 2, 'Insert', '77.246.55.225', 'iOS', 'Safari 604.1', '2025-01-05 14:23:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (913, 'New Record inserted On  expenses   id 81', '81', 2, 'Insert', '77.246.55.225', 'iOS', 'Safari 604.1', '2025-01-05 14:25:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (914, 'New Record inserted On  expenses   id 82', '82', 2, 'Insert', '77.246.55.225', 'iOS', 'Safari 604.1', '2025-01-05 14:25:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (915, 'New Record inserted On  expenses   id 83', '83', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:28:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (916, 'New Record inserted On  expenses   id 84', '84', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:30:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (917, 'New Record inserted On  expenses   id 85', '85', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:32:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (918, 'New Record inserted On  expenses   id 86', '86', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:34:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (919, 'New Record inserted On  expenses   id 87', '87', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:34:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (920, 'New Record inserted On students id 104', '104', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:38:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (921, 'New Record inserted On  student session id 104', '104', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:38:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (922, 'New Record inserted On users id 207', '207', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:38:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (923, 'New Record inserted On users id 208', '208', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:38:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (924, 'Record updated On students id 104', '104', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:38:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (925, 'New Record inserted On students id 105', '105', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:40:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (926, 'New Record inserted On  student session id 105', '105', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:40:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (927, 'New Record inserted On users id 209', '209', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:40:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (928, 'New Record inserted On users id 210', '210', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:40:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (929, 'Record updated On students id 105', '105', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:40:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (930, 'New Record inserted On students id 106', '106', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:41:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (931, 'New Record inserted On  student session id 106', '106', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:41:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (932, 'New Record inserted On users id 211', '211', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:41:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (933, 'New Record inserted On users id 212', '212', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:41:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (934, 'Record updated On students id 106', '106', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:41:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (935, 'New Record inserted On students id 107', '107', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:42:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (936, 'New Record inserted On  student session id 107', '107', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:42:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (937, 'New Record inserted On users id 213', '213', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:42:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (938, 'New Record inserted On users id 214', '214', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:42:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (939, 'Record updated On students id 107', '107', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:42:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (940, 'New Record inserted On students id 108', '108', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:44:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (941, 'New Record inserted On  student session id 108', '108', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:44:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (942, 'New Record inserted On users id 215', '215', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:44:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (943, 'New Record inserted On users id 216', '216', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:44:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (944, 'Record updated On students id 108', '108', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:44:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (945, 'New Record inserted On students id 109', '109', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:46:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (946, 'New Record inserted On  student session id 109', '109', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:46:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (947, 'New Record inserted On users id 217', '217', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:46:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (948, 'New Record inserted On users id 218', '218', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:46:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (949, 'Record updated On students id 109', '109', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:46:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (950, 'New Record inserted On students id 110', '110', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (951, 'New Record inserted On  student session id 110', '110', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (952, 'New Record inserted On users id 219', '219', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (953, 'New Record inserted On users id 220', '220', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (954, 'Record updated On students id 110', '110', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (955, 'New Record inserted On students id 111', '111', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:54:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (956, 'New Record inserted On  student session id 111', '111', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:54:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (957, 'New Record inserted On users id 221', '221', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:54:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (958, 'New Record inserted On users id 222', '222', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:54:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (959, 'Record updated On students id 111', '111', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:54:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (960, 'Record updated On students id 111', '111', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:58:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (961, 'Record updated On  student session id 111', '111', 2, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 14:58:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (962, 'New Record inserted On  expense head id 33', '33', 1, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:23:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (963, 'Record deleted On  expense head id 33', '33', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:26:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (964, 'Record updated On  expense head id 30', '30', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:27:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (965, 'Record updated On  expenses   id 54', '54', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:29:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (966, 'Record updated On  expenses   id 55', '55', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:29:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (967, 'Record updated On  expenses   id 6', '6', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:30:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (968, 'Record updated On  expenses   id 53', '53', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:31:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (969, 'Record deleted On  expense head id 17', '17', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:34:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (970, 'Record deleted On  expense head id 27', '27', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:34:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (971, 'Record deleted On  expense head id 29', '29', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:34:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (972, 'Record deleted On  expense head id 21', '21', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:35:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (973, 'Record deleted On  expense head id 15', '15', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:38:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (974, 'Record updated On  expense head id 25', '25', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:39:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (975, 'Record updated On  expense head id 18', '18', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:40:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (976, 'Record deleted On  expense head id 14', '14', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:40:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (977, 'Record deleted On  expense head id 8', '8', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:41:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (978, 'Record deleted On  expense head id 9', '9', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:41:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (979, 'Record updated On  expense head id 22', '22', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:42:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (980, 'New Record inserted On  expense head id 34', '34', 1, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:42:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (981, 'New Record inserted On  expense head id 35', '35', 1, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:42:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (982, 'Record updated On  expense head id 1', '1', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:43:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (983, 'Record deleted On  expense head id 32', '32', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:44:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (984, 'Record deleted On  expense head id 13', '13', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:44:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (985, 'Record deleted On  expense head id 23', '23', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:45:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (986, 'Record deleted On  expense head id 22', '22', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:45:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (987, 'Record updated On  expenses   id 62', '62', 1, 'Update', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:47:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (988, 'Record deleted On  expense head id 31', '31', 1, 'Delete', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:48:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (989, 'New Record inserted On  expenses   id 88', '88', 2, 'Insert', '102.128.79.223', 'Windows 10', 'Firefox 133.0', '2025-01-05 17:58:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (990, 'New Record inserted On  expenses   id 89', '89', 2, 'Insert', '77.246.52.180', 'iOS', 'Safari 604.1', '2025-01-06 15:28:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (991, 'New Record inserted On  expenses   id 90', '90', 2, 'Insert', '77.246.52.180', 'iOS', 'Safari 604.1', '2025-01-06 15:30:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (992, 'New Record inserted On  expenses   id 91', '91', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-06 18:15:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (993, 'New Record inserted On  expenses   id 92', '92', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-06 18:16:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (994, 'New Record inserted On  expenses   id 93', '93', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-06 18:18:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (995, 'New Record inserted On  expenses   id 94', '94', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-06 18:20:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (996, 'New Record inserted On  expenses   id 95', '95', 2, 'Insert', '77.246.55.224', 'iOS', 'Safari 604.1', '2025-01-07 10:06:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (997, 'New Record inserted On  expenses   id 96', '96', 2, 'Insert', '197.221.253.140', 'iOS', 'Safari 604.1', '2025-01-07 13:22:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (998, 'New Record inserted On  expenses   id 97', '97', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-07 21:02:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (999, 'New Record inserted On  expenses   id 98', '98', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-07 21:05:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1000, 'New Record inserted On  expenses   id 99', '99', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-07 21:06:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1001, 'New Record inserted On  expenses   id 100', '100', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-07 21:17:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1002, 'New Record inserted On  expenses   id 101', '101', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-07 21:18:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1003, 'New Record inserted On  expenses   id 102', '102', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-07 21:24:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1004, 'New Record inserted On  expenses   id 103', '103', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-07 21:25:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1005, 'Record updated On  expenses   id 101', '101', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-07 21:26:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1006, 'Record updated On  expenses   id 98', '98', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-07 21:27:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1007, 'New Record inserted On  expenses   id 104', '104', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:27:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1008, 'New Record inserted On  Income   id 52', '52', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:33:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1009, 'New Record inserted On  Income   id 53', '53', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:33:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1010, 'New Record inserted On  Income   id 54', '54', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:34:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1011, 'New Record inserted On  Income   id 55', '55', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:34:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1012, 'New Record inserted On students id 112', '112', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1013, 'New Record inserted On  student session id 112', '112', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1014, 'New Record inserted On users id 223', '223', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1015, 'New Record inserted On users id 224', '224', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1016, 'Record updated On students id 112', '112', 3, 'Update', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1017, 'New Record inserted On students id 113', '113', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:40:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1018, 'New Record inserted On  student session id 113', '113', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:40:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1019, 'New Record inserted On users id 225', '225', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:40:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1020, 'New Record inserted On users id 226', '226', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:40:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1021, 'Record updated On students id 113', '113', 3, 'Update', '102.128.76.183', 'Windows 10', 'Firefox 133.0', '2025-01-08 14:40:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1022, 'New Record inserted On  expenses   id 105', '105', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 134.0', '2025-01-08 17:28:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1023, 'New Record inserted On  expenses   id 106', '106', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 18:18:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1024, 'New Record inserted On  expenses   id 107', '107', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 18:19:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1025, 'New Record inserted On  expenses   id 108', '108', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 18:19:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1026, 'New Record inserted On  expenses   id 109', '109', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 18:20:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1027, 'Record updated On  Income   id 1', '1', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:03:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1028, 'Record updated On  Income   id 51', '51', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:04:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1029, 'Record updated On  Income   id 50', '50', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:04:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1030, 'Record updated On  Income   id 49', '49', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:04:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1031, 'Record updated On  Income   id 48', '48', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:05:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1032, 'Record updated On  Income   id 47', '47', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:05:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1033, 'Record updated On  Income   id 46', '46', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:06:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1034, 'Record updated On  Income   id 45', '45', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:06:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1035, 'Record updated On  Income   id 44', '44', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:07:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1036, 'Record updated On  Income   id 43', '43', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:07:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1037, 'Record updated On  Income   id 42', '42', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:08:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1038, 'Record updated On  Income   id 41', '41', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:08:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1039, 'Record updated On  Income   id 40', '40', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:09:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1040, 'Record updated On  Income   id 39', '39', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:09:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1041, 'Record updated On  Income   id 38', '38', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:10:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1042, 'Record updated On  Income   id 37', '37', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:10:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1043, 'Record updated On  Income   id 36', '36', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:11:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1044, 'Record updated On  Income   id 35', '35', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:12:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1045, 'Record updated On  Income   id 34', '34', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:12:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1046, 'Record updated On  Income   id 33', '33', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:13:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1047, 'Record updated On  Income   id 32', '32', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:13:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1048, 'Record updated On  Income   id 31', '31', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:14:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1049, 'Record updated On  Income   id 30', '30', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:15:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1050, 'Record updated On  Income   id 29', '29', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:15:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1051, 'Record updated On  Income   id 28', '28', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:16:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1052, 'Record updated On  Income   id 27', '27', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:17:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1053, 'Record updated On  Income   id 26', '26', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:18:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1054, 'Record updated On  Income   id 25', '25', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:19:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1055, 'Record updated On  Income   id 24', '24', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:19:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1056, 'Record updated On  Income   id 23', '23', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:20:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1057, 'Record updated On  Income   id 22', '22', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:21:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1058, 'Record updated On  Income   id 21', '21', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:21:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1059, 'Record updated On  Income   id 20', '20', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:22:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1060, 'Record updated On  Income   id 19', '19', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:23:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1061, 'Record updated On  Income   id 17', '17', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:23:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1062, 'Record updated On  Income   id 18', '18', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:24:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1063, 'Record updated On  Income   id 16', '16', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:25:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1064, 'Record updated On  Income   id 15', '15', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:26:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1065, 'Record updated On  Income   id 14', '14', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:27:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1066, 'Record updated On  Income   id 13', '13', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:28:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1067, 'Record updated On  Income   id 12', '12', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:28:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1068, 'Record updated On  Income   id 11', '11', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:29:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1069, 'Record updated On  Income   id 10', '10', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:30:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1070, 'Record updated On  Income   id 9', '9', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:30:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1071, 'Record updated On  Income   id 8', '8', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:31:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1072, 'Record updated On  Income   id 7', '7', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:31:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1073, 'Record updated On  Income   id 1', '1', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:32:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1074, 'Record updated On  Income   id 2', '2', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:32:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1075, 'Record updated On  Income   id 3', '3', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:33:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1076, 'Record updated On  Income   id 4', '4', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:33:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1077, 'Record updated On  Income   id 5', '5', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:34:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1078, 'Record updated On  Income   id 6', '6', 1, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 133.0', '2025-01-08 22:34:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1079, 'New Record inserted On  expenses   id 110', '110', 3, 'Insert', '102.128.76.183', 'Windows 10', 'Firefox 134.0', '2025-01-09 08:58:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1080, 'Record updated On students id 49', '49', 3, 'Update', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:12:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1081, 'Record updated On  student session id 49', '49', 3, 'Update', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:12:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1082, 'Record updated On students id 43', '43', 3, 'Update', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:17:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1083, 'Record updated On  student session id 43', '43', 3, 'Update', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:17:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1084, 'New Record inserted On  fee type id 18', '18', 1, 'Insert', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:53:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1085, 'New Record inserted On  fee group id 7', '7', 1, 'Insert', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:54:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1086, 'New Record inserted On  fee group id 8', '8', 1, 'Insert', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:55:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1087, 'Record updated On  fee group id 7', '7', 1, 'Update', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:55:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1088, 'Record updated On  fee group id 8', '8', 1, 'Update', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:56:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1089, 'Record updated On  fee type id 18', '18', 1, 'Update', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:56:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1090, 'New Record inserted On  fee type id 19', '19', 1, 'Insert', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 17:57:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1091, 'New Record inserted On  fee groups feetype id 17', '17', 1, 'Insert', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 18:00:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1092, 'New Record inserted On  fee groups feetype id 18', '18', 1, 'Insert', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 18:00:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1093, 'Record updated On  fee group id 8', '8', 1, 'Update', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 18:00:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1094, 'Record updated On students id 30', '30', 1, 'Update', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 18:03:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1095, 'Record updated On  student session id 30', '30', 1, 'Update', '197.221.255.168', 'Windows 10', 'Firefox 134.0', '2025-01-09 18:03:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1096, 'New Record inserted On  Income   id 56', '56', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 18:58:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1097, 'New Record inserted On  Income   id 57', '57', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:00:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1098, 'New Record inserted On  Income   id 58', '58', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:03:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1099, 'New Record inserted On  Income   id 59', '59', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:07:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1100, 'New Record inserted On  Income   id 60', '60', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:10:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1101, 'New Record inserted On  Income   id 61', '61', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:12:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1102, 'New Record inserted On  Income   id 62', '62', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:14:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1103, 'New Record inserted On  Income   id 63', '63', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:15:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1104, 'New Record inserted On  Income   id 64', '64', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:17:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1105, 'New Record inserted On  Income   id 65', '65', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:24:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1106, 'New Record inserted On  Income   id 66', '66', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:26:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1107, 'New Record inserted On  Income   id 67', '67', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:44:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1108, 'New Record inserted On  Income   id 68', '68', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:49:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1109, 'New Record inserted On  Income   id 69', '69', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:51:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1110, 'New Record inserted On  Income   id 70', '70', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:53:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1111, 'New Record inserted On  Income   id 71', '71', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:54:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1112, 'New Record inserted On  Income   id 72', '72', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:55:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1113, 'New Record inserted On  Income   id 73', '73', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 19:56:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1114, 'New Record inserted On  expenses   id 111', '111', 2, 'Insert', '102.128.76.213', 'Windows 10', 'Firefox 133.0', '2025-01-09 19:56:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1115, 'New Record inserted On  Income   id 74', '74', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 20:01:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1116, 'New Record inserted On  expenses   id 112', '112', 2, 'Insert', '102.128.76.213', 'Windows 10', 'Firefox 133.0', '2025-01-09 20:02:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1117, 'New Record inserted On  expenses   id 113', '113', 2, 'Insert', '102.128.76.213', 'Windows 10', 'Firefox 133.0', '2025-01-09 20:05:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1118, 'Record updated On  expenses   id 108', '108', 1, 'Update', '102.128.76.213', 'Windows 10', 'Firefox 133.0', '2025-01-09 20:08:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1119, 'New Record inserted On  expenses   id 114', '114', 1, 'Insert', '102.128.76.213', 'Windows 10', 'Firefox 133.0', '2025-01-09 20:12:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1120, 'New Record inserted On  expenses   id 115', '115', 1, 'Insert', '102.128.76.213', 'Windows 10', 'Firefox 133.0', '2025-01-09 20:15:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1121, 'New Record inserted On  expenses   id 116', '116', 1, 'Insert', '102.128.76.213', 'Windows 10', 'Firefox 133.0', '2025-01-09 20:17:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1122, 'New Record inserted On  Income   id 75', '75', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 20:18:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1123, 'New Record inserted On  Income   id 76', '76', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 20:20:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1124, 'New Record inserted On  Income   id 77', '77', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 20:22:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1125, 'New Record inserted On  Income   id 78', '78', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 20:42:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1126, 'New Record inserted On  Income   id 79', '79', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 20:44:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1127, 'New Record inserted On  Income   id 80', '80', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 20:57:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1128, 'New Record inserted On  Income   id 81', '81', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 21:11:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1129, 'New Record inserted On  Income   id 82', '82', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 21:12:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1130, 'New Record inserted On  Income   id 83', '83', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 21:14:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1131, 'New Record inserted On  Income   id 84', '84', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 21:15:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1132, 'New Record inserted On  Income   id 85', '85', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 21:17:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1133, 'New Record inserted On  Income   id 86', '86', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 21:18:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1134, 'New Record inserted On  Income   id 87', '87', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 21:19:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1135, 'New Record inserted On  Income   id 88', '88', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 21:21:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1136, 'New Record inserted On  Income   id 89', '89', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-09 21:21:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1137, 'New Record inserted On  expenses   id 117', '117', 2, 'Insert', '102.128.76.213', 'iOS', 'Safari 604.1', '2025-01-09 22:16:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1138, 'Record updated On students id 31', '31', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 06:55:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1139, 'Record updated On  student session id 31', '31', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 06:55:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1140, 'Record updated On students id 23', '23', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 06:56:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1141, 'Record updated On  student session id 23', '23', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 06:56:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1142, 'Record updated On students id 47', '47', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 06:58:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1143, 'Record updated On  student session id 47', '47', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 06:58:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1144, 'Record updated On students id 24', '24', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 06:58:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1145, 'Record updated On  student session id 24', '24', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 06:58:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1146, 'Record updated On students id 21', '21', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:00:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1147, 'Record updated On  student session id 21', '21', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:00:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1148, 'Record updated On students id 25', '25', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:01:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1149, 'Record updated On  student session id 25', '25', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:01:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1150, 'Record updated On students id 26', '26', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:02:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1151, 'Record updated On  student session id 26', '26', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:02:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1152, 'Record updated On students id 27', '27', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:03:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1153, 'Record updated On  student session id 27', '27', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:03:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1154, 'Record updated On students id 28', '28', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:05:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1155, 'Record updated On  student session id 28', '28', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:05:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1156, 'Record updated On students id 29', '29', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:05:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1157, 'Record updated On  student session id 29', '29', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:05:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1158, 'Record updated On students id 22', '22', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:06:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1159, 'Record updated On  student session id 22', '22', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:06:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1160, 'Record updated On students id 32', '32', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:07:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1161, 'Record updated On  student session id 32', '32', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:07:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1162, 'Record updated On students id 33', '33', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:08:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1163, 'Record updated On  student session id 33', '33', 1, 'Update', '102.128.76.133', 'Windows 10', 'Firefox 134.0', '2025-01-10 07:08:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1164, 'New Record inserted On  expenses   id 118', '118', 2, 'Insert', '77.246.52.173', 'Windows 10', 'Firefox 134.0', '2025-01-10 21:31:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1165, 'New Record inserted On  expenses   id 119', '119', 2, 'Insert', '77.246.52.173', 'Windows 10', 'Firefox 134.0', '2025-01-10 21:36:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1166, 'New Record inserted On  expenses   id 120', '120', 2, 'Insert', '77.246.52.173', 'Windows 10', 'Firefox 134.0', '2025-01-10 21:45:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1167, 'New Record inserted On  expense head id 36', '36', 2, 'Insert', '77.246.52.173', 'Windows 10', 'Firefox 134.0', '2025-01-10 21:46:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1168, 'New Record inserted On  expenses   id 121', '121', 2, 'Insert', '77.246.52.173', 'Windows 10', 'Firefox 134.0', '2025-01-10 21:48:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1169, 'New Record inserted On  expenses   id 122', '122', 2, 'Insert', '77.246.52.173', 'Windows 10', 'Firefox 134.0', '2025-01-10 21:49:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1170, 'New Record inserted On  expenses   id 123', '123', 2, 'Insert', '77.246.52.173', 'Windows 10', 'Firefox 134.0', '2025-01-10 21:50:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1171, 'Record deleted On  expenses   id 118', '118', 1, 'Delete', '102.128.76.213', 'Windows 10', 'Firefox 134.0', '2025-01-10 21:58:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1172, 'Record updated On  expenses   id 117', '117', 1, 'Update', '102.128.76.213', 'Windows 10', 'Firefox 134.0', '2025-01-10 21:59:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1173, 'New Record inserted On  Income   id 90', '90', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:25:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1174, 'New Record inserted On  Income   id 91', '91', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:26:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1175, 'New Record inserted On  Income   id 92', '92', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:27:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1176, 'New Record inserted On  Income   id 93', '93', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:28:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1177, 'New Record inserted On  Income   id 94', '94', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:31:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1178, 'New Record inserted On students id 114', '114', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:40:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1179, 'New Record inserted On  student session id 114', '114', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:40:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1180, 'New Record inserted On users id 227', '227', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:40:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1181, 'New Record inserted On users id 228', '228', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:40:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1182, 'Record updated On students id 114', '114', 3, 'Update', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 12:40:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1183, 'New Record inserted On  Income   id 95', '95', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 13:22:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1184, 'New Record inserted On  Income   id 96', '96', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 13:23:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1185, 'New Record inserted On  expenses   id 124', '124', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 14:43:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1186, 'New Record inserted On  expenses   id 125', '125', 3, 'Insert', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 14:49:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1187, 'Record updated On students id 34', '34', 3, 'Update', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 14:58:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1188, 'Record updated On  student session id 34', '34', 3, 'Update', '102.128.76.240', 'Windows 10', 'Firefox 134.0', '2025-01-11 14:58:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1189, 'Record deleted On  expenses   id 119', '119', 1, 'Delete', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:28:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1190, 'New Record inserted On  expenses   id 126', '126', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:29:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1191, 'New Record inserted On  expenses   id 127', '127', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:31:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1192, 'New Record inserted On  expenses   id 128', '128', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:32:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1193, 'New Record inserted On  expenses   id 129', '129', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:34:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1194, 'New Record inserted On  expenses   id 130', '130', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:36:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1195, 'Record updated On  expenses   id 129', '129', 1, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:43:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1196, 'Record deleted On student fees deposite id 94', '94', 1, 'Delete', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:51:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1197, 'Record deleted On student fees deposite id 95', '95', 1, 'Delete', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:52:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1198, 'Record deleted On student fees deposite id 96', '96', 1, 'Delete', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 07:53:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1199, 'Record updated On roles id 3', '3', 1, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 08:16:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1200, 'Record deleted On roles id 9', '9', 1, 'Delete', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 08:25:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1201, 'Record updated On roles id 3', '3', 1, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 08:26:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1202, 'Record updated On staff id 2', '2', 1, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 08:27:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1203, 'Record updated On staff id 2', '2', 1, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 08:27:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1204, 'New Record inserted On  expenses   id 131', '131', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 20:20:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1205, 'New Record inserted On  expenses   id 132', '132', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 20:21:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1206, 'New Record inserted On  expenses   id 133', '133', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 20:22:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1207, 'Record updated On  expenses   id 132', '132', 2, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 20:24:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1208, 'New Record inserted On  expenses   id 134', '134', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 134.0', '2025-01-12 20:38:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1209, 'New Record inserted On students id 115', '115', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 09:53:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1210, 'New Record inserted On  student session id 115', '115', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 09:53:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1211, 'New Record inserted On users id 229', '229', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 09:53:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1212, 'New Record inserted On users id 230', '230', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 09:53:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1213, 'Record updated On students id 115', '115', 3, 'Update', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 09:53:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1214, 'New Record inserted On item supplier id 1', '1', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:40:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1215, 'New Record inserted On item category id 1', '1', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:47:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1216, 'New Record inserted On item category id 2', '2', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:48:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1217, 'New Record inserted On item category id 3', '3', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:49:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1218, 'New Record inserted On item category id 4', '4', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:50:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1219, 'Record updated On  item category id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:50:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1220, 'Record updated On  item category id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:50:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1221, 'Record deleted On item category id 1', '1', 1, 'Delete', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:50:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1222, 'Record updated On  item category id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:57:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1223, 'Record updated On  item category id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:57:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1224, 'Record updated On  item category id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:57:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1225, 'Record updated On  item category id 4', '4', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 10:59:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1226, 'New Record inserted On item category id 5', '5', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:02:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1227, 'New Record inserted On item category id 6', '6', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:03:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1228, 'New Record inserted On item category id 7', '7', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:04:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1229, 'New Record inserted On item category id 8', '8', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:05:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1230, 'Record updated On  item category id 8', '8', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:05:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1231, 'Record updated On  item category id 7', '7', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:05:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1232, 'Record updated On  item category id 5', '5', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:05:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1233, 'New Record inserted On item category id 9', '9', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:07:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1234, 'Record updated On  item category id 6', '6', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:07:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1235, 'Record updated On  item category id 8', '8', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:07:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1236, 'Record updated On  item category id 6', '6', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:08:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1237, 'New Record inserted On item id 1', '1', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:10:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1238, 'New Record inserted On item id 2', '2', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:12:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1239, 'Record updated On  item id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:12:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1240, 'Record updated On  item id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:12:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1241, 'New Record inserted On item id 3', '3', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:13:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1242, 'Record updated On  item id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:13:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1243, 'Record updated On  item id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:13:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1244, 'Record updated On  item category id 6', '6', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:15:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1245, 'New Record inserted On item id 4', '4', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:15:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1246, 'New Record inserted On item id 5', '5', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:16:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1247, 'Record updated On  item id 5', '5', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:16:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1248, 'Record updated On  item id 5', '5', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 11:16:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1249, 'New Record inserted On item id 6', '6', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 12:55:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1250, 'New Record inserted On item id 7', '7', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 12:56:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1251, 'New Record inserted On item id 8', '8', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 12:57:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1252, 'New Record inserted On item id 9', '9', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 12:59:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1253, 'New Record inserted On item id 10', '10', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 13:00:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1254, 'New Record inserted On item id 11', '11', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 13:00:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1255, 'New Record inserted On item id 12', '12', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 13:04:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1256, 'New Record inserted On item id 13', '13', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 13:04:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1257, 'New Record inserted On item id 14', '14', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 13:05:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1258, 'New Record inserted On item id 15', '15', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 13:06:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1259, 'New Record inserted On item store id 1', '1', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 13:10:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1260, 'New Record inserted On item store id 2', '2', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 134.0', '2025-01-13 13:11:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1261, 'New Record inserted On  Income   id 97', '97', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 17:05:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1262, 'New Record inserted On  Income   id 98', '98', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 17:05:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1263, 'New Record inserted On  Income   id 99', '99', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 17:07:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1264, 'New Record inserted On  Income   id 100', '100', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 17:07:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1265, 'New Record inserted On  Income   id 101', '101', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 17:08:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1266, 'New Record inserted On  Income   id 102', '102', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 17:09:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1267, 'New Record inserted On  expenses   id 135', '135', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 17:22:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1268, 'New Record inserted On  expenses   id 136', '136', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 17:24:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1269, 'New Record inserted On  expenses   id 137', '137', 3, 'Insert', '102.128.79.189', 'Windows 10', 'Firefox 134.0', '2025-01-13 17:27:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1270, 'New Record inserted On  expenses   id 138', '138', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 13:07:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1271, 'New Record inserted On  expenses   id 139', '139', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 13:08:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1272, 'Record updated On  expenses   id 136', '136', 2, 'Update', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 13:16:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1273, 'Record updated On  expenses   id 135', '135', 2, 'Update', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 13:21:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1274, 'Record deleted On student fees deposite id 105', '105', 2, 'Delete', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 15:13:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1275, 'Record deleted On student fees deposite id 104', '104', 2, 'Delete', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 15:14:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1276, 'New Record inserted On  expenses   id 140', '140', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 16:22:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1277, 'New Record inserted On  expenses   id 141', '141', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 16:56:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1278, 'New Record inserted On  expenses   id 142', '142', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 17:00:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1279, 'New Record inserted On  expenses   id 143', '143', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 17:03:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1280, 'New Record inserted On  expenses   id 144', '144', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 17:03:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1281, 'New Record inserted On  expenses   id 145', '145', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 17:06:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1282, 'New Record inserted On  expenses   id 146', '146', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-14 17:09:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1283, 'New Record inserted On  expenses   id 147', '147', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:40:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1284, 'Record updated On  expense head id 1', '1', 2, 'Update', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:41:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1285, 'New Record inserted On  expenses   id 148', '148', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:42:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1286, 'New Record inserted On  expenses   id 149', '149', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:43:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1287, 'Record updated On  expenses   id 147', '147', 2, 'Update', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:43:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1288, 'Record updated On  expense head id 34', '34', 2, 'Update', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:46:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1289, 'New Record inserted On  expenses   id 150', '150', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:48:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1290, 'New Record inserted On  expenses   id 151', '151', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:50:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1291, 'New Record inserted On  expenses   id 152', '152', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:52:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1292, 'New Record inserted On  expenses   id 153', '153', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 13:58:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1293, 'Record updated On  expenses   id 151', '151', 2, 'Update', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 14:10:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1294, 'New Record inserted On  expenses   id 154', '154', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 14:14:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1295, 'New Record inserted On  expenses   id 155', '155', 2, 'Insert', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 14:19:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1296, 'Record updated On  expenses   id 155', '155', 2, 'Update', '102.128.76.163', 'Windows 10', 'Firefox 134.0', '2025-01-15 14:22:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1297, 'New Record inserted On  expenses   id 156', '156', 2, 'Insert', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:05:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1298, 'New Record inserted On  expenses   id 157', '157', 2, 'Insert', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:06:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1299, 'New Record inserted On  expenses   id 158', '158', 2, 'Insert', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:09:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1300, 'New Record inserted On  expenses   id 159', '159', 2, 'Insert', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:15:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1301, 'Record updated On  expenses   id 159', '159', 2, 'Update', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:15:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1302, 'Record updated On  expenses   id 150', '150', 2, 'Update', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:20:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1303, 'Record updated On  expenses   id 149', '149', 2, 'Update', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:22:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1304, 'Record updated On  expenses   id 148', '148', 2, 'Update', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:25:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1305, 'Record updated On  expenses   id 148', '148', 2, 'Update', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:25:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1306, 'Record updated On  expenses   id 148', '148', 2, 'Update', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:27:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1307, 'Record updated On  expenses   id 147', '147', 2, 'Update', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:28:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1308, 'New Record inserted On  expenses   id 160', '160', 2, 'Insert', '102.128.79.221', 'iOS', 'Safari 604.1', '2025-01-15 22:30:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1309, 'New Record inserted On  expenses   id 161', '161', 3, 'Insert', '102.128.76.237', 'Windows 10', 'Firefox 134.0', '2025-01-16 14:14:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1310, 'New Record inserted On  expenses   id 162', '162', 3, 'Insert', '102.128.76.237', 'Windows 10', 'Firefox 134.0', '2025-01-16 14:16:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1311, 'New Record inserted On  expenses   id 163', '163', 3, 'Insert', '102.128.76.237', 'Windows 10', 'Firefox 134.0', '2025-01-16 14:25:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1312, 'Record updated On  expenses   id 163', '163', 2, 'Update', '102.128.76.237', 'iOS', 'Safari 604.1', '2025-01-16 14:27:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1313, 'New Record inserted On  expenses   id 164', '164', 3, 'Insert', '102.128.76.237', 'Windows 10', 'Firefox 134.0', '2025-01-16 14:28:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1314, 'New Record inserted On  expenses   id 165', '165', 3, 'Insert', '102.128.76.237', 'Windows 10', 'Firefox 134.0', '2025-01-16 14:31:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1315, 'New Record inserted On  expenses   id 166', '166', 3, 'Insert', '102.128.76.237', 'Windows 10', 'Firefox 134.0', '2025-01-16 14:40:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1316, 'New Record inserted On students id 116', '116', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:28:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1317, 'New Record inserted On  student session id 116', '116', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:28:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1318, 'New Record inserted On users id 231', '231', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:28:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1319, 'New Record inserted On users id 232', '232', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:28:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1320, 'Record updated On students id 116', '116', 3, 'Update', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:28:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1321, 'New Record inserted On students id 117', '117', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:29:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1322, 'New Record inserted On  student session id 117', '117', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:29:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1323, 'New Record inserted On users id 233', '233', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:29:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1324, 'New Record inserted On users id 234', '234', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:29:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1325, 'Record updated On students id 117', '117', 3, 'Update', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:29:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1326, 'New Record inserted On students id 118', '118', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:31:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1327, 'New Record inserted On  student session id 118', '118', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:31:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1328, 'New Record inserted On users id 235', '235', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:31:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1329, 'New Record inserted On users id 236', '236', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:31:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1330, 'Record updated On students id 118', '118', 3, 'Update', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:31:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1331, 'New Record inserted On students id 119', '119', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:32:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1332, 'New Record inserted On  student session id 119', '119', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:32:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1333, 'New Record inserted On users id 237', '237', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:32:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1334, 'New Record inserted On users id 238', '238', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:32:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1335, 'Record updated On students id 119', '119', 3, 'Update', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:32:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1336, 'New Record inserted On  Income   id 103', '103', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:36:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1337, 'New Record inserted On  Income   id 104', '104', 3, 'Insert', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:36:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1338, 'Record updated On students id 84', '84', 3, 'Update', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:41:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1339, 'Record updated On  student session id 84', '84', 3, 'Update', '102.128.76.243', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:41:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1340, 'Record updated On students id 77', '77', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:46:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1341, 'Record updated On  student session id 77', '77', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-17 17:46:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1342, 'New Record inserted On  expenses   id 167', '167', 3, 'Insert', '77.246.55.230', 'Windows 10', 'Firefox 134.0', '2025-01-18 09:59:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1343, 'New Record inserted On  expenses   id 168', '168', 3, 'Insert', '77.246.55.230', 'Windows 10', 'Firefox 134.0', '2025-01-18 10:04:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1344, 'New Record inserted On  expenses   id 169', '169', 3, 'Insert', '77.246.55.230', 'Windows 10', 'Firefox 134.0', '2025-01-18 10:05:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1345, 'New Record inserted On  expenses   id 170', '170', 3, 'Insert', '77.246.55.230', 'Windows 10', 'Firefox 134.0', '2025-01-18 10:07:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1346, 'Record updated On students id 33', '33', 3, 'Update', '77.246.52.176', 'Windows 10', 'Firefox 134.0', '2025-01-18 10:39:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1347, 'Record updated On  student session id 33', '33', 3, 'Update', '77.246.52.176', 'Windows 10', 'Firefox 134.0', '2025-01-18 10:39:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1348, 'Record updated On students id 34', '34', 3, 'Update', '77.246.52.176', 'Windows 10', 'Firefox 134.0', '2025-01-18 10:40:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1349, 'Record updated On  student session id 34', '34', 3, 'Update', '77.246.52.176', 'Windows 10', 'Firefox 134.0', '2025-01-18 10:40:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1350, 'Record updated On students id 27', '27', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 10:55:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1351, 'Record updated On  student session id 27', '27', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 10:55:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1352, 'Record updated On students id 26', '26', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 11:08:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1353, 'Record updated On  student session id 26', '26', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 11:08:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1354, 'New Record inserted On  Income   id 105', '105', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 11:36:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1355, 'New Record inserted On  Income   id 106', '106', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 11:36:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1356, 'Record updated On students id 31', '31', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 11:47:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1357, 'Record updated On  student session id 31', '31', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 11:47:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1358, 'Record updated On students id 28', '28', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 11:52:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1359, 'Record updated On  student session id 28', '28', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 11:52:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1360, 'New Record inserted On  Income   id 107', '107', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:11:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1361, 'New Record inserted On  Income   id 108', '108', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:12:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1362, 'New Record inserted On  Income   id 109', '109', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:15:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1363, 'New Record inserted On  Income   id 110', '110', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:16:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1364, 'Record updated On students id 68', '68', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:27:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1365, 'Record updated On  student session id 68', '68', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:27:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1366, 'Record updated On students id 67', '67', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:28:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1367, 'Record updated On  student session id 67', '67', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:28:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1368, 'Record updated On students id 74', '74', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:51:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1369, 'Record updated On  student session id 74', '74', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:51:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1370, 'Record updated On students id 66', '66', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:52:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1371, 'Record updated On  student session id 66', '66', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:52:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1372, 'Record updated On students id 51', '51', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:55:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1373, 'Record updated On  student session id 51', '51', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:55:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1374, 'Record updated On students id 65', '65', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:56:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1375, 'Record updated On  student session id 65', '65', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 12:56:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1376, 'Record updated On students id 59', '59', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:08:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1377, 'Record updated On  student session id 59', '59', 3, 'Update', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:08:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1378, 'New Record inserted On  Income   id 111', '111', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:22:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1379, 'New Record inserted On  Income   id 112', '112', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:23:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1380, 'New Record inserted On  Income   id 113', '113', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:24:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1381, 'New Record inserted On  Income   id 114', '114', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:26:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1382, 'New Record inserted On  Income   id 115', '115', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:28:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1383, 'New Record inserted On  Income   id 116', '116', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:28:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1384, 'New Record inserted On  Income   id 117', '117', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:29:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1385, 'New Record inserted On  Income   id 118', '118', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:30:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1386, 'New Record inserted On  Income   id 119', '119', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:31:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1387, 'New Record inserted On  Income   id 120', '120', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:31:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1388, 'New Record inserted On  Income   id 121', '121', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:33:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1389, 'New Record inserted On  Income   id 122', '122', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:34:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1390, 'New Record inserted On  Income   id 123', '123', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:35:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1391, 'New Record inserted On  Income   id 124', '124', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:36:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1392, 'New Record inserted On  Income   id 125', '125', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:36:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1393, 'New Record inserted On  Income   id 126', '126', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:37:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1394, 'New Record inserted On  Income   id 127', '127', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:38:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1395, 'New Record inserted On  Income   id 128', '128', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:40:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1396, 'New Record inserted On  Income   id 129', '129', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:40:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1397, 'New Record inserted On  expenses   id 171', '171', 3, 'Insert', '102.128.76.152', 'Windows 10', 'Firefox 134.0', '2025-01-18 13:41:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1398, 'New Record inserted On  expenses   id 172', '172', 2, 'Insert', '102.128.79.204', 'Windows 10', 'Firefox 134.0', '2025-01-18 19:40:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1399, 'New Record inserted On  expenses   id 173', '173', 2, 'Insert', '102.128.79.204', 'Windows 10', 'Firefox 134.0', '2025-01-18 19:41:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1400, 'New Record inserted On  expenses   id 174', '174', 2, 'Insert', '102.128.79.135', 'Windows 10', 'Firefox 134.0', '2025-01-18 19:44:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1401, 'New Record inserted On  expenses   id 175', '175', 2, 'Insert', '102.128.79.135', 'Windows 10', 'Firefox 134.0', '2025-01-18 19:46:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1402, 'New Record inserted On  expenses   id 176', '176', 2, 'Insert', '102.128.76.221', 'Windows 10', 'Firefox 134.0', '2025-01-18 19:50:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1403, 'New Record inserted On  expenses   id 177', '177', 2, 'Insert', '102.128.76.221', 'Windows 10', 'Firefox 134.0', '2025-01-18 19:51:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1404, 'New Record inserted On  expenses   id 178', '178', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:26:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1405, 'New Record inserted On  expenses   id 179', '179', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:29:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1406, 'Record updated On  expenses   id 179', '179', 2, 'Update', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:30:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1407, 'New Record inserted On  expenses   id 180', '180', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:32:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1408, 'New Record inserted On  expense head id 37', '37', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:33:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1409, 'New Record inserted On  expenses   id 181', '181', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:34:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1410, 'New Record inserted On  expenses   id 182', '182', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:35:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1411, 'New Record inserted On  expenses   id 183', '183', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:43:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1412, 'New Record inserted On  expenses   id 184', '184', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:45:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1413, 'New Record inserted On  expenses   id 185', '185', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:48:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1414, 'New Record inserted On  expenses   id 186', '186', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:49:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1415, 'New Record inserted On  expenses   id 187', '187', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:50:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1416, 'New Record inserted On  expenses   id 188', '188', 2, 'Insert', '77.246.55.173', 'Windows 10', 'Firefox 134.0', '2025-01-21 12:59:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1417, 'New Record inserted On  Income   id 130', '130', 3, 'Insert', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 12:11:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1418, 'New Record inserted On  Income   id 131', '131', 3, 'Insert', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 12:15:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1419, 'New Record inserted On  Income   id 132', '132', 3, 'Insert', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 12:16:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1420, 'New Record inserted On  Income   id 133', '133', 3, 'Insert', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 12:22:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1421, 'New Record inserted On  Income   id 134', '134', 3, 'Insert', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 12:23:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1422, 'New Record inserted On  Income   id 135', '135', 3, 'Insert', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 12:24:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1423, 'New Record inserted On  Income   id 136', '136', 3, 'Insert', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 12:25:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1424, 'Record updated On students id 99', '99', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 13:14:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1425, 'Record updated On  student session id 99', '99', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 13:14:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1426, 'Record updated On students id 108', '108', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 13:45:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1427, 'Record updated On  student session id 108', '108', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 13:45:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1428, 'Record deleted On student fees deposite id 151', '151', 2, 'Delete', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 13:57:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1429, 'Record deleted On student fees deposite id 150', '150', 2, 'Delete', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 13:57:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1430, 'Record updated On students id 60', '60', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 14:21:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1431, 'Record updated On  student session id 60', '60', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 14:21:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1432, 'Record updated On students id 75', '75', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 14:47:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1433, 'Record updated On  student session id 75', '75', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 14:47:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1434, 'Record updated On students id 61', '61', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 15:09:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1435, 'Record updated On  student session id 61', '61', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 15:09:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1436, 'Record updated On students id 67', '67', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 15:14:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1437, 'Record updated On  student session id 67', '67', 3, 'Update', '102.128.76.158', 'Windows 10', 'Firefox 134.0', '2025-01-22 15:14:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1438, 'New Record inserted On  expenses   id 189', '189', 2, 'Insert', '77.246.55.175', 'iOS', 'Safari 604.1', '2025-01-22 17:04:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1439, 'New Record inserted On  expenses   id 190', '190', 2, 'Insert', '77.246.55.175', 'iOS', 'Safari 604.1', '2025-01-22 17:08:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1440, 'New Record inserted On  expenses   id 191', '191', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 14:38:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1441, 'New Record inserted On  expenses   id 192', '192', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 14:40:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1442, 'New Record inserted On  expenses   id 193', '193', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 14:41:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1443, 'New Record inserted On  expenses   id 194', '194', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 14:52:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1444, 'New Record inserted On  expenses   id 195', '195', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 14:54:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1445, 'Record updated On  expenses   id 195', '195', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 14:54:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1446, 'Record updated On  expenses   id 195', '195', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:01:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1447, 'Record updated On  expenses   id 194', '194', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:02:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1448, 'New Record inserted On  expenses   id 196', '196', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:05:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1449, 'New Record inserted On  expenses   id 197', '197', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:06:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1450, 'New Record inserted On  expenses   id 198', '198', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:15:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1451, 'Record updated On  expenses   id 198', '198', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:16:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1452, 'New Record inserted On  expenses   id 199', '199', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:17:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1453, 'New Record inserted On  expenses   id 200', '200', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:31:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1454, 'New Record inserted On  expenses   id 201', '201', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:33:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1455, 'New Record inserted On  expenses   id 202', '202', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:34:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1456, 'New Record inserted On  expenses   id 203', '203', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:36:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1457, 'New Record inserted On  expenses   id 204', '204', 3, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:37:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1458, 'New Record inserted On  expenses   id 205', '205', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:37:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1459, 'New Record inserted On  expenses   id 206', '206', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:38:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1460, 'New Record inserted On  expenses   id 207', '207', 3, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:42:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1461, 'New Record inserted On  expenses   id 208', '208', 3, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:43:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1462, 'New Record inserted On  expenses   id 209', '209', 3, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:45:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1463, 'Record updated On  expenses   id 200', '200', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:47:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1464, 'New Record inserted On  expenses   id 210', '210', 3, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:47:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1465, 'New Record inserted On  expenses   id 211', '211', 3, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:48:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1466, 'New Record inserted On  expenses   id 212', '212', 3, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1467, 'New Record inserted On  expenses   id 213', '213', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:50:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1468, 'New Record inserted On  expenses   id 214', '214', 2, 'Insert', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:52:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1469, 'Record updated On  expenses   id 214', '214', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:53:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1470, 'Record updated On  expenses   id 209', '209', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:53:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1471, 'Record updated On  expenses   id 208', '208', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:53:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1472, 'Record updated On  expenses   id 210', '210', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:54:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1473, 'Record updated On  expenses   id 211', '211', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:54:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1474, 'Record updated On  expenses   id 198', '198', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:55:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1475, 'Record updated On  expense head id 34', '34', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:55:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1476, 'Record updated On  expenses   id 196', '196', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:56:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1477, 'Record updated On  expenses   id 194', '194', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:57:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1478, 'Record updated On  expenses   id 195', '195', 2, 'Update', '102.128.79.245', 'Windows 10', 'Firefox 134.0', '2025-01-23 15:57:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1479, 'Record updated On staff id 4', '4', 2, 'Update', '102.128.76.206', 'Windows 10', 'Firefox 134.0', '2025-01-24 12:05:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1480, 'Record deleted On student fees deposite id 196', '196', 2, 'Delete', '102.128.76.206', 'iOS', 'Safari 604.1', '2025-01-24 12:11:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1481, 'New Record inserted On  expenses   id 215', '215', 2, 'Insert', '102.128.76.206', 'Windows 10', 'Firefox 134.0', '2025-01-24 12:56:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1482, 'New Record inserted On  expenses   id 216', '216', 2, 'Insert', '102.128.76.206', 'Windows 10', 'Firefox 134.0', '2025-01-24 13:00:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1483, 'New Record inserted On  expenses   id 217', '217', 2, 'Insert', '102.128.79.203', 'Windows 10', 'Firefox 134.0', '2025-01-24 13:41:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1484, 'New Record inserted On  expenses   id 218', '218', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-26 17:41:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1485, 'New Record inserted On  expenses   id 219', '219', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-26 17:43:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1486, 'New Record inserted On  expenses   id 220', '220', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-26 17:44:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1487, 'New Record inserted On  expenses   id 221', '221', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-26 17:44:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1488, 'New Record inserted On  expenses   id 222', '222', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-26 17:45:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1489, 'New Record inserted On  expenses   id 223', '223', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-26 17:46:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1490, 'New Record inserted On  expenses   id 224', '224', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-26 17:47:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1491, 'New Record inserted On  expenses   id 225', '225', 3, 'Insert', '102.128.76.176', 'Windows 10', 'Firefox 134.0', '2025-01-27 13:26:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1492, 'New Record inserted On  expenses   id 226', '226', 3, 'Insert', '102.128.76.176', 'Windows 10', 'Firefox 134.0', '2025-01-27 13:29:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1493, 'New Record inserted On  expenses   id 227', '227', 3, 'Insert', '102.128.76.176', 'Windows 10', 'Firefox 134.0', '2025-01-27 13:33:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1494, 'New Record inserted On  expenses   id 228', '228', 3, 'Insert', '102.128.76.176', 'Windows 10', 'Firefox 134.0', '2025-01-27 13:45:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1495, 'Record updated On staff id 5', '5', 3, 'Update', '102.128.76.176', 'Windows 10', 'Firefox 134.0', '2025-01-27 14:24:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1496, 'Record updated On staff id 6', '6', 3, 'Update', '102.128.76.176', 'Windows 10', 'Firefox 134.0', '2025-01-27 14:27:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1497, 'Record updated On staff id 7', '7', 3, 'Update', '102.128.76.176', 'Windows 10', 'Firefox 134.0', '2025-01-27 14:31:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1498, 'Record updated On staff id 8', '8', 3, 'Update', '102.128.76.176', 'Windows 10', 'Firefox 134.0', '2025-01-27 14:40:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1499, 'Record updated On  expenses   id 226', '226', 2, 'Update', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-27 15:38:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1500, 'New Record inserted On  expenses   id 229', '229', 3, 'Insert', '102.128.79.175', 'Windows 10', 'Firefox 134.0', '2025-01-27 15:39:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1501, 'New Record inserted On  expenses   id 230', '230', 3, 'Insert', '102.128.79.175', 'Windows 10', 'Firefox 134.0', '2025-01-27 15:40:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1502, 'New Record inserted On  expenses   id 231', '231', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-27 17:37:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1503, 'New Record inserted On  expenses   id 232', '232', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-27 17:38:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1504, 'New Record inserted On  expenses   id 233', '233', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-27 17:39:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1505, 'Record updated On  expenses   id 233', '233', 2, 'Update', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-27 17:39:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1506, 'New Record inserted On  expenses   id 234', '234', 2, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-27 17:40:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1507, 'New Record inserted On  Income   id 137', '137', 3, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 11:19:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1508, 'New Record inserted On  Income   id 138', '138', 3, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 11:20:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1509, 'New Record inserted On  expenses   id 235', '235', 3, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 12:31:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1510, 'New Record inserted On  expenses   id 236', '236', 3, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 12:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1511, 'New Record inserted On  expenses   id 237', '237', 3, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 13:40:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1512, 'New Record inserted On  expenses   id 238', '238', 3, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 13:41:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1513, 'New Record inserted On  expenses   id 239', '239', 2, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 14:08:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1514, 'New Record inserted On  expenses   id 240', '240', 2, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 14:17:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1515, 'New Record inserted On  expenses   id 241', '241', 2, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 14:18:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1516, 'New Record inserted On  expenses   id 242', '242', 3, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 14:46:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1517, 'New Record inserted On  expenses   id 243', '243', 3, 'Insert', '102.128.76.223', 'Windows 10', 'Firefox 134.0', '2025-01-28 14:49:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1518, 'New Record inserted On  expenses   id 244', '244', 2, 'Insert', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:43:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1519, 'Record updated On  expenses   id 243', '243', 2, 'Update', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:44:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1520, 'Record updated On  expenses   id 241', '241', 2, 'Update', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:44:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1521, 'Record updated On  expenses   id 239', '239', 2, 'Update', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:45:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1522, 'Record updated On  expenses   id 229', '229', 2, 'Update', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:46:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1523, 'Record updated On  expenses   id 238', '238', 2, 'Update', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:46:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1524, 'Record updated On  expenses   id 230', '230', 2, 'Update', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:47:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1525, 'Record updated On  expenses   id 237', '237', 2, 'Update', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:48:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1526, 'Record updated On  expenses   id 228', '228', 2, 'Update', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:49:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1527, 'Record updated On  expenses   id 225', '225', 2, 'Update', '77.246.50.118', 'iOS', 'Safari 604.1', '2025-01-28 16:50:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1528, 'New Record inserted On  expenses   id 245', '245', 3, 'Insert', '102.128.76.227', 'Windows 10', 'Firefox 134.0', '2025-01-29 13:09:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1529, 'New Record inserted On  expenses   id 246', '246', 3, 'Insert', '102.128.76.227', 'Windows 10', 'Firefox 134.0', '2025-01-29 13:12:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1530, 'New Record inserted On  expenses   id 247', '247', 3, 'Insert', '102.128.76.227', 'Windows 10', 'Firefox 134.0', '2025-01-29 13:17:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1531, 'New Record inserted On  expenses   id 248', '248', 3, 'Insert', '102.128.76.227', 'Windows 10', 'Firefox 134.0', '2025-01-29 13:20:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1532, 'New Record inserted On  expenses   id 249', '249', 2, 'Insert', '77.246.52.174', 'Windows 10', 'Firefox 134.0', '2025-01-29 14:48:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1533, 'New Record inserted On  expenses   id 250', '250', 2, 'Insert', '77.246.52.174', 'Windows 10', 'Firefox 134.0', '2025-01-29 14:49:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1534, 'New Record inserted On  expenses   id 251', '251', 2, 'Insert', '77.246.52.174', 'Windows 10', 'Firefox 134.0', '2025-01-29 14:51:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1535, 'New Record inserted On  expenses   id 252', '252', 2, 'Insert', '77.246.52.174', 'Windows 10', 'Firefox 134.0', '2025-01-29 14:52:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1536, 'New Record inserted On  expenses   id 253', '253', 2, 'Insert', '77.246.52.174', 'Windows 10', 'Firefox 134.0', '2025-01-29 15:06:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1537, 'Record updated On  expenses   id 253', '253', 2, 'Update', '77.246.52.174', 'Windows 10', 'Firefox 134.0', '2025-01-29 15:08:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1538, 'New Record inserted On  expenses   id 254', '254', 2, 'Insert', '77.246.55.171', 'Windows 10', 'Firefox 134.0', '2025-01-29 15:10:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1539, 'New Record inserted On students id 120', '120', 3, 'Insert', '102.128.79.165', 'Windows 10', 'Firefox 134.0', '2025-01-30 14:17:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1540, 'New Record inserted On  student session id 120', '120', 3, 'Insert', '102.128.79.165', 'Windows 10', 'Firefox 134.0', '2025-01-30 14:17:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1541, 'New Record inserted On users id 239', '239', 3, 'Insert', '102.128.79.165', 'Windows 10', 'Firefox 134.0', '2025-01-30 14:17:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1542, 'New Record inserted On users id 240', '240', 3, 'Insert', '102.128.79.165', 'Windows 10', 'Firefox 134.0', '2025-01-30 14:17:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1543, 'Record updated On students id 120', '120', 3, 'Update', '102.128.79.165', 'Windows 10', 'Firefox 134.0', '2025-01-30 14:17:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1544, 'New Record inserted On  Income   id 139', '139', 3, 'Insert', '102.128.79.165', 'Windows 10', 'Firefox 134.0', '2025-01-30 14:25:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1545, 'New Record inserted On  expenses   id 255', '255', 3, 'Insert', '102.128.76.174', 'Windows 10', 'Firefox 134.0', '2025-01-31 10:18:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1546, 'New Record inserted On  expenses   id 256', '256', 3, 'Insert', '102.128.76.208', 'Windows 10', 'Firefox 134.0', '2025-01-31 11:52:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1547, 'New Record inserted On  expenses   id 257', '257', 2, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 134.0', '2025-01-31 12:03:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1548, 'Record updated On  expenses   id 248', '248', 2, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 134.0', '2025-01-31 12:07:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1549, 'Record updated On  expenses   id 245', '245', 2, 'Update', '102.128.76.165', 'Windows 10', 'Firefox 134.0', '2025-01-31 12:08:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1550, 'New Record inserted On  expenses   id 258', '258', 3, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 134.0', '2025-01-31 12:18:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1551, 'New Record inserted On  expenses   id 259', '259', 3, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 134.0', '2025-01-31 12:19:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1552, 'New Record inserted On  expenses   id 260', '260', 3, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 134.0', '2025-01-31 12:27:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1553, 'New Record inserted On  expenses   id 261', '261', 3, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 134.0', '2025-01-31 12:30:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1554, 'New Record inserted On  expenses   id 262', '262', 3, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 134.0', '2025-01-31 15:14:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1555, 'New Record inserted On  expenses   id 263', '263', 3, 'Insert', '102.128.76.165', 'Windows 10', 'Firefox 134.0', '2025-01-31 15:15:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1556, 'New Record inserted On  expenses   id 264', '264', 2, 'Insert', '197.221.253.152', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:13:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1557, 'New Record inserted On  expenses   id 265', '265', 2, 'Insert', '197.221.253.152', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:17:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1558, 'Record updated On  expenses   id 264', '264', 2, 'Update', '197.221.253.152', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:17:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1559, 'Record updated On  expenses   id 265', '265', 2, 'Update', '197.221.253.152', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:18:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1560, 'New Record inserted On  expenses   id 266', '266', 2, 'Insert', '197.221.253.152', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:18:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1561, 'New Record inserted On  expenses   id 267', '267', 2, 'Insert', '197.221.253.152', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:20:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1562, 'New Record inserted On  expenses   id 268', '268', 2, 'Insert', '197.221.253.23', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:24:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1563, 'Record updated On  expenses   id 267', '267', 2, 'Update', '197.221.253.23', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:24:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1564, 'Record updated On  expenses   id 266', '266', 2, 'Update', '197.221.253.23', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:24:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1565, 'New Record inserted On  expenses   id 269', '269', 2, 'Insert', '197.221.253.23', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:25:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1566, 'Record updated On  expenses   id 269', '269', 2, 'Update', '197.221.253.23', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:26:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1567, 'New Record inserted On  expenses   id 270', '270', 2, 'Insert', '77.246.52.183', 'Windows 10', 'Firefox 134.0', '2025-02-03 09:28:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1568, 'New Record inserted On  expenses   id 271', '271', 3, 'Insert', '102.128.76.201', 'Windows 10', 'Firefox 134.0', '2025-02-03 12:10:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1569, 'New Record inserted On  expenses   id 272', '272', 3, 'Insert', '102.128.76.201', 'Windows 10', 'Firefox 134.0', '2025-02-03 12:20:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1570, 'New Record inserted On  expenses   id 273', '273', 3, 'Insert', '102.128.76.201', 'Windows 10', 'Firefox 134.0', '2025-02-03 12:46:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1571, 'New Record inserted On  expenses   id 274', '274', 3, 'Insert', '102.128.76.201', 'Windows 10', 'Firefox 134.0', '2025-02-03 13:25:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1572, 'New Record inserted On  expenses   id 275', '275', 3, 'Insert', '102.128.76.201', 'Windows 10', 'Firefox 134.0', '2025-02-03 13:26:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1573, 'New Record inserted On  expenses   id 276', '276', 3, 'Insert', '102.128.76.201', 'Windows 10', 'Firefox 134.0', '2025-02-03 13:27:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1574, 'New Record inserted On  expenses   id 277', '277', 3, 'Insert', '102.128.76.201', 'Windows 10', 'Firefox 134.0', '2025-02-03 13:30:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1575, 'Record updated On students id 70', '70', 3, 'Update', '102.128.76.224', 'Windows 10', 'Firefox 134.0', '2025-02-03 17:16:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1576, 'Record updated On  student session id 70', '70', 3, 'Update', '102.128.76.224', 'Windows 10', 'Firefox 134.0', '2025-02-03 17:16:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1577, 'New Record inserted On  expenses   id 278', '278', 3, 'Insert', '102.128.76.229', 'Windows 10', 'Firefox 134.0', '2025-02-04 11:34:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1578, 'New Record inserted On  expenses   id 279', '279', 3, 'Insert', '102.128.76.229', 'Windows 10', 'Firefox 134.0', '2025-02-04 11:36:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1579, 'New Record inserted On  expenses   id 280', '280', 3, 'Insert', '102.128.76.229', 'Windows 10', 'Firefox 134.0', '2025-02-04 11:40:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1580, 'New Record inserted On  expenses   id 281', '281', 3, 'Insert', '102.128.76.229', 'Windows 10', 'Firefox 134.0', '2025-02-04 11:42:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1581, 'New Record inserted On  expenses   id 282', '282', 3, 'Insert', '102.128.76.229', 'Windows 10', 'Firefox 134.0', '2025-02-04 11:43:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1582, 'New Record inserted On  expenses   id 283', '283', 3, 'Insert', '102.128.76.229', 'Windows 10', 'Firefox 134.0', '2025-02-04 11:45:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1583, 'New Record inserted On  expenses   id 284', '284', 3, 'Insert', '102.128.76.229', 'Windows 10', 'Firefox 134.0', '2025-02-04 11:53:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1584, 'New Record inserted On  expenses   id 285', '285', 3, 'Insert', '102.128.76.229', 'Windows 10', 'Firefox 134.0', '2025-02-04 11:57:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1585, 'New Record inserted On  Income   id 140', '140', 3, 'Insert', '102.128.76.229', 'Windows 10', 'Firefox 134.0', '2025-02-04 12:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1586, 'Record updated On  expenses   id 283', '283', 2, 'Update', '102.128.79.171', 'iOS', 'Safari 604.1', '2025-02-04 15:10:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1587, 'New Record inserted On  expenses   id 286', '286', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:10:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1588, 'Record updated On  expenses   id 286', '286', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:10:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1589, 'Record updated On  expenses   id 274', '274', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:12:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1590, 'Record updated On  expenses   id 279', '279', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:13:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1591, 'Record updated On  expenses   id 284', '284', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:16:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1592, 'Record updated On  expenses   id 284', '284', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:17:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1593, 'Record updated On  expenses   id 285', '285', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:18:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1594, 'Record updated On  expenses   id 275', '275', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:20:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1595, 'New Record inserted On  expenses   id 287', '287', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:25:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1596, 'New Record inserted On Staff Payslip id 1', '1', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:28:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1597, 'New Record inserted On payslip allowance id 1', '1', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:28:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1598, 'New Record inserted On payslip allowance id 2', '2', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:28:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1599, 'New Record inserted On Staff Payslip id 2', '2', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:29:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1600, 'New Record inserted On payslip allowance id 3', '3', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:29:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1601, 'New Record inserted On payslip allowance id 4', '4', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:29:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1602, 'New Record inserted On Staff Payslip id 3', '3', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:29:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1603, 'New Record inserted On payslip allowance id 5', '5', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:29:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1604, 'New Record inserted On payslip allowance id 6', '6', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:29:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1605, 'New Record inserted On Staff Payslip id 4', '4', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:30:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1606, 'New Record inserted On payslip allowance id 7', '7', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:30:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1607, 'New Record inserted On payslip allowance id 8', '8', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:30:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1608, 'New Record inserted On Staff Payslip id 5', '5', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:30:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1609, 'New Record inserted On payslip allowance id 9', '9', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:30:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1610, 'New Record inserted On payslip allowance id 10', '10', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:30:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1611, 'New Record inserted On Staff Payslip id 6', '6', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:31:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1612, 'New Record inserted On payslip allowance id 11', '11', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:31:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1613, 'New Record inserted On payslip allowance id 12', '12', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:31:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1614, 'Record updated On staff payslip id 2', '2', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:31:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1615, 'Record updated On staff payslip id 3', '3', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:33:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1616, 'Record updated On staff payslip id ', '', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:34:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1617, 'Record updated On staff payslip id 4', '4', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:34:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1618, 'Record updated On staff payslip id 5', '5', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:35:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1619, 'Record updated On staff payslip id ', '', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:36:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1620, 'Record updated On staff payslip id ', '', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:37:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1621, 'Record updated On staff payslip id 6', '6', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:38:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1622, 'Record updated On staff id 9', '9', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:45:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1623, 'Record updated On staff id 10', '10', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:49:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1624, 'New Record inserted On Staff Payslip id 7', '7', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:50:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1625, 'New Record inserted On payslip allowance id 13', '13', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:50:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1626, 'New Record inserted On payslip allowance id 14', '14', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:50:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1627, 'New Record inserted On Staff Payslip id 8', '8', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:50:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1628, 'New Record inserted On payslip allowance id 15', '15', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:50:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1629, 'New Record inserted On payslip allowance id 16', '16', 2, 'Insert', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:50:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1630, 'Record updated On staff payslip id 7', '7', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:51:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1631, 'Record updated On staff payslip id 8', '8', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:52:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1632, 'Record updated On staff payslip id 2', '2', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:54:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1633, 'Record updated On staff payslip id 3', '3', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:55:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1634, 'Record updated On staff payslip id 4', '4', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:56:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1635, 'Record updated On staff payslip id 5', '5', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 19:58:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1636, 'Record updated On staff payslip id ', '', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:00:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1637, 'Record updated On staff payslip id 6', '6', 2, 'Update', '102.128.79.154', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:01:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1638, 'Record updated On staff payslip id 7', '7', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:20:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1639, 'New Record inserted On  expenses   id 288', '288', 2, 'Insert', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:24:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1640, 'Record updated On  expenses   id 274', '274', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:25:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1641, 'Record updated On staff id 6', '6', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:27:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1642, 'Record updated On staff id 6', '6', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:27:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1643, 'Record updated On staff id 9', '9', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:28:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1644, 'Record updated On staff id 9', '9', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:28:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1645, 'Record updated On staff id 7', '7', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:29:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1646, 'Record updated On staff id 7', '7', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:29:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1647, 'Record updated On staff id 9', '9', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:30:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1648, 'Record updated On staff id 9', '9', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:30:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1649, 'Record updated On staff id 10', '10', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:31:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1650, 'Record updated On staff id 10', '10', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:31:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1651, 'Record updated On staff id 5', '5', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:32:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1652, 'Record updated On staff id 5', '5', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:32:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1653, 'Record updated On staff id 8', '8', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:32:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1654, 'Record updated On staff id 8', '8', 2, 'Update', '102.128.76.242', 'Windows 10', 'Firefox 134.0', '2025-02-04 20:32:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1655, 'Record updated On  expenses   id 260', '260', 2, 'Update', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:20:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1656, 'New Record inserted On  expenses   id 289', '289', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:21:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1657, 'New Record inserted On  expenses   id 290', '290', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:25:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1658, 'New Record inserted On  expenses   id 291', '291', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:27:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1659, 'New Record inserted On  expenses   id 292', '292', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:28:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1660, 'New Record inserted On  expenses   id 293', '293', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:30:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1661, 'New Record inserted On  expenses   id 294', '294', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:31:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1662, 'New Record inserted On  expenses   id 295', '295', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:35:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1663, 'Record updated On  expenses   id 281', '281', 2, 'Update', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:39:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1664, 'New Record inserted On  expenses   id 296', '296', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:40:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1665, 'Record updated On  expenses   id 288', '288', 2, 'Update', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:42:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1666, 'Record updated On  expenses   id 287', '287', 2, 'Update', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:42:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1667, 'New Record inserted On  expenses   id 297', '297', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:44:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1668, 'New Record inserted On  expenses   id 298', '298', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:45:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1669, 'Record updated On  expenses   id 272', '272', 2, 'Update', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:46:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1670, 'New Record inserted On  expenses   id 299', '299', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:48:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1671, 'Record updated On  expenses   id 299', '299', 2, 'Update', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:49:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1672, 'New Record inserted On  expenses   id 300', '300', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:57:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1673, 'New Record inserted On  expenses   id 301', '301', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:58:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1674, 'New Record inserted On  expenses   id 302', '302', 2, 'Insert', '102.128.79.253', 'Windows 10', 'Firefox 134.0', '2025-02-05 19:59:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1675, 'New Record inserted On  expenses   id 303', '303', 3, 'Insert', '102.128.76.145', 'Windows 10', 'Firefox 134.0', '2025-02-06 09:24:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1676, 'New Record inserted On  expenses   id 304', '304', 3, 'Insert', '102.128.76.145', 'Windows 10', 'Firefox 134.0', '2025-02-06 11:27:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1677, 'New Record inserted On  expenses   id 305', '305', 3, 'Insert', '102.128.76.145', 'Windows 10', 'Firefox 134.0', '2025-02-06 11:30:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1678, 'New Record inserted On  Income   id 141', '141', 3, 'Insert', '102.128.79.228', 'Windows 10', 'Firefox 134.0', '2025-02-06 12:05:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1679, 'New Record inserted On  Income   id 142', '142', 3, 'Insert', '102.128.79.228', 'Windows 10', 'Firefox 134.0', '2025-02-06 12:07:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1680, 'New Record inserted On  Income   id 143', '143', 3, 'Insert', '102.128.79.228', 'Windows 10', 'Firefox 134.0', '2025-02-06 12:07:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1681, 'New Record inserted On  Income   id 144', '144', 3, 'Insert', '102.128.79.228', 'Windows 10', 'Firefox 134.0', '2025-02-06 12:08:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1682, 'New Record inserted On  expenses   id 306', '306', 3, 'Insert', '102.128.79.151', 'Windows 10', 'Firefox 134.0', '2025-02-06 15:06:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1683, 'New Record inserted On  expenses   id 307', '307', 2, 'Insert', '102.128.76.207', 'Windows 10', 'Firefox 135.0', '2025-02-06 18:54:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1684, 'New Record inserted On  expense head id 38', '38', 2, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:02:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1685, 'New Record inserted On  expenses   id 308', '308', 2, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:03:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1686, 'Record updated On  expense head id 38', '38', 2, 'Update', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:04:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1687, 'Record updated On  expenses   id 308', '308', 2, 'Update', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:04:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1688, 'New Record inserted On  expenses   id 309', '309', 2, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:08:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1689, 'New Record inserted On  expenses   id 310', '310', 2, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:10:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1690, 'Record updated On  expenses   id 310', '310', 2, 'Update', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:15:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1691, 'Record updated On  expenses   id 310', '310', 2, 'Update', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:17:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1692, 'New Record inserted On  expenses   id 311', '311', 2, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:24:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1693, 'New Record inserted On  expenses   id 312', '312', 2, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 10:25:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1694, 'New Record inserted On  expenses   id 313', '313', 3, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 11:32:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1695, 'New Record inserted On  expenses   id 314', '314', 3, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 11:45:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1696, 'New Record inserted On  expenses   id 315', '315', 3, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 11:47:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1697, 'New Record inserted On  expenses   id 316', '316', 3, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 11:48:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1698, 'New Record inserted On  expenses   id 317', '317', 3, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 11:49:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1699, 'New Record inserted On  expenses   id 318', '318', 3, 'Insert', '102.128.76.219', 'Windows 10', 'Firefox 135.0', '2025-02-07 11:52:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1700, 'New Record inserted On  expenses   id 319', '319', 2, 'Insert', '102.128.76.128', 'iOS', 'Safari 604.1', '2025-02-09 12:46:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1701, 'New Record inserted On  expenses   id 320', '320', 2, 'Insert', '102.128.76.128', 'iOS', 'Safari 604.1', '2025-02-09 12:48:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1702, 'New Record inserted On  expenses   id 321', '321', 2, 'Insert', '102.128.76.128', 'iOS', 'Safari 604.1', '2025-02-09 12:49:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1703, 'New Record inserted On  expenses   id 322', '322', 2, 'Insert', '102.128.76.128', 'iOS', 'Safari 604.1', '2025-02-09 12:51:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1704, 'New Record inserted On  Income   id 145', '145', 3, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 12:32:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1705, 'New Record inserted On  Income   id 146', '146', 3, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 12:33:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1706, 'New Record inserted On  expense head id 39', '39', 2, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 12:33:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1707, 'New Record inserted On  expenses   id 323', '323', 2, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 12:36:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1708, 'New Record inserted On  expenses   id 324', '324', 2, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 12:38:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1709, 'New Record inserted On  expenses   id 325', '325', 2, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 12:39:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1710, 'Record updated On  expenses   id 320', '320', 2, 'Update', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:00:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1711, 'New Record inserted On  expenses   id 326', '326', 2, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:02:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1712, 'Record updated On students id 46', '46', 3, 'Update', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:03:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1713, 'Record updated On  student session id 46', '46', 3, 'Update', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:03:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1714, 'New Record inserted On  expenses   id 327', '327', 3, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:14:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1715, 'New Record inserted On  expenses   id 328', '328', 3, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:15:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1716, 'New Record inserted On  expenses   id 329', '329', 3, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:17:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1717, 'New Record inserted On  expenses   id 330', '330', 3, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:19:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1718, 'New Record inserted On  expenses   id 331', '331', 3, 'Insert', '102.128.79.240', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:33:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1719, 'New Record inserted On  expenses   id 332', '332', 3, 'Insert', '102.128.79.184', 'Windows 10', 'Firefox 135.0', '2025-02-10 13:58:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1720, 'New Record inserted On  expenses   id 333', '333', 3, 'Insert', '102.128.79.184', 'Windows 10', 'Firefox 135.0', '2025-02-10 14:05:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1721, 'New Record inserted On  expenses   id 334', '334', 2, 'Insert', '102.128.76.247', 'Windows 10', 'Firefox 135.0', '2025-02-10 14:44:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1722, 'New Record inserted On  expenses   id 335', '335', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:29:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1723, 'New Record inserted On  expenses   id 336', '336', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:31:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1724, 'New Record inserted On  expenses   id 337', '337', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1725, 'New Record inserted On  expenses   id 338', '338', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:39:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1726, 'New Record inserted On  expenses   id 339', '339', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:40:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1727, 'Record updated On  expenses   id 338', '338', 2, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:41:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1728, 'Record updated On  expenses   id 337', '337', 2, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:42:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1729, 'New Record inserted On  expenses   id 340', '340', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:43:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1730, 'New Record inserted On  expenses   id 341', '341', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:46:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1731, 'New Record inserted On  expenses   id 342', '342', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:48:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1732, 'New Record inserted On  expenses   id 343', '343', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:53:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1733, 'New Record inserted On  expenses   id 344', '344', 2, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 11:56:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1734, 'Record updated On  expenses   id 344', '344', 2, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 12:03:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1735, 'New Record inserted On  expenses   id 345', '345', 3, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 13:31:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1736, 'New Record inserted On  expenses   id 346', '346', 3, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 13:35:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1737, 'Record updated On students id 73', '73', 3, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 14:07:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1738, 'Record updated On  student session id 73', '73', 3, 'Update', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 14:07:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1739, 'New Record inserted On  Income   id 147', '147', 3, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 14:46:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1740, 'New Record inserted On  Income   id 148', '148', 3, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 14:46:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1741, 'New Record inserted On  expenses   id 347', '347', 3, 'Insert', '102.128.79.142', 'Windows 10', 'Firefox 135.0', '2025-02-11 15:00:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1742, 'New Record inserted On  expenses   id 348', '348', 3, 'Insert', '102.128.76.190', 'Windows 10', 'Firefox 135.0', '2025-02-11 15:34:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1743, 'New Record inserted On  expenses   id 349', '349', 3, 'Insert', '102.128.76.190', 'Windows 10', 'Firefox 135.0', '2025-02-11 15:36:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1744, 'New Record inserted On  expenses   id 350', '350', 3, 'Insert', '102.128.76.190', 'Windows 10', 'Firefox 135.0', '2025-02-11 16:40:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1745, 'New Record inserted On  expenses   id 351', '351', 3, 'Insert', '102.128.76.190', 'Windows 10', 'Firefox 135.0', '2025-02-11 16:42:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1746, 'New Record inserted On  expenses   id 352', '352', 3, 'Insert', '102.128.76.161', 'Windows 10', 'Firefox 135.0', '2025-02-12 09:44:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1747, 'New Record inserted On  expenses   id 353', '353', 3, 'Insert', '102.128.79.167', 'Windows 10', 'Firefox 135.0', '2025-02-12 13:29:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1748, 'New Record inserted On  expenses   id 354', '354', 3, 'Insert', '102.128.79.167', 'Windows 10', 'Firefox 135.0', '2025-02-12 13:32:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1749, 'New Record inserted On  expenses   id 355', '355', 3, 'Insert', '102.128.79.167', 'Windows 10', 'Firefox 135.0', '2025-02-12 16:56:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1750, 'New Record inserted On  expenses   id 356', '356', 3, 'Insert', '102.128.79.167', 'Windows 10', 'Firefox 135.0', '2025-02-12 16:58:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1751, 'New Record inserted On  expenses   id 357', '357', 3, 'Insert', '102.128.79.167', 'Windows 10', 'Firefox 135.0', '2025-02-12 17:00:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1752, 'New Record inserted On  expenses   id 358', '358', 3, 'Insert', '102.128.79.138', 'Windows 10', 'Firefox 135.0', '2025-02-13 10:59:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1753, 'New Record inserted On  expenses   id 359', '359', 2, 'Insert', '102.128.76.186', 'Windows 10', 'Firefox 135.0', '2025-02-16 17:40:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1754, 'New Record inserted On  expenses   id 360', '360', 2, 'Insert', '102.128.76.186', 'Windows 10', 'Firefox 135.0', '2025-02-16 17:42:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1755, 'New Record inserted On  expenses   id 361', '361', 2, 'Insert', '102.128.76.186', 'Windows 10', 'Firefox 135.0', '2025-02-16 17:42:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1756, 'Record updated On  expenses   id 361', '361', 2, 'Update', '102.128.76.186', 'Windows 10', 'Firefox 135.0', '2025-02-16 17:43:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1757, 'New Record inserted On  expenses   id 362', '362', 2, 'Insert', '102.128.76.186', 'Windows 10', 'Firefox 135.0', '2025-02-16 17:44:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1758, 'Record updated On  expenses   id 348', '348', 2, 'Update', '102.128.76.186', 'Windows 10', 'Firefox 135.0', '2025-02-16 17:45:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1759, 'New Record inserted On  expenses   id 363', '363', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 13:19:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1760, 'New Record inserted On  expenses   id 364', '364', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 14:32:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1761, 'New Record inserted On  expenses   id 365', '365', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 14:44:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1762, 'New Record inserted On  expenses   id 366', '366', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 14:45:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1763, 'New Record inserted On  expenses   id 367', '367', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 14:48:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1764, 'New Record inserted On  expenses   id 368', '368', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 14:54:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1765, 'New Record inserted On  expenses   id 369', '369', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 14:57:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1766, 'New Record inserted On  expenses   id 370', '370', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 15:07:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1767, 'New Record inserted On  expenses   id 371', '371', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 15:08:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1768, 'New Record inserted On  expenses   id 372', '372', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 15:10:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1769, 'New Record inserted On  expenses   id 373', '373', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 16:09:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1770, 'New Record inserted On  expenses   id 374', '374', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 16:10:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1771, 'New Record inserted On  expenses   id 375', '375', 2, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 16:53:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1772, 'New Record inserted On  expenses   id 376', '376', 2, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 17:00:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1773, 'New Record inserted On  expenses   id 377', '377', 3, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 17:06:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1774, 'Record updated On  expenses   id 370', '370', 2, 'Update', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 17:28:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1775, 'New Record inserted On  expenses   id 378', '378', 2, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 17:29:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1776, 'New Record inserted On  expenses   id 379', '379', 2, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 17:31:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1777, 'New Record inserted On  expenses   id 380', '380', 2, 'Insert', '102.128.79.244', 'Windows 10', 'Firefox 135.0', '2025-02-17 17:41:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1778, 'New Record inserted On  income head   id 4', '4', 2, 'Insert', '102.128.79.225', 'Windows 10', 'Firefox 135.0', '2025-02-17 18:00:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1779, 'New Record inserted On  Income   id 149', '149', 2, 'Insert', '102.128.79.225', 'Windows 10', 'Firefox 135.0', '2025-02-17 18:04:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1780, 'New Record inserted On  expense head id 40', '40', 3, 'Insert', '102.128.79.146', 'Windows 10', 'Firefox 135.0', '2025-02-18 09:02:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1781, 'New Record inserted On  expenses   id 381', '381', 3, 'Insert', '102.128.79.146', 'Windows 10', 'Firefox 135.0', '2025-02-18 09:04:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1782, 'New Record inserted On  expenses   id 382', '382', 3, 'Insert', '102.128.79.146', 'Windows 10', 'Firefox 135.0', '2025-02-18 09:05:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1783, 'New Record inserted On  expenses   id 383', '383', 3, 'Insert', '102.128.79.146', 'Windows 10', 'Firefox 135.0', '2025-02-18 09:08:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1784, 'New Record inserted On  expenses   id 384', '384', 3, 'Insert', '102.128.79.146', 'Windows 10', 'Firefox 135.0', '2025-02-18 09:09:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1785, 'New Record inserted On  expenses   id 385', '385', 3, 'Insert', '102.128.76.208', 'Windows 10', 'Firefox 135.0', '2025-02-19 09:50:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1786, 'New Record inserted On  expenses   id 386', '386', 3, 'Insert', '102.128.76.208', 'Windows 10', 'Firefox 135.0', '2025-02-19 09:52:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1787, 'New Record inserted On  expenses   id 387', '387', 2, 'Insert', '102.128.76.208', 'Windows 10', 'Firefox 135.0', '2025-02-19 09:52:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1788, 'Record updated On  expenses   id 387', '387', 2, 'Update', '102.128.76.208', 'Windows 10', 'Firefox 135.0', '2025-02-19 09:53:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1789, 'New Record inserted On  expenses   id 388', '388', 2, 'Insert', '102.128.76.208', 'Windows 10', 'Firefox 135.0', '2025-02-19 09:54:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1790, 'New Record inserted On  expenses   id 389', '389', 3, 'Insert', '102.128.76.208', 'Windows 10', 'Firefox 135.0', '2025-02-19 09:55:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1791, 'New Record inserted On  expenses   id 390', '390', 3, 'Insert', '102.128.76.208', 'Windows 10', 'Firefox 135.0', '2025-02-19 09:57:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1792, 'New Record inserted On  Income   id 150', '150', 3, 'Insert', '102.128.76.208', 'Windows 10', 'Firefox 135.0', '2025-02-19 11:34:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1793, 'New Record inserted On  Income   id 151', '151', 3, 'Insert', '102.128.76.208', 'Windows 10', 'Firefox 135.0', '2025-02-19 11:35:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1794, 'New Record inserted On  expenses   id 391', '391', 3, 'Insert', '102.128.79.214', 'Windows 10', 'Firefox 135.0', '2025-02-19 15:12:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1795, 'New Record inserted On  expenses   id 392', '392', 3, 'Insert', '102.128.79.214', 'Windows 10', 'Firefox 135.0', '2025-02-19 15:13:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1796, 'New Record inserted On  expenses   id 393', '393', 3, 'Insert', '102.128.79.214', 'Windows 10', 'Firefox 135.0', '2025-02-19 15:19:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1797, 'New Record inserted On  expenses   id 394', '394', 3, 'Insert', '102.128.79.214', 'Windows 10', 'Firefox 135.0', '2025-02-19 15:25:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1798, 'New Record inserted On  expenses   id 395', '395', 3, 'Insert', '102.128.79.214', 'Windows 10', 'Firefox 135.0', '2025-02-19 15:28:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1799, 'New Record inserted On  expenses   id 396', '396', 3, 'Insert', '102.128.79.214', 'Windows 10', 'Firefox 135.0', '2025-02-19 15:29:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1800, 'New Record inserted On  expenses   id 397', '397', 3, 'Insert', '102.128.79.214', 'Windows 10', 'Firefox 135.0', '2025-02-19 15:30:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1801, 'New Record inserted On  expenses   id 398', '398', 3, 'Insert', '102.128.79.214', 'Windows 10', 'Firefox 135.0', '2025-02-20 09:11:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1802, 'New Record inserted On  expenses   id 399', '399', 3, 'Insert', '102.128.79.214', 'Windows 10', 'Firefox 135.0', '2025-02-20 10:51:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1803, 'New Record inserted On  expenses   id 400', '400', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 14:00:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1804, 'New Record inserted On  expenses   id 401', '401', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 14:03:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1805, 'New Record inserted On  expenses   id 402', '402', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 14:05:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1806, 'New Record inserted On  expenses   id 403', '403', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 14:07:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1807, 'New Record inserted On  expenses   id 404', '404', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 14:10:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1808, 'New Record inserted On  expenses   id 405', '405', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 14:15:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1809, 'New Record inserted On  expenses   id 406', '406', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 14:17:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1810, 'New Record inserted On  expenses   id 407', '407', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 14:20:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1811, 'New Record inserted On  expenses   id 408', '408', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 15:53:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1812, 'New Record inserted On  expenses   id 409', '409', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 15:55:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1813, 'New Record inserted On  expenses   id 410', '410', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 15:57:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1814, 'New Record inserted On  expenses   id 411', '411', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 15:59:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1815, 'New Record inserted On  expenses   id 412', '412', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 16:03:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1816, 'New Record inserted On  expenses   id 413', '413', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:08:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1817, 'New Record inserted On  expenses   id 414', '414', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:11:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1818, 'New Record inserted On  expenses   id 415', '415', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:13:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1819, 'New Record inserted On  expenses   id 416', '416', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:16:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1820, 'New Record inserted On  expenses   id 417', '417', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:17:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1821, 'New Record inserted On  expenses   id 418', '418', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:18:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1822, 'New Record inserted On  expenses   id 419', '419', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:20:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1823, 'New Record inserted On  expenses   id 420', '420', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:23:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1824, 'New Record inserted On  expenses   id 421', '421', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:28:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1825, 'New Record inserted On  expenses   id 422', '422', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 17:30:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1826, 'New Record inserted On  expenses   id 423', '423', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:31:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1827, 'New Record inserted On  expenses   id 424', '424', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:32:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1828, 'New Record inserted On  expense head id 41', '41', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:33:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1829, 'New Record inserted On  expenses   id 425', '425', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:34:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1830, 'New Record inserted On  expenses   id 426', '426', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:35:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1831, 'New Record inserted On  expenses   id 427', '427', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:36:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1832, 'New Record inserted On  expenses   id 428', '428', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:36:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1833, 'New Record inserted On  expenses   id 429', '429', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:37:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1834, 'New Record inserted On  expenses   id 430', '430', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:38:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1835, 'New Record inserted On  expenses   id 431', '431', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:39:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1836, 'New Record inserted On  expenses   id 432', '432', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:40:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1837, 'New Record inserted On  expenses   id 433', '433', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:42:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1838, 'New Record inserted On  expenses   id 434', '434', 3, 'Insert', '102.128.76.246', 'Windows 10', 'Firefox 135.0', '2025-02-20 19:51:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1839, 'New Record inserted On  expenses   id 435', '435', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:05:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1840, 'New Record inserted On  expenses   id 436', '436', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:07:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1841, 'New Record inserted On  expenses   id 437', '437', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:08:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1842, 'New Record inserted On  expenses   id 438', '438', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:09:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1843, 'New Record inserted On  expenses   id 439', '439', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:11:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1844, 'New Record inserted On  expenses   id 440', '440', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:12:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1845, 'New Record inserted On  expenses   id 441', '441', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:13:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1846, 'New Record inserted On  expenses   id 442', '442', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:14:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1847, 'New Record inserted On  expenses   id 443', '443', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:15:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1848, 'New Record inserted On  expenses   id 444', '444', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:15:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1849, 'New Record inserted On  expenses   id 445', '445', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:17:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1850, 'New Record inserted On  expenses   id 446', '446', 3, 'Insert', '102.128.76.162', 'Windows 10', 'Firefox 135.0', '2025-02-20 20:18:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1851, 'New Record inserted On  expenses   id 447', '447', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:02:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1852, 'New Record inserted On  expenses   id 448', '448', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:05:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1853, 'New Record inserted On  expenses   id 449', '449', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:06:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1854, 'New Record inserted On  expenses   id 450', '450', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:26:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1855, 'New Record inserted On exam groups id 1', '1', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:27:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1856, 'Record updated On  exam groups id 1', '1', 2, 'Update', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:27:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1857, 'New Record inserted On vehicles id 1', '1', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:40:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1858, 'New Record inserted On transport route id 1', '1', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:42:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1859, 'New Record inserted On transport route id 2', '2', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:42:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1860, 'Record updated On  transport route id 1', '1', 2, 'Update', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:43:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1861, 'New Record inserted On transport route id 3', '3', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:43:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1862, 'New Record inserted On vehicle routes id 1', '1', 2, 'Insert', '102.128.79.232', 'Windows 10', 'Firefox 135.0', '2025-02-24 17:44:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1863, 'New Record inserted On  expenses   id 451', '451', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:35:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1864, 'New Record inserted On mark_divisions id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:36:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1865, 'Record updated On mark_divisions id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:36:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1866, 'New Record inserted On mark_divisions id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:37:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1867, 'Record updated On mark_divisions id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:38:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1868, 'New Record inserted On  expenses   id 452', '452', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:39:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1869, 'Record updated On mark_divisions id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:41:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1870, 'New Record inserted On mark_divisions id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:42:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1871, 'Record deleted On mark_divisions id 2', '2', 1, 'Delete', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:42:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1872, 'New Record inserted On mark_divisions id 4', '4', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:42:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1873, 'New Record inserted On mark_divisions id 5', '5', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:43:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1874, 'New Record inserted On mark_divisions id 6', '6', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:43:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1875, 'New Record inserted On mark_divisions id 7', '7', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:43:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1876, 'New Record inserted On grades id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:44:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1877, 'New Record inserted On grades id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:45:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1878, 'New Record inserted On grades id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:46:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1879, 'Record updated On grades id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:46:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1880, 'Record updated On grades id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:46:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1881, 'Record updated On grades id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:47:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1882, 'Record updated On grades id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:47:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1883, 'Record updated On grades id 3', '3', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:47:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1884, 'New Record inserted On grades id 4', '4', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:47:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1885, 'New Record inserted On grades id 5', '5', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:48:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1886, 'Record updated On grades id 4', '4', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:48:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1887, 'Record updated On  exam groups id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:49:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1888, 'Record updated On  exam groups id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:49:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1889, 'New Record inserted On exam groups id 2', '2', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:50:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1890, 'New Record inserted On exam groups id 3', '3', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:50:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1891, 'New Record inserted On exam groups id 4', '4', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:51:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1892, 'New Record inserted On exam groups id 5', '5', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:51:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1893, 'New Record inserted On exam groups id 6', '6', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:52:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1894, 'New Record inserted On exam group exams name id 1', '1', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 08:53:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1895, 'New Record inserted On  expenses   id 453', '453', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:01:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1896, 'New Record inserted On admit cards id 2', '2', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:03:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1897, 'Record updated On  admit cards id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:04:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1898, 'New Record inserted On  expenses   id 454', '454', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:04:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1899, 'Record updated On  admit cards id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:06:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1900, 'New Record inserted On exam group exams name id 2', '2', 1, 'Insert', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:09:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1901, 'Record updated On  exam group exams name id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:09:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1902, 'Record updated On  exam group exams name id 1', '1', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1903, 'Record updated On  exam group exams name id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:09:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1904, 'Record updated On  exam group exams name id 2', '2', 1, 'Update', '41.220.16.98', 'Windows 10', 'Firefox 135.0', '2025-02-25 09:12:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1905, 'New Record inserted On  expenses   id 455', '455', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 16:27:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1906, 'New Record inserted On  expenses   id 456', '456', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 16:28:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1907, 'New Record inserted On  expenses   id 457', '457', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 16:30:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1908, 'New Record inserted On  expenses   id 458', '458', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 16:34:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1909, 'New Record inserted On  expenses   id 459', '459', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 16:37:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1910, 'New Record inserted On  expenses   id 460', '460', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-25 16:40:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1911, 'New Record inserted On  expenses   id 461', '461', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-26 07:57:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1912, 'New Record inserted On  expenses   id 462', '462', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-26 08:55:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1913, 'Record deleted On  expenses   id 449', '449', 2, 'Delete', '77.246.55.232', 'Windows 10', 'Firefox 135.0', '2025-02-26 10:06:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1914, 'New Record inserted On vehicles id 2', '2', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-26 10:22:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1915, 'New Record inserted On  expenses   id 463', '463', 2, 'Insert', '77.246.50.114', 'Windows 10', 'Firefox 135.0', '2025-02-26 10:34:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1916, 'Record updated On  expenses   id 463', '463', 2, 'Update', '77.246.50.114', 'Windows 10', 'Firefox 135.0', '2025-02-26 10:34:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1917, 'New Record inserted On  expenses   id 464', '464', 2, 'Insert', '77.246.50.114', 'Windows 10', 'Firefox 135.0', '2025-02-26 10:37:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1918, 'New Record inserted On  expenses   id 465', '465', 2, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-26 13:58:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1919, 'New Record inserted On  expenses   id 466', '466', 2, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-26 14:01:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1920, 'New Record inserted On  expenses   id 467', '467', 2, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-26 14:02:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1921, 'New Record inserted On vehicles id 3', '3', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-26 15:34:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1922, 'New Record inserted On vehicles id 4', '4', 3, 'Insert', '102.128.76.194', 'Windows 10', 'Firefox 135.0', '2025-02-26 15:37:16', NULL);


#
# TABLE STRUCTURE FOR: mark_divisions
#

DROP TABLE IF EXISTS `mark_divisions`;

CREATE TABLE `mark_divisions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `percentage_from` float(10,2) DEFAULT NULL,
  `percentage_to` float(10,2) DEFAULT NULL,
  `is_active` int DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

INSERT INTO `mark_divisions` (`id`, `name`, `percentage_from`, `percentage_to`, `is_active`, `created_at`) VALUES (1, 'U', '0.00', '30.00', 1, '2025-02-25 08:41:55');
INSERT INTO `mark_divisions` (`id`, `name`, `percentage_from`, `percentage_to`, `is_active`, `created_at`) VALUES (3, 'E', '31.00', '39.00', 1, '2025-02-25 08:42:18');
INSERT INTO `mark_divisions` (`id`, `name`, `percentage_from`, `percentage_to`, `is_active`, `created_at`) VALUES (4, 'D', '40.00', '49.00', 1, '2025-02-25 08:42:51');
INSERT INTO `mark_divisions` (`id`, `name`, `percentage_from`, `percentage_to`, `is_active`, `created_at`) VALUES (5, 'C', '50.00', '64.00', 1, '2025-02-25 08:43:05');
INSERT INTO `mark_divisions` (`id`, `name`, `percentage_from`, `percentage_to`, `is_active`, `created_at`) VALUES (6, 'B', '65.00', '74.00', 1, '2025-02-25 08:43:18');
INSERT INTO `mark_divisions` (`id`, `name`, `percentage_from`, `percentage_to`, `is_active`, `created_at`) VALUES (7, 'A', '75.00', '100.00', 1, '2025-02-25 08:43:37');


#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `template_id` varchar(100) DEFAULT NULL,
  `email_template_id` int DEFAULT NULL,
  `sms_template_id` int DEFAULT NULL,
  `send_through` varchar(20) DEFAULT NULL,
  `message` text,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `is_class` int NOT NULL DEFAULT '0',
  `is_schedule` int NOT NULL,
  `sent` int DEFAULT NULL,
  `schedule_date_time` datetime DEFAULT NULL,
  `group_list` text,
  `user_list` text,
  `schedule_class` int DEFAULT NULL,
  `schedule_section` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: notification_roles
#

DROP TABLE IF EXISTS `notification_roles`;

CREATE TABLE `notification_roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `send_notification_id` int DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `send_notification_id` (`send_notification_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `notification_roles_ibfk_1` FOREIGN KEY (`send_notification_id`) REFERENCES `send_notification` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notification_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: notification_setting
#

DROP TABLE IF EXISTS `notification_setting`;

CREATE TABLE `notification_setting` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` varchar(10) DEFAULT '0',
  `is_sms` varchar(10) DEFAULT '0',
  `is_notification` int NOT NULL DEFAULT '0',
  `display_notification` int NOT NULL DEFAULT '0',
  `display_sms` int NOT NULL DEFAULT '1',
  `is_student_recipient` int DEFAULT NULL,
  `is_guardian_recipient` int DEFAULT NULL,
  `is_staff_recipient` int DEFAULT NULL,
  `display_student_recipient` int DEFAULT NULL,
  `display_guardian_recipient` int DEFAULT NULL,
  `display_staff_recipient` int DEFAULT NULL,
  `subject` varchar(255) NOT NULL,
  `template_id` varchar(100) NOT NULL,
  `template` longtext NOT NULL,
  `variables` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3;

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (1, 'student_admission', '1', '0', 0, 0, 1, 1, 1, NULL, 1, 1, NULL, 'Student Admission', '', 'Dear {{student_name}} your admission is confirm in Class: {{class}} Section:  {{section}} for Session: {{current_session_name}} for more \r\ndetail\r\n contact\r\n System\r\n Admin\r\n {{class}} {{section}} {{admission_no}} {{roll_no}} {{admission_date}} {{mobileno}} {{email}} {{dob}} {{guardian_name}} {{guardian_relation}} {{guardian_phone}} {{father_name}} {{father_phone}} {{blood_group}} {{mother_name}} {{gender}} {{guardian_email}}', '{{student_name}} {{class}}  {{section}}  {{admission_no}}  {{roll_no}}  {{admission_date}}   {{mobileno}}  {{email}}  {{dob}}  {{guardian_name}}  {{guardian_relation}}  {{guardian_phone}}  {{father_name}}  {{father_phone}}  {{blood_group}}  {{mother_name}}  {{gender}} {{guardian_email}} {{current_session_name}} ', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (2, 'exam_result', '1', '0', 0, 1, 1, 1, NULL, NULL, 1, 1, NULL, 'Exam Result', '', 'Dear {{student_name}} - {{exam_roll_no}}, your {{exam}} result has been published.', '{{student_name}} {{exam_roll_no}} {{exam}}', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (3, 'fee_submission', '1', '0', 0, 1, 1, 1, 1, NULL, 1, 1, NULL, 'Fee Submission', '', 'Dear parents, we have received Fees Amount {{fee_amount}} for  {{student_name}}  by Your School Name \r\n{{class}} {{section}} {{fine_type}} {{fine_percentage}} {{fine_amount}} {{fee_group_name}} {{type}} {{code}} {{email}} {{contact_no}} {{invoice_id}} {{sub_invoice_id}} {{due_date}} {{amount}} {{fee_amount}}', '{{student_name}} {{class}} {{section}} {{fine_type}} {{fine_percentage}} {{fine_amount}} {{fee_group_name}} {{type}} {{code}} {{email}} {{contact_no}} {{invoice_id}} {{sub_invoice_id}} {{due_date}} {{amount}} {{fee_amount}}', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (4, 'absent_attendence', '1', '0', 0, 1, 1, 1, 1, NULL, 1, 1, NULL, 'Absent Attendence', '', 'Absent Notice :{{student_name}}  was absent on date {{date}} in period {{subject_name}} {{subject_code}} {{subject_type}} from Your School Name', '{{student_name}} {{mobileno}} {{email}} {{father_name}} {{father_phone}} {{father_occupation}} {{mother_name}} {{mother_phone}} {{guardian_name}} {{guardian_phone}} {{guardian_occupation}} {{guardian_email}} {{date}} {{current_session_name}} {{time_from}} {{time_to}} {{subject_name}} {{subject_code}} {{subject_type}}  ', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (6, 'homework', '1', '0', 0, 1, 1, 1, NULL, NULL, 1, 1, NULL, 'Homework', '', 'New Homework has been created for \r\n{{student_name}} at\r\n\r\n\r\n\r\n{{homework_date}} for the class {{class}} {{section}} {{subject}}. kindly submit your\r\n\r\n\r\n homework before {{submit_date}} .Thank you', '{{homework_date}} {{submit_date}} {{class}} {{section}} {{subject}} {{student_name}} {{admission_no}} ', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (7, 'fees_reminder', '1', '0', 0, 1, 1, 1, 1, NULL, 1, 1, NULL, 'Fees Reminder', '', 'Dear parents, please pay fee amount Rs.{{due_amount}} of {{fee_type}} before {{due_date}} for {{student_name}}  from smart school (ignore if you already paid)', '{{fee_type}}{{fee_code}}{{due_date}}{{student_name}}{{school_name}}{{fee_amount}}{{due_amount}}{{deposit_amount}} ', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (8, 'forgot_password', '1', '0', 0, 0, 0, 1, 1, 1, 1, 1, 1, 'Forgot Password', '', 'Dear  {{name}} , \r\n    Recently a request was submitted to reset password for your account. If you didn\'t make the request, just ignore this email. Otherwise you can reset your password using this link <a href=\'{{resetPassLink}}\'>Click here to reset your password</a>,\r\nif you\'re having trouble clicking the password reset button, copy and paste the URL below into your web browser. your username {{username}}\r\n{{resetPassLink}}\r\n Regards,\r\n {{school_name}}', '{{school_name}}{{name}}{{username}}{{resetPassLink}} ', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (9, 'online_examination_publish_exam', '1', '0', 0, 1, 1, 1, NULL, NULL, 1, 1, NULL, 'Online Examination Publish Exam', '', 'A new exam {{exam_title}} has been created for  duration: {{time_duration}} min, which will be available from:  {{exam_from}} to  {{exam_to}}.', '{{exam_title}} {{exam_from}} {{exam_to}} {{time_duration}} {{attempt}} {{passing_percentage}}', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (10, 'online_examination_publish_result', '1', '0', 0, 1, 1, 1, NULL, NULL, 1, 1, NULL, 'Online Examination Publish Result', '', 'Exam {{exam_title}} result has been declared which was conducted between  {{exam_from}} to   {{exam_to}}, for more details, please check your student portal.', '{{exam_title}} {{exam_from}} {{exam_to}} {{time_duration}} {{attempt}} {{passing_percentage}}', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (11, 'online_admission_form_submission', '1', '0', 0, 1, 1, 1, 1, NULL, 1, 1, NULL, 'Online Admission Form Submission', '', 'Dear {{firstname}}  {{lastname}} your online admission form is Submitted successfully  on date {{date}}. Your Reference number is {{reference_no}}. Please remember your reference number for further process.', ' {{firstname}} {{lastname}} {{date}} {{reference_no}}', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (12, 'online_admission_fees_submission', '0', '0', 0, 1, 1, 1, 1, NULL, 1, 1, NULL, 'Online Admission Fees Submission', '', 'Dear {{firstname}}  {{lastname}} your online admission form is Submitted successfully and the payment of {{paid_amount}} has recieved successfully on date {{date}}. Your Reference number is {{reference_no}}. Please remember your reference number for further process.', ' {{firstname}} {{lastname}} {{date}} {{paid_amount}} {{reference_no}}', '2022-12-28 11:52:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (13, 'student_login_credential', '1', '1', 0, 0, 1, 1, 1, 0, 1, 1, NULL, 'Student Login Credential', '1707163291685208209', 'Hello {{display_name}} your login details for Url: {{url}} Username: {{username}}  Password: {{password}} admission No: {{admission_no}}', '{{url}} {{display_name}} {{username}} {{password}} {{admission_no}}', '2022-08-06 07:34:41');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (14, 'staff_login_credential', '1', '1', 0, 0, 1, 0, 0, 1, NULL, NULL, 1, 'Staff Login Credential', '1707163291685208209', 'Hello {{first_name}} {{last_name}} your login details for Url: {{url}} Username: {{username}}  Password: {{password}} Employee ID: {{employee_id}}', '{{url}} {{first_name}} {{last_name}} {{username}} {{password}} {{employee_id}}', '2021-12-23 13:59:13');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (15, 'fee_processing', '1', '1', 1, 1, 1, 1, 1, 0, 1, 1, NULL, 'Fee processing', '1707163291301326898', 'Dear parents, we have received Fees Amount {{fee_amount}} for  {{student_name}}  by Your School Name \r\n{{class}} {{section}} {{email}} {{contact_no}}\r\n\r\n{{student_name}} {{class}} {{section}} {{email}} {{contact_no}} transaction_id :{{transaction_id}} {{fee_amount}}', '{{student_name}} {{class}} {{section}} {{email}} {{contact_no}} {{transaction_id}} {{fee_amount}}', '2021-12-22 12:15:42');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (16, 'online_admission_fees_processing', '1', '1', 1, 1, 1, 1, 1, 0, 1, 1, NULL, 'Online Admission Fees Processing', '', 'Dear {{firstname}}  {{lastname}} your online admission form is Submitted successfully and the payment of {{paid_amount}} has processing on date {{date}}. Your Reference number is {{reference_no}} and your transaction id {{transaction_id}}. Please remember your reference number for further process.', ' {{firstname}} {{lastname}} {{date}} {{paid_amount}} {{reference_no}} {{transaction_id}}', '2022-08-06 13:09:47');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (17, 'student_apply_leave', '1', '1', 0, 0, 1, 0, 1, 1, NULL, 1, 1, 'Student Apply Leave ( {{student_name}} - {{admission_no}} )', '', 'My Name is {{student_name}} Class {{class}} section {{section}}. I have to apply leave on {{apply_date}}and from {{from_date}} to {{to_date}}. {{message}} please provide.', '{{message}} {{apply_date}} {{from_date}} {{to_date}} {{student_name}} {{class}} {{section}}', '2022-03-12 13:58:37');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_notification`, `display_notification`, `display_sms`, `is_student_recipient`, `is_guardian_recipient`, `is_staff_recipient`, `display_student_recipient`, `display_guardian_recipient`, `display_staff_recipient`, `subject`, `template_id`, `template`, `variables`, `created_at`) VALUES (18, 'email_pdf_exam_marksheet', '1', '0', 0, 0, 0, 1, 1, 0, 1, 1, NULL, 'Email PDF Exam Marksheet ( {{student_name}} - {{admission_no}} )', '', 'Dear {{student_name}} ({{admission_no}}) {{class}} Section {{section}}. We have mailed you the marksheet of Exam {{exam}} Roll no.{{roll_no}}', '{{student_name}} {{class}}  {{section}}  {{admission_no}}  {{roll_no}} {{exam}} {{admit_card_roll_no}} ', '2022-03-12 14:24:42');


#
# TABLE STRUCTURE FOR: offline_fees_payments
#

DROP TABLE IF EXISTS `offline_fees_payments`;

CREATE TABLE `offline_fees_payments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(50) DEFAULT NULL,
  `student_session_id` int DEFAULT NULL,
  `student_fees_master_id` int DEFAULT NULL,
  `fee_groups_feetype_id` int DEFAULT NULL,
  `student_transport_fee_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `bank_from` varchar(200) DEFAULT NULL,
  `bank_account_transferred` varchar(200) DEFAULT NULL,
  `reference` varchar(200) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `submit_date` datetime DEFAULT NULL,
  `approve_date` datetime DEFAULT NULL,
  `attachment` text,
  `reply` text,
  `approved_by` int DEFAULT NULL,
  `is_active` varchar(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_fees_master_id` (`student_fees_master_id`),
  KEY `fee_groups_feetype_id` (`fee_groups_feetype_id`),
  KEY `student_transport_fee_id` (`student_transport_fee_id`),
  KEY `offline_fees_payments_ibfk_4` (`approved_by`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `offline_fees_payments_ibfk_1` FOREIGN KEY (`student_fees_master_id`) REFERENCES `student_fees_master` (`id`) ON DELETE CASCADE,
  CONSTRAINT `offline_fees_payments_ibfk_2` FOREIGN KEY (`fee_groups_feetype_id`) REFERENCES `fee_groups_feetype` (`id`) ON DELETE CASCADE,
  CONSTRAINT `offline_fees_payments_ibfk_3` FOREIGN KEY (`student_transport_fee_id`) REFERENCES `student_transport_fees` (`id`) ON DELETE CASCADE,
  CONSTRAINT `offline_fees_payments_ibfk_4` FOREIGN KEY (`approved_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `offline_fees_payments_ibfk_5` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: online_admission_custom_field_value
#

DROP TABLE IF EXISTS `online_admission_custom_field_value`;

CREATE TABLE `online_admission_custom_field_value` (
  `id` int NOT NULL AUTO_INCREMENT,
  `belong_table_id` int DEFAULT NULL,
  `custom_field_id` int DEFAULT NULL,
  `field_value` longtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `idx_belong_table_id` (`belong_table_id`),
  KEY `idx_field_value` (`field_value`(200)),
  CONSTRAINT `online_admission_custom_field_value_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: online_admission_fields
#

DROP TABLE IF EXISTS `online_admission_fields`;

CREATE TABLE `online_admission_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb3;

INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (1, 'middlename', 0, '2021-05-28 12:29:23');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (2, 'lastname', 1, '2021-06-02 06:49:19');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (3, 'category', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (4, 'religion', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (5, 'cast', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (6, 'mobile_no', 1, '2021-06-02 06:50:24');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (7, 'admission_date', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (8, 'student_photo', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (9, 'is_student_house', 0, '2021-05-29 15:22:53');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (10, 'is_blood_group', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (11, 'student_height', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (12, 'student_weight', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (13, 'father_name', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (14, 'father_phone', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (15, 'father_occupation', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (16, 'father_pic', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (17, 'mother_name', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (18, 'mother_phone', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (19, 'mother_occupation', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (20, 'mother_pic', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (21, 'guardian_name', 1, '2021-06-02 06:50:54');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (22, 'guardian_phone', 1, '2021-06-02 06:50:54');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (23, 'if_guardian_is', 1, '2021-06-02 06:50:54');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (24, 'guardian_relation', 1, '2021-06-02 06:50:54');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (25, 'guardian_email', 1, '2021-06-02 06:51:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (26, 'guardian_occupation', 1, '2021-06-02 06:51:26');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (27, 'guardian_address', 1, '2021-06-02 06:51:31');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (28, 'bank_account_no', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (29, 'bank_name', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (30, 'ifsc_code', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (31, 'national_identification_no', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (32, 'local_identification_no', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (33, 'rte', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (34, 'previous_school_details', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (35, 'guardian_photo', 1, '2021-06-02 06:51:29');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (36, 'student_note', 0, '2021-06-02 06:55:08');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (37, 'measurement_date', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (38, 'student_email', 1, '2021-06-02 06:49:38');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (39, 'current_address', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (40, 'permanent_address', 0, '2021-06-02 06:48:35');
INSERT INTO `online_admission_fields` (`id`, `name`, `status`, `created_at`) VALUES (41, 'upload_documents', 1, '2022-09-20 10:00:32');


#
# TABLE STRUCTURE FOR: online_admission_payment
#

DROP TABLE IF EXISTS `online_admission_payment`;

CREATE TABLE `online_admission_payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `online_admission_id` int NOT NULL,
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) NOT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(100) NOT NULL,
  `note` varchar(100) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `online_admission_id` (`online_admission_id`),
  CONSTRAINT `online_admission_payment_ibfk_1` FOREIGN KEY (`online_admission_id`) REFERENCES `online_admissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: online_admissions
#

DROP TABLE IF EXISTS `online_admissions`;

CREATE TABLE `online_admissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `admission_no` varchar(100) DEFAULT NULL,
  `roll_no` varchar(100) DEFAULT NULL,
  `reference_no` varchar(50) NOT NULL,
  `admission_date` date DEFAULT NULL,
  `firstname` varchar(100) DEFAULT NULL,
  `middlename` varchar(255) NOT NULL,
  `lastname` varchar(100) DEFAULT NULL,
  `rte` varchar(20) NOT NULL DEFAULT 'No',
  `image` varchar(255) DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `pincode` varchar(100) DEFAULT NULL,
  `religion` varchar(100) DEFAULT NULL,
  `cast` varchar(50) NOT NULL,
  `dob` date DEFAULT NULL,
  `gender` varchar(100) DEFAULT NULL,
  `current_address` text,
  `permanent_address` text,
  `category_id` int DEFAULT NULL,
  `class_section_id` int DEFAULT NULL,
  `route_id` int NOT NULL,
  `school_house_id` int DEFAULT NULL,
  `blood_group` varchar(200) NOT NULL,
  `vehroute_id` int NOT NULL,
  `hostel_room_id` int DEFAULT NULL,
  `adhar_no` varchar(100) DEFAULT NULL,
  `samagra_id` varchar(100) DEFAULT NULL,
  `bank_account_no` varchar(100) DEFAULT NULL,
  `bank_name` varchar(100) DEFAULT NULL,
  `ifsc_code` varchar(100) DEFAULT NULL,
  `guardian_is` varchar(100) NOT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `father_phone` varchar(100) DEFAULT NULL,
  `father_occupation` varchar(100) DEFAULT NULL,
  `mother_name` varchar(100) DEFAULT NULL,
  `mother_phone` varchar(100) DEFAULT NULL,
  `mother_occupation` varchar(100) DEFAULT NULL,
  `guardian_name` varchar(100) DEFAULT NULL,
  `guardian_relation` varchar(100) DEFAULT NULL,
  `guardian_phone` varchar(100) DEFAULT NULL,
  `guardian_occupation` varchar(150) NOT NULL,
  `guardian_address` text,
  `guardian_email` varchar(100) NOT NULL,
  `father_pic` varchar(255) NOT NULL,
  `mother_pic` varchar(255) NOT NULL,
  `guardian_pic` varchar(255) NOT NULL,
  `is_enroll` int DEFAULT '0',
  `previous_school` text,
  `height` varchar(100) NOT NULL,
  `weight` varchar(100) NOT NULL,
  `note` text NOT NULL,
  `form_status` int NOT NULL,
  `paid_status` int NOT NULL,
  `measurement_date` date DEFAULT NULL,
  `app_key` text,
  `document` text,
  `submit_date` date DEFAULT NULL,
  `disable_at` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `class_section_id` (`class_section_id`),
  KEY `category_id` (`category_id`),
  KEY `hostel_room_id` (`hostel_room_id`),
  KEY `school_house_id` (`school_house_id`),
  KEY `idx_reference_no` (`reference_no`),
  KEY `idx_mobileno` (`mobileno`),
  CONSTRAINT `online_admissions_ibfk_1` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `online_admissions_ibfk_2` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `online_admissions_ibfk_3` FOREIGN KEY (`hostel_room_id`) REFERENCES `hostel_rooms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `online_admissions_ibfk_4` FOREIGN KEY (`school_house_id`) REFERENCES `school_houses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: onlineexam
#

DROP TABLE IF EXISTS `onlineexam`;

CREATE TABLE `onlineexam` (
  `id` int NOT NULL AUTO_INCREMENT,
  `session_id` int DEFAULT NULL,
  `exam` text,
  `attempt` int NOT NULL,
  `exam_from` datetime DEFAULT NULL,
  `exam_to` datetime DEFAULT NULL,
  `is_quiz` int NOT NULL DEFAULT '0',
  `auto_publish_date` datetime DEFAULT NULL,
  `time_from` time DEFAULT NULL,
  `time_to` time DEFAULT NULL,
  `duration` time NOT NULL,
  `passing_percentage` float NOT NULL DEFAULT '0',
  `description` text,
  `publish_result` int NOT NULL DEFAULT '0',
  `answer_word_count` int NOT NULL DEFAULT '-1',
  `is_active` varchar(1) DEFAULT '0',
  `is_marks_display` int NOT NULL DEFAULT '0',
  `is_neg_marking` int NOT NULL DEFAULT '0',
  `is_random_question` int NOT NULL DEFAULT '0',
  `is_rank_generated` int NOT NULL DEFAULT '0',
  `publish_exam_notification` int NOT NULL,
  `publish_result_notification` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `onlineexam_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: onlineexam_attempts
#

DROP TABLE IF EXISTS `onlineexam_attempts`;

CREATE TABLE `onlineexam_attempts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `onlineexam_student_id` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `onlineexam_student_id` (`onlineexam_student_id`),
  CONSTRAINT `onlineexam_attempts_ibfk_1` FOREIGN KEY (`onlineexam_student_id`) REFERENCES `onlineexam_students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: onlineexam_questions
#

DROP TABLE IF EXISTS `onlineexam_questions`;

CREATE TABLE `onlineexam_questions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `question_id` int DEFAULT NULL,
  `onlineexam_id` int DEFAULT NULL,
  `session_id` int DEFAULT NULL,
  `marks` float(10,2) NOT NULL DEFAULT '0.00',
  `neg_marks` float(10,2) DEFAULT '0.00',
  `is_active` varchar(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `onlineexam_id` (`onlineexam_id`),
  KEY `question_id` (`question_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `onlineexam_questions_ibfk_1` FOREIGN KEY (`onlineexam_id`) REFERENCES `onlineexam` (`id`) ON DELETE CASCADE,
  CONSTRAINT `onlineexam_questions_ibfk_2` FOREIGN KEY (`question_id`) REFERENCES `questions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `onlineexam_questions_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: onlineexam_student_results
#

DROP TABLE IF EXISTS `onlineexam_student_results`;

CREATE TABLE `onlineexam_student_results` (
  `id` int NOT NULL AUTO_INCREMENT,
  `onlineexam_student_id` int NOT NULL,
  `onlineexam_question_id` int NOT NULL,
  `select_option` longtext,
  `marks` float(10,2) NOT NULL DEFAULT '0.00',
  `remark` text,
  `attachment_name` text,
  `attachment_upload_name` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `onlineexam_student_id` (`onlineexam_student_id`),
  KEY `onlineexam_question_id` (`onlineexam_question_id`),
  CONSTRAINT `onlineexam_student_results_ibfk_1` FOREIGN KEY (`onlineexam_student_id`) REFERENCES `onlineexam_students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `onlineexam_student_results_ibfk_2` FOREIGN KEY (`onlineexam_question_id`) REFERENCES `onlineexam_questions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: onlineexam_students
#

DROP TABLE IF EXISTS `onlineexam_students`;

CREATE TABLE `onlineexam_students` (
  `id` int NOT NULL AUTO_INCREMENT,
  `onlineexam_id` int DEFAULT NULL,
  `student_session_id` int DEFAULT NULL,
  `is_attempted` int NOT NULL DEFAULT '0',
  `rank` int DEFAULT '0',
  `quiz_attempted` int NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `onlineexam_id` (`onlineexam_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `onlineexam_students_ibfk_1` FOREIGN KEY (`onlineexam_id`) REFERENCES `onlineexam` (`id`) ON DELETE CASCADE,
  CONSTRAINT `onlineexam_students_ibfk_2` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: payment_settings
#

DROP TABLE IF EXISTS `payment_settings`;

CREATE TABLE `payment_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(200) NOT NULL,
  `api_username` varchar(200) DEFAULT NULL,
  `api_secret_key` varchar(200) NOT NULL,
  `salt` varchar(200) NOT NULL,
  `api_publishable_key` varchar(200) NOT NULL,
  `api_password` varchar(200) DEFAULT NULL,
  `api_signature` varchar(200) DEFAULT NULL,
  `api_email` varchar(200) DEFAULT NULL,
  `paypal_demo` varchar(100) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `gateway_mode` int NOT NULL COMMENT '0 Testing, 1 live',
  `paytm_website` varchar(255) NOT NULL,
  `paytm_industrytype` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: payslip_allowance
#

DROP TABLE IF EXISTS `payslip_allowance`;

CREATE TABLE `payslip_allowance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `payslip_id` int NOT NULL,
  `allowance_type` varchar(200) NOT NULL,
  `amount` float NOT NULL,
  `staff_id` int NOT NULL,
  `cal_type` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `payslip_id` (`payslip_id`),
  CONSTRAINT `payslip_allowance_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `payslip_allowance_ibfk_2` FOREIGN KEY (`payslip_id`) REFERENCES `staff_payslip` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3;

INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (3, 2, '', '0', 4, 'positive');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (4, 2, '', '0', 4, 'negative');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (5, 3, '', '0', 5, 'positive');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (6, 3, '', '0', 5, 'negative');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (7, 4, '', '0', 6, 'positive');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (8, 4, '', '0', 6, 'negative');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (9, 5, '', '0', 7, 'positive');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (10, 5, '', '0', 7, 'negative');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (11, 6, '', '0', 8, 'positive');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (12, 6, '', '0', 8, 'negative');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (13, 7, '', '0', 10, 'positive');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (14, 7, '', '0', 10, 'negative');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (15, 8, '', '0', 9, 'positive');
INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES (16, 8, '', '0', 9, 'negative');


#
# TABLE STRUCTURE FOR: permission_category
#

DROP TABLE IF EXISTS `permission_category`;

CREATE TABLE `permission_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `perm_group_id` int DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) DEFAULT NULL,
  `enable_view` int DEFAULT '0',
  `enable_add` int DEFAULT '0',
  `enable_edit` int DEFAULT '0',
  `enable_delete` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_short_code` (`short_code`),
  KEY `perm_group_id` (`perm_group_id`),
  CONSTRAINT `permission_category_ibfk_1` FOREIGN KEY (`perm_group_id`) REFERENCES `permission_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=274 DEFAULT CHARSET=utf8mb3;

INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (1, 1, 'Student', 'student', 1, 1, 1, 1, '2019-10-24 07:42:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (2, 1, 'Import Student', 'import_student', 1, 0, 0, 0, '2018-06-22 12:17:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (3, 1, 'Student Categories', 'student_categories', 1, 1, 1, 1, '2018-06-22 12:17:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (4, 1, 'Student Houses', 'student_houses', 1, 1, 1, 1, '2018-06-22 12:17:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (5, 2, 'Collect Fees', 'collect_fees', 1, 1, 0, 1, '2018-06-22 12:21:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (6, 2, 'Fees Carry Forward', 'fees_carry_forward', 1, 0, 0, 0, '2018-06-27 02:18:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (7, 2, 'Fees Master', 'fees_master', 1, 1, 1, 1, '2018-06-27 02:18:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (8, 2, 'Fees Group', 'fees_group', 1, 1, 1, 1, '2018-06-22 12:21:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (9, 3, 'Income', 'income', 1, 1, 1, 1, '2018-06-22 12:23:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (10, 3, 'Income Head', 'income_head', 1, 1, 1, 1, '2018-06-22 12:22:44');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (11, 3, 'Search Income', 'search_income', 1, 0, 0, 0, '2018-06-22 12:23:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (12, 4, 'Expense', 'expense', 1, 1, 1, 1, '2018-06-22 12:24:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (13, 4, 'Expense Head', 'expense_head', 1, 1, 1, 1, '2018-06-22 12:23:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (14, 4, 'Search Expense', 'search_expense', 1, 0, 0, 0, '2018-06-22 12:24:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (15, 5, 'Student / Period Attendance', 'student_attendance', 1, 1, 1, 0, '2019-11-29 03:19:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (20, 6, 'Marks Grade', 'marks_grade', 1, 1, 1, 1, '2018-06-22 12:25:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (21, 7, 'Class Timetable', 'class_timetable', 1, 0, 1, 0, '2019-11-24 05:05:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (23, 7, 'Subject', 'subject', 1, 1, 1, 1, '2018-06-22 12:32:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (24, 7, 'Class', 'class', 1, 1, 1, 1, '2018-06-22 12:32:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (25, 7, 'Section', 'section', 1, 1, 1, 1, '2018-06-22 12:31:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (26, 7, 'Promote Student', 'promote_student', 1, 0, 0, 0, '2018-06-22 12:32:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (27, 8, 'Upload Content', 'upload_content', 1, 1, 0, 1, '2018-06-22 12:33:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (28, 9, 'Books List', 'books', 1, 1, 1, 1, '2019-11-24 02:37:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (29, 9, 'Issue Return', 'issue_return', 1, 0, 0, 0, '2019-11-24 02:37:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (30, 9, 'Add Staff Member', 'add_staff_member', 1, 0, 0, 0, '2018-07-02 13:37:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (31, 10, 'Issue Item', 'issue_item', 1, 1, 1, 1, '2019-11-29 08:39:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (32, 10, 'Add Item Stock', 'item_stock', 1, 1, 1, 1, '2019-11-24 02:39:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (33, 10, 'Add Item', 'item', 1, 1, 1, 1, '2019-11-24 02:39:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (34, 10, 'Item Store', 'store', 1, 1, 1, 1, '2019-11-24 02:40:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (35, 10, 'Item Supplier', 'supplier', 1, 1, 1, 1, '2019-11-24 02:40:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (37, 11, 'Routes', 'routes', 1, 1, 1, 1, '2018-06-22 12:39:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (38, 11, 'Vehicle', 'vehicle', 1, 1, 1, 1, '2018-06-22 12:39:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (39, 11, 'Assign Vehicle', 'assign_vehicle', 1, 1, 1, 1, '2018-06-27 06:39:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (40, 12, 'Hostel', 'hostel', 1, 1, 1, 1, '2018-06-22 12:40:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (41, 12, 'Room Type', 'room_type', 1, 1, 1, 1, '2018-06-22 12:40:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (42, 12, 'Hostel Rooms', 'hostel_rooms', 1, 1, 1, 1, '2018-06-25 08:23:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (43, 13, 'Notice Board', 'notice_board', 1, 1, 1, 1, '2018-06-22 12:41:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (44, 13, 'Email', 'email', 1, 0, 0, 0, '2019-11-26 07:20:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (46, 13, 'Email / SMS Log', 'email_sms_log', 1, 0, 0, 0, '2018-06-22 12:41:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (53, 15, 'Languages', 'languages', 0, 1, 0, 1, '2021-01-23 09:09:32');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (54, 15, 'General Setting', 'general_setting', 1, 0, 1, 0, '2018-07-05 11:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (55, 15, 'Session Setting', 'session_setting', 1, 1, 1, 1, '2018-06-22 12:44:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (56, 15, 'Notification Setting', 'notification_setting', 1, 0, 1, 0, '2018-07-05 11:08:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (57, 15, 'SMS Setting', 'sms_setting', 1, 0, 1, 0, '2018-07-05 11:08:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (58, 15, 'Email Setting', 'email_setting', 1, 0, 1, 0, '2018-07-05 11:08:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (59, 15, 'Front CMS Setting', 'front_cms_setting', 1, 0, 1, 0, '2018-07-05 11:08:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (60, 15, 'Payment Methods', 'payment_methods', 1, 0, 1, 0, '2018-07-05 11:08:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (61, 16, 'Menus', 'menus', 1, 1, 0, 1, '2018-07-09 05:50:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (62, 16, 'Media Manager', 'media_manager', 1, 1, 0, 1, '2018-07-09 05:50:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (63, 16, 'Banner Images', 'banner_images', 1, 1, 0, 1, '2018-06-22 12:46:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (64, 16, 'Pages', 'pages', 1, 1, 1, 1, '2018-06-22 12:46:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (65, 16, 'Gallery', 'gallery', 1, 1, 1, 1, '2018-06-22 12:47:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (66, 16, 'Event', 'event', 1, 1, 1, 1, '2018-06-22 12:47:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (67, 16, 'News', 'notice', 1, 1, 1, 1, '2018-07-03 10:39:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (68, 2, 'Fees Group Assign', 'fees_group_assign', 1, 0, 0, 0, '2018-06-22 12:20:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (69, 2, 'Fees Type', 'fees_type', 1, 1, 1, 1, '2018-06-22 12:19:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (70, 2, 'Fees Discount', 'fees_discount', 1, 1, 1, 1, '2018-06-22 12:20:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (71, 2, 'Fees Discount Assign', 'fees_discount_assign', 1, 0, 0, 0, '2018-06-22 12:20:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (73, 2, 'Search Fees Payment', 'search_fees_payment', 1, 0, 0, 0, '2018-06-22 12:20:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (74, 2, 'Search Due Fees', 'search_due_fees', 1, 0, 0, 0, '2018-06-22 12:20:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (77, 7, 'Assign Class Teacher', 'assign_class_teacher', 1, 1, 1, 1, '2018-06-22 12:30:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (78, 17, 'Admission Enquiry', 'admission_enquiry', 1, 1, 1, 1, '2018-06-22 12:51:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (79, 17, 'Follow Up Admission Enquiry', 'follow_up_admission_enquiry', 1, 1, 0, 1, '2018-06-22 12:51:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (80, 17, 'Visitor Book', 'visitor_book', 1, 1, 1, 1, '2018-06-22 12:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (81, 17, 'Phone Call Log', 'phone_call_log', 1, 1, 1, 1, '2018-06-22 12:50:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (82, 17, 'Postal Dispatch', 'postal_dispatch', 1, 1, 1, 1, '2018-06-22 12:50:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (83, 17, 'Postal Receive', 'postal_receive', 1, 1, 1, 1, '2018-06-22 12:50:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (84, 17, 'Complain', 'complaint', 1, 1, 1, 1, '2018-07-03 10:40:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (85, 17, 'Setup Font Office', 'setup_font_office', 1, 1, 1, 1, '2018-06-22 12:49:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (86, 18, 'Staff', 'staff', 1, 1, 1, 1, '2018-06-22 12:53:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (87, 18, 'Disable Staff', 'disable_staff', 1, 0, 0, 0, '2018-06-22 12:53:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (88, 18, 'Staff Attendance', 'staff_attendance', 1, 1, 1, 0, '2018-06-22 12:53:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (90, 18, 'Staff Payroll', 'staff_payroll', 1, 1, 0, 1, '2018-06-22 12:52:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (93, 19, 'Homework', 'homework', 1, 1, 1, 1, '2018-06-22 12:53:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (94, 19, 'Homework Evaluation', 'homework_evaluation', 1, 1, 0, 0, '2018-06-27 05:07:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (96, 20, 'Student Certificate', 'student_certificate', 1, 1, 1, 1, '2018-07-06 12:41:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (97, 20, 'Generate Certificate', 'generate_certificate', 1, 0, 0, 0, '2018-07-06 12:37:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (98, 20, 'Student ID Card', 'student_id_card', 1, 1, 1, 1, '2018-07-06 12:41:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (99, 20, 'Generate ID Card', 'generate_id_card', 1, 0, 0, 0, '2018-07-06 12:41:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (102, 21, 'Calendar To Do List', 'calendar_to_do_list', 1, 1, 1, 1, '2018-06-22 12:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (104, 10, 'Item Category', 'item_category', 1, 1, 1, 1, '2018-06-22 12:34:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (106, 22, 'Quick Session Change', 'quick_session_change', 1, 0, 0, 0, '2018-06-22 12:54:45');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (107, 1, 'Disable Student', 'disable_student', 1, 0, 0, 0, '2018-06-25 08:21:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (108, 18, ' Approve Leave Request', 'approve_leave_request', 1, 0, 1, 1, '2020-10-05 10:56:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (109, 18, 'Apply Leave', 'apply_leave', 1, 1, 0, 0, '2019-11-29 01:47:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (110, 18, 'Leave Types ', 'leave_types', 1, 1, 1, 1, '2018-07-02 12:17:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (111, 18, 'Department', 'department', 1, 1, 1, 1, '2018-06-26 05:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (112, 18, 'Designation', 'designation', 1, 1, 1, 1, '2018-06-26 05:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (113, 22, 'Fees Collection And Expense Monthly Chart', 'fees_collection_and_expense_monthly_chart', 1, 0, 0, 0, '2018-07-03 09:08:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (114, 22, 'Fees Collection And Expense Yearly Chart', 'fees_collection_and_expense_yearly_chart', 1, 0, 0, 0, '2018-07-03 09:08:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (115, 22, 'Monthly Fees Collection Widget', 'Monthly fees_collection_widget', 1, 0, 0, 0, '2018-07-03 09:13:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (116, 22, 'Monthly Expense Widget', 'monthly_expense_widget', 1, 0, 0, 0, '2018-07-03 09:13:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (117, 22, 'Student Count Widget', 'student_count_widget', 1, 0, 0, 0, '2018-07-03 09:13:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (118, 22, 'Staff Role Count Widget', 'staff_role_count_widget', 1, 0, 0, 0, '2018-07-03 09:13:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (122, 5, 'Attendance By Date', 'attendance_by_date', 1, 0, 0, 0, '2018-07-03 10:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (123, 9, 'Add Student', 'add_student', 1, 0, 0, 0, '2018-07-03 10:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (126, 15, 'User Status', 'user_status', 1, 0, 0, 0, '2018-07-03 10:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (127, 18, 'Can See Other Users Profile', 'can_see_other_users_profile', 1, 0, 0, 0, '2018-07-03 10:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (128, 1, 'Student Timeline', 'student_timeline', 1, 1, 1, 1, '2022-12-28 11:52:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (129, 18, 'Staff Timeline', 'staff_timeline', 1, 1, 1, 1, '2022-12-28 11:52:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (130, 15, 'Backup', 'backup', 1, 1, 0, 1, '2018-07-09 06:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (131, 15, 'Restore', 'restore', 1, 0, 0, 0, '2018-07-09 06:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (134, 1, 'Disable Reason', 'disable_reason', 1, 1, 1, 1, '2019-11-27 08:39:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (135, 2, 'Fees Reminder', 'fees_reminder', 1, 0, 1, 0, '2019-10-25 02:39:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (136, 5, 'Approve Leave', 'approve_leave', 1, 1, 1, 1, '2022-12-28 11:52:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (137, 6, 'Exam Group', 'exam_group', 1, 1, 1, 1, '2019-10-25 03:02:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (141, 6, 'Design Admit Card', 'design_admit_card', 1, 1, 1, 1, '2019-10-25 03:06:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (142, 6, 'Print Admit Card', 'print_admit_card', 1, 0, 0, 0, '2019-11-24 01:57:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (143, 6, 'Design Marksheet', 'design_marksheet', 1, 1, 1, 1, '2019-10-25 03:10:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (144, 6, 'Print Marksheet', 'print_marksheet', 1, 0, 0, 0, '2019-10-25 03:11:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (145, 7, 'Teachers Timetable', 'teachers_time_table', 1, 0, 0, 0, '2019-11-30 04:52:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (146, 14, 'Student Report', 'student_report', 1, 0, 0, 0, '2019-10-25 03:27:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (147, 14, 'Guardian Report', 'guardian_report', 1, 0, 0, 0, '2019-10-25 03:30:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (148, 14, 'Student History', 'student_history', 1, 0, 0, 0, '2019-10-25 03:39:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (149, 14, 'Student Login Credential Report', 'student_login_credential_report', 1, 0, 0, 0, '2019-10-25 03:39:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (150, 14, 'Class Subject Report', 'class_subject_report', 1, 0, 0, 0, '2019-10-25 03:39:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (151, 14, 'Admission Report', 'admission_report', 1, 0, 0, 0, '2019-10-25 03:39:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (152, 14, 'Sibling Report', 'sibling_report', 1, 0, 0, 0, '2019-10-25 03:39:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (153, 14, 'Homework Evaluation Report', 'homehork_evaluation_report', 1, 0, 0, 0, '2019-11-24 03:04:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (154, 14, 'Student Profile', 'student_profile', 1, 0, 0, 0, '2019-10-25 03:39:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (155, 14, 'Fees Statement', 'fees_statement', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (156, 14, 'Balance Fees Report', 'balance_fees_report', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (157, 14, 'Fees Collection Report', 'fees_collection_report', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (158, 14, 'Online Fees Collection Report', 'online_fees_collection_report', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (159, 14, 'Income Report', 'income_report', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (160, 14, 'Expense Report', 'expense_report', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (161, 14, 'PayRoll Report', 'payroll_report', 1, 0, 0, 0, '2019-10-31 02:23:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (162, 14, 'Income Group Report', 'income_group_report', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (163, 14, 'Expense Group Report', 'expense_group_report', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (164, 14, 'Attendance Report', 'attendance_report', 1, 0, 0, 0, '2019-10-25 04:08:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (165, 14, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2019-10-25 04:08:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (174, 14, 'Transport Report', 'transport_report', 1, 0, 0, 0, '2019-10-25 04:13:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (175, 14, 'Hostel Report', 'hostel_report', 1, 0, 0, 0, '2019-11-27 08:51:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (176, 14, 'Audit Trail Report', 'audit_trail_report', 1, 0, 0, 0, '2019-10-25 04:16:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (177, 14, 'User Log', 'user_log', 1, 0, 0, 0, '2019-10-25 04:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (178, 14, 'Book Issue Report', 'book_issue_report', 1, 0, 0, 0, '2019-10-25 04:29:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (179, 14, 'Book Due Report', 'book_due_report', 1, 0, 0, 0, '2019-10-25 04:29:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (180, 14, 'Book Inventory Report', 'book_inventory_report', 1, 0, 0, 0, '2019-10-25 04:29:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (181, 14, 'Stock Report', 'stock_report', 1, 0, 0, 0, '2019-10-25 04:31:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (182, 14, 'Add Item Report', 'add_item_report', 1, 0, 0, 0, '2019-10-25 04:31:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (183, 14, 'Issue Item Report', 'issue_item_report', 1, 0, 0, 0, '2019-11-29 05:48:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (185, 23, 'Online Examination', 'online_examination', 1, 1, 1, 1, '2019-11-24 01:54:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (186, 23, 'Question Bank', 'question_bank', 1, 1, 1, 1, '2019-11-24 01:55:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (187, 6, 'Exam Result', 'exam_result', 1, 0, 0, 0, '2019-11-24 01:58:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (188, 7, 'Subject Group', 'subject_group', 1, 1, 1, 1, '2019-11-24 02:34:32');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (189, 18, 'Teachers Rating', 'teachers_rating', 1, 0, 1, 1, '2019-11-24 05:12:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (190, 22, 'Fees Awaiting Payment Widegts', 'fees_awaiting_payment_widegts', 1, 0, 0, 0, '2019-11-24 02:52:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (191, 22, 'Conveted Leads Widegts', 'conveted_leads_widegts', 1, 0, 0, 0, '2019-11-24 02:58:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (192, 22, 'Fees Overview Widegts', 'fees_overview_widegts', 1, 0, 0, 0, '2019-11-24 02:57:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (193, 22, 'Enquiry Overview Widegts', 'enquiry_overview_widegts', 1, 0, 0, 0, '2019-12-02 07:06:09');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (194, 22, 'Library Overview Widegts', 'book_overview_widegts', 1, 0, 0, 0, '2019-12-01 03:13:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (195, 22, 'Student Today Attendance Widegts', 'today_attendance_widegts', 1, 0, 0, 0, '2019-12-03 06:57:45');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (196, 6, 'Marks Import', 'marks_import', 1, 0, 0, 0, '2019-11-24 03:02:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (197, 14, 'Student Attendance Type Report', 'student_attendance_type_report', 1, 0, 0, 0, '2019-11-24 03:06:32');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (198, 14, 'Exam Marks Report', 'exam_marks_report', 1, 0, 0, 0, '2019-11-24 03:11:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (200, 14, 'Online Exam Wise Report', 'online_exam_wise_report', 1, 0, 0, 0, '2019-11-24 03:18:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (201, 14, 'Online Exams Report', 'online_exams_report', 1, 0, 0, 0, '2019-11-29 04:48:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (202, 14, 'Online Exams Attempt Report', 'online_exams_attempt_report', 1, 0, 0, 0, '2019-11-29 04:46:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (203, 14, 'Online Exams Rank Report', 'online_exams_rank_report', 1, 0, 0, 0, '2019-11-24 03:22:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (204, 14, 'Staff Report', 'staff_report', 1, 0, 0, 0, '2019-11-24 03:25:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (205, 6, 'Exam', 'exam', 1, 1, 1, 1, '2019-11-24 06:55:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (207, 6, 'Exam Publish', 'exam_publish', 1, 0, 0, 0, '2019-11-24 07:15:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (208, 6, 'Link Exam', 'link_exam', 1, 0, 1, 0, '2019-11-24 07:15:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (210, 6, 'Assign / View student', 'exam_assign_view_student', 1, 0, 1, 0, '2019-11-24 07:15:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (211, 6, 'Exam Subject', 'exam_subject', 1, 0, 1, 0, '2019-11-24 07:15:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (212, 6, 'Exam Marks', 'exam_marks', 1, 0, 1, 0, '2019-11-24 07:15:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (213, 15, 'Language Switcher', 'language_switcher', 1, 0, 0, 0, '2019-11-24 07:17:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (214, 23, 'Add Questions in Exam ', 'add_questions_in_exam', 1, 0, 1, 0, '2019-11-28 03:38:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (215, 15, 'Custom Fields', 'custom_fields', 1, 0, 0, 0, '2019-11-29 06:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (216, 15, 'System Fields', 'system_fields', 1, 0, 0, 0, '2019-11-25 02:15:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (217, 13, 'SMS', 'sms', 1, 0, 0, 0, '2018-06-22 12:40:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (219, 14, 'Student / Period Attendance Report', 'student_period_attendance_report', 1, 0, 0, 0, '2019-11-29 04:19:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (220, 14, 'Biometric Attendance Log', 'biometric_attendance_log', 1, 0, 0, 0, '2019-11-27 07:59:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (221, 14, 'Book Issue Return Report', 'book_issue_return_report', 1, 0, 0, 0, '2019-11-27 08:30:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (222, 23, 'Assign / View Student', 'online_assign_view_student', 1, 0, 1, 0, '2019-11-28 06:20:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (223, 14, 'Rank Report', 'rank_report', 1, 0, 0, 0, '2019-11-29 04:30:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (224, 25, 'Chat', 'chat', 1, 0, 0, 0, '2019-11-29 06:10:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (226, 22, 'Income Donut Graph', 'income_donut_graph', 1, 0, 0, 0, '2019-11-29 07:00:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (227, 22, 'Expense Donut Graph', 'expense_donut_graph', 1, 0, 0, 0, '2019-11-29 07:01:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (228, 9, 'Import Book', 'import_book', 1, 0, 0, 0, '2019-11-29 08:21:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (229, 22, 'Staff Present Today Widegts', 'staff_present_today_widegts', 1, 0, 0, 0, '2019-11-29 08:48:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (230, 22, 'Student Present Today Widegts', 'student_present_today_widegts', 1, 0, 0, 0, '2019-11-29 08:47:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (231, 26, 'Multi Class Student', 'multi_class_student', 1, 1, 1, 1, '2020-10-05 10:56:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (232, 27, 'Online Admission', 'online_admission', 1, 0, 1, 1, '2019-12-02 08:11:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (233, 15, 'Print Header Footer', 'print_header_footer', 1, 0, 0, 0, '2020-02-12 04:02:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (234, 28, 'Manage Alumni', 'manage_alumni', 1, 1, 1, 1, '2020-06-02 05:15:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (235, 28, 'Events', 'events', 1, 1, 1, 1, '2020-05-28 23:48:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (236, 29, 'Manage Lesson Plan', 'manage_lesson_plan', 1, 1, 1, 0, '2020-05-29 00:17:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (237, 29, 'Manage Syllabus Status', 'manage_syllabus_status', 1, 0, 1, 0, '2020-05-29 00:20:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (238, 29, 'Lesson', 'lesson', 1, 1, 1, 1, '2020-05-29 00:20:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (239, 29, 'Topic', 'topic', 1, 1, 1, 1, '2020-05-29 00:20:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (240, 14, 'Syllabus Status Report', 'syllabus_status_report', 1, 0, 0, 0, '2020-05-29 01:17:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (241, 14, 'Teacher Syllabus Status Report', 'teacher_syllabus_status_report', 1, 0, 0, 0, '2020-05-29 01:17:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (242, 14, 'Alumni Report', 'alumni_report', 1, 0, 0, 0, '2020-06-08 01:59:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (243, 15, 'Student Profile Update', 'student_profile_update', 1, 0, 0, 0, '2020-08-21 07:36:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (244, 14, 'Student Gender Ratio Report', 'student_gender_ratio_report', 1, 0, 0, 0, '2020-08-22 14:37:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (245, 14, 'Student Teacher Ratio Report', 'student_teacher_ratio_report', 1, 0, 0, 0, '2020-08-22 14:42:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (246, 14, 'Daily Attendance Report', 'daily_attendance_report', 1, 0, 0, 0, '2020-08-22 14:43:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (247, 23, 'Import Question', 'import_question', 1, 0, 0, 0, '2019-11-23 20:25:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (248, 20, 'Staff ID Card', 'staff_id_card', 1, 1, 1, 1, '2018-07-06 12:41:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (249, 20, 'Generate Staff ID Card', 'generate_staff_id_card', 1, 0, 0, 0, '2018-07-06 12:41:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (250, 19, 'Daily Assignment', 'daily_assignment', 1, 0, 0, 0, '2022-03-02 09:28:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (251, 6, 'Marks Division', 'marks_division', 1, 1, 1, 1, '2022-07-01 17:24:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (252, 13, 'Schedule Email SMS Log', 'schedule_email_sms_log', 1, 0, 1, 0, '2022-07-09 13:25:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (253, 13, 'Login Credentials Send', 'login_credentials_send', 1, 0, 0, 0, '2022-07-01 17:46:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (254, 13, 'Email Template', 'email_template', 1, 1, 1, 1, '2022-07-01 17:46:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (255, 13, 'SMS Template', 'sms_template', 1, 1, 1, 1, '2022-07-01 17:46:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (256, 14, 'Balance Fees Report With Remark', 'balance_fees_report_with_remark', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (257, 14, 'Balance Fees Statement', 'balance_fees_statement', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (258, 14, 'Daily Collection Report', 'daily_collection_report', 1, 0, 0, 0, '2019-10-25 03:55:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (259, 11, 'Fees Master', 'transport_fees_master', 1, 0, 1, 0, '2022-07-05 11:29:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (260, 11, 'Pickup Point', 'pickup_point', 1, 1, 1, 1, '2022-07-04 11:50:08');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (261, 11, 'Route Pickup Point', 'route_pickup_point', 1, 1, 1, 1, '2022-07-04 11:50:08');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (262, 11, 'Student Transport Fees', 'student_transport_fees', 1, 1, 1, 0, '2022-07-05 12:15:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (263, 29, 'Comments', 'lesson_plan_comments', 1, 1, 0, 1, '2020-05-29 00:20:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (264, 15, 'Sidebar Menu', 'sidebar_menu', 1, 0, 0, 0, '2022-07-11 14:01:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (265, 15, 'Currency', 'currency', 1, 0, 0, 0, '2020-08-21 07:36:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (266, 6, 'Exam Schedule', 'exam_schedule', 1, 0, 0, 0, '2019-11-24 01:58:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (267, 6, 'Generate Rank', 'generate_rank', 1, 0, 0, 0, '2019-11-24 07:15:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (268, 8, 'Content Type', 'content_type', 1, 1, 1, 1, '2022-07-08 07:18:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (269, 8, 'Content Share List', 'content_share_list', 1, 0, 0, 1, '2022-07-08 07:18:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (270, 8, 'Video Tutorial', 'video_tutorial', 1, 1, 1, 1, '2022-07-08 07:19:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (271, 15, 'Currency Switcher', 'currency_switcher', 1, 0, 0, 0, '2019-11-24 07:17:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (272, 2, 'Offline Bank Payments', 'offline_bank_payments', 1, 0, 0, 0, '2018-06-27 02:18:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (273, 29, 'Copy Old Lessons', 'copy_old_lesson', 1, 0, 0, 0, '2020-05-29 00:20:11');


#
# TABLE STRUCTURE FOR: permission_group
#

DROP TABLE IF EXISTS `permission_group`;

CREATE TABLE `permission_group` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int DEFAULT '0',
  `system` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb3;

INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (1, 'Student Information', 'student_information', 1, 1, '2019-03-15 11:30:22');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (2, 'Fees Collection', 'fees_collection', 1, 0, '2020-06-11 02:51:35');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (3, 'Income', 'income', 1, 0, '2020-06-01 03:57:39');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (4, 'Expense', 'expense', 1, 0, '2019-03-15 11:06:22');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (5, 'Student Attendance', 'student_attendance', 1, 0, '2018-07-02 09:48:08');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (6, 'Examination', 'examination', 1, 0, '2018-07-11 04:49:08');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (7, 'Academics', 'academics', 1, 1, '2018-07-02 09:25:43');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (8, 'Download Center', 'download_center', 1, 0, '2018-07-02 09:49:29');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (9, 'Library', 'library', 1, 0, '2018-06-28 13:13:14');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (10, 'Inventory', 'inventory', 1, 0, '2018-06-27 02:48:58');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (11, 'Transport', 'transport', 1, 0, '2018-06-27 09:51:26');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (12, 'Hostel', 'hostel', 1, 0, '2018-07-02 09:49:32');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (13, 'Communicate', 'communicate', 1, 0, '2018-07-02 09:50:00');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (14, 'Reports', 'reports', 1, 1, '2018-06-27 05:40:22');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (15, 'System Settings', 'system_settings', 1, 1, '2018-06-27 05:40:28');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (16, 'Front CMS', 'front_cms', 1, 0, '2018-07-10 07:16:54');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (17, 'Front Office', 'front_office', 1, 0, '2018-06-27 05:45:30');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (18, 'Human Resource', 'human_resource', 1, 1, '2018-06-27 05:41:02');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (19, 'Homework', 'homework', 1, 0, '2018-06-27 02:49:38');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (20, 'Certificate', 'certificate', 1, 0, '2018-06-27 09:51:29');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (21, 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '2019-03-15 11:06:25');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (22, 'Dashboard and Widgets', 'dashboard_and_widgets', 1, 1, '2018-06-27 05:41:17');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (23, 'Online Examination', 'online_examination', 1, 0, '2020-06-01 04:25:36');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (25, 'Chat', 'chat', 1, 0, '2019-11-24 01:54:04');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (26, 'Multi Class', 'multi_class', 1, 0, '2019-11-27 14:14:14');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (27, 'Online Admission', 'online_admission', 1, 0, '2019-11-27 04:42:13');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (28, 'Alumni', 'alumni', 1, 0, '2020-05-29 02:26:38');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES (29, 'Lesson Plan', 'lesson_plan', 1, 0, '2020-06-07 07:38:30');


#
# TABLE STRUCTURE FOR: permission_student
#

DROP TABLE IF EXISTS `permission_student`;

CREATE TABLE `permission_student` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) NOT NULL,
  `system` int NOT NULL,
  `student` int NOT NULL,
  `parent` int NOT NULL,
  `group_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `permission_student_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `permission_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb3;

INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (1, 'Fees', 'fees', 0, 1, 1, 2, '2020-06-11 02:51:35');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (2, 'Class Timetable', 'class_timetable', 1, 1, 1, 7, '2020-05-30 21:57:50');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (3, 'Homework', 'homework', 0, 1, 1, 19, '2020-06-01 04:49:14');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (4, 'Download Center', 'download_center', 0, 1, 1, 8, '2020-06-01 04:52:49');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (5, 'Attendance', 'attendance', 0, 1, 1, 5, '2020-06-01 04:57:18');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (7, 'Examinations', 'examinations', 0, 1, 1, 6, '2020-06-01 04:59:50');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (8, 'Notice Board', 'notice_board', 0, 1, 1, 13, '2020-06-01 05:00:35');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (11, 'Library', 'library', 0, 1, 1, 9, '2020-06-01 05:02:37');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (12, 'Transport Routes', 'transport_routes', 0, 1, 1, 11, '2020-06-01 05:51:30');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (13, 'Hostel Rooms', 'hostel_rooms', 0, 1, 1, 12, '2020-06-01 05:52:27');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (14, 'Calendar To Do List', 'calendar_to_do_list', 0, 1, 1, 21, '2020-06-01 05:53:18');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (15, 'Online Examination', 'online_examination', 0, 1, 1, 23, '2020-06-11 07:20:01');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (16, 'Teachers Rating', 'teachers_rating', 0, 1, 1, NULL, '2022-12-28 11:52:28');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (17, 'Chat', 'chat', 0, 1, 1, 25, '2020-06-01 06:53:06');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (18, 'Multi Class', 'multi_class', 1, 1, 1, 26, '2020-05-30 21:56:52');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (19, 'Lesson Plan', 'lesson_plan', 0, 1, 1, 29, '2020-06-07 07:38:30');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (20, 'Syllabus Status', 'syllabus_status', 0, 1, 1, 29, '2020-06-07 07:38:30');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (23, 'Apply Leave', 'apply_leave', 0, 1, 1, NULL, '2022-12-28 11:52:28');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (24, 'Visitor Book', 'visitor_book', 0, 1, 1, NULL, '2022-10-10 13:45:18');
INSERT INTO `permission_student` (`id`, `name`, `short_code`, `system`, `student`, `parent`, `group_id`, `created_at`) VALUES (25, 'Student Timeline', 'student_timeline', 0, 1, 1, NULL, '2022-10-11 06:50:29');


#
# TABLE STRUCTURE FOR: pickup_point
#

DROP TABLE IF EXISTS `pickup_point`;

CREATE TABLE `pickup_point` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `latitude` varchar(100) DEFAULT NULL,
  `longitude` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: print_headerfooter
#

DROP TABLE IF EXISTS `print_headerfooter`;

CREATE TABLE `print_headerfooter` (
  `id` int NOT NULL AUTO_INCREMENT,
  `print_type` varchar(255) NOT NULL,
  `header_image` varchar(255) NOT NULL,
  `footer_conten